<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 15/02/2019
 * Time: 12:57
 */

require_once "../classes/Comercial.php";
require_once "../funcoes/funcoes.php";
require_once "../classes/Clientes.php";
require_once "../classes/Dashboard_Adm.php";
require_once "../classes/Mk_Crm.php";


$comercial = new Comercial();
$clientes = new Clientes();
$instalados = new Dashboard_Adm();
$indicadoresCrm = new Mk_Crm();


$page = isset($_GET['page']) ? $_GET['page'] : '';
$data_i = isset($_POST['data_i']) ? $_POST['data_i'] : '';
$data_f = isset($_POST['data_f']) ? $_POST['data_f'] : '';
$instalados->carregarOS($data_i, $data_f);

$comercial->faturamento($data_i, $data_f);

if ($page == 'loadfaturamento') :
    $id = $_POST['id'];
    $days = $comercial->getDia(); ?>
    <div class="table-responsive row">
        <table class="font-13 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-<?php echo $id; ?>">
            <thead class="thead-default thead-lg">
            <tr class="text-uppercase">
                <th class="text-center"></th>
                <?php if (!empty($comercial->getDia())) {
                    foreach ($comercial->getDia() as $item) {
                        echo "<th class='text-center'>" . date('j', strtotime($item)) . "</th>";
                    }
                } ?>
            </tr>
            </thead>
            <tbody>
            <tr class="text-primary">
                <td class="text-center">Acumulado</td>
                <?php if (!empty($comercial->getAcumulado())) {
                    foreach ($comercial->getAcumulado() as $item) {
                        echo "<td class='font-strong'>" . formata_valor($item) . "</td>";
                    }
                } ?>
            </tr>
            <tr class="text-danger">
                <td class="text-center">Atraso</td>
                <?php
                for ($i = 0; $i < count($comercial->getAtraso()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Atraso')" class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($comercial->getAtraso()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            <tr>
                <td class="text-center">Mês</td>
                <?php
                for ($i = 0; $i < count($comercial->getMes()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Mes')" class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($comercial->getMes()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            <tr class="text-success">
                <td class="text-center">Total</td>
                <?php
                for ($i = 0; $i < count($comercial->getTotal()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Todos')" class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($comercial->getTotal()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            </tbody>
        </table>
    </div>
<?php elseif ($page == 'loadfaturamento_modal') :
    $id = $_POST['id'];

    $comercial->carregarfaturamento_Dia2($data_i, $id);

    ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modal-<?php echo $id; ?>">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Data</th>
                            <th class="text-center">Nome</th>
                            <th class="text-center">Status Pagto</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Valor</th>
                            <th class="text-center">Cod Fatura</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($comercial->getResult() as $item): ?>
                            <tr class="text-center">
                                <td><?php echo date('d/m/Y', strtotime($item['data_pagto'])); ?></td>
                                <td><?php echo utf8_encode($item['nome']); ?></td>
                                <td class="<?php if ($item['pagto'] == 'ATRASO') {
                                    echo "text-danger";
                                } else {
                                    echo "text-primary";
                                } ?>">
                                    <?php echo $item['pagto']; ?></td>
                                <td><?php echo $item['tipo']; ?></td>
                                <td><?php echo formata_valor($item['valor_pago']); ?></td>
                                <td><?php echo $item['codfatura']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadchart'):

    $array = array();

    foreach ($comercial->getResult() as $row) {

        array_push($array, ['data' => date('j', strtotime($row['data'])), 'valor' => $row['mes'] + $row['atraso']]);

    }

    echo json_encode($array);

    ?>
<?php elseif ($page == 'loadclientesnovos'):
    $tipo = $_POST['tipo'];
    $instalados->acumulados_mes($tipo, $data_i, $data_f); ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor
                        table-border-redenilfcolor table-hover" cellspacing="0" width="100%"
                           id="datatable-modalclientesnovos">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Instalacao</th>
                            <th class="text-center">Código</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Bairro</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($instalados->getAcumuladoAll())):
                            foreach ($instalados->getAcumuladoAll() as $item) :?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($item['data_fechamento'])); ?></td>
                                    <td><?php echo $item['codpessoa']; ?></td>
                                    <td><?php echo utf8_encode($item['nome_razaosocial']); ?></td>
                                    <td><?php echo unidade_financeira($item['tipo']); ?></td>
                                    <td><?php echo utf8_encode($item['bairro']); ?></td>
                                    <td><?php echo utf8_encode($item['cidade']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadclientesvendasdia'):
    $clientes->loadVendas_dia($_POST['grupo'], $_POST['segmento']);
    ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modalvendidodia">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Instalação</th>
                            <th class="text-center">Código</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Bairro</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($clientes->getVendidosDia())):
                            foreach ($clientes->getVendidosDia() as $item):; ?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($item['agenda'])); ?></td>
                                    <td><?php echo $item['codpessoa']; ?></td>
                                    <td><?php echo utf8_encode($item['nome_razaosocial']); ?></td>
                                    <td><?php echo unidade_financeira($item['tipo']); ?></td>
                                    <td><?php echo utf8_encode($item['bairro']); ?></td>
                                    <td><?php echo utf8_encode($item['cidade']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'formresumo'):
    $inicio = $_POST['inicio'];
    $fim = $_POST['fim'];

    function statusOS($string){

        $span = null;

        switch (utf8_encode($string)) {

            case 'INSTALAÇÃO':
                $span = '<span class="btn-icon-only btn-redenilf font-strong">
                                         <i class="la la-wrench" data-toggle="tooltip" title="Instalação"></i>
                                    </span><br/>';
                break;
            case 'MIGRAÇÃO':
                $span = ' <span class="btn-icon-only btn-redenilf font-strong">
                                         <i class="la la-angle-double-right" data-toggle="tooltip" title="Migração"></i>
                                    </span><br/>';
                break;
        }

        return $span;

    }
    ?>
    <div class="table-responsive row">
        <table class="table table-bordered table-hover table-head-info" id="datatable">
            <thead class="thead-lg">
            <tr>
                <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                <th class="text-center"><i class="mr-2 ti-location-pin"></i>Endereço</th>
                <th class="text-center"><i class="mr-2 ti-plus"></i>Produto</th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Vendedor</th>
                <th class="text-center"><i class="mr-2 ti-money"></i>Fatura</th>
                <th class="text-center"><i class="mr-2 ti-money"></i>Tipo</th>
                <th class="text-center"><i class="mr-2 ti-stats-up"></i>Instalação</th>
            </tr>
            </thead>
            <tbody class="font-13">
            <?php

            foreach ($indicadoresCrm->getResult() as $row) :
                if ($row['data_criacao'] >= $inicio && $row['data_criacao'] <= $fim
                    && strstr(unidade_financeira($row['unidade_financeira']), ' ') == ' Comercial'):
                    ?>


                    <tr class="text-center">
                        <td class="text-light font-strong"><?php echo date('d/m/Y', strtotime($row['data_criacao'])); ?></td>

                        <td>
                            <div class="mb-2">
                                <h6><?php echo utf8_encode($row['nome_razaosocial']); ?></h6>
                            </div>
                        </td>
                        <td>
                            <div class="mb-2">
                                <span class="font-strong text-light font-13">
                                    <?php echo utf8_encode($row['cidade']); ?>
                                </span>
                                <div class="divider my-2"></div>
                                <span>
                                    <small class="font-strong text-light font-12">
                                        <?php echo utf8_encode($row['bairro']); ?>
                                    </small>
                                </span>
                            </div>
                        </td>
                        <td class="text-center text-light font-strong">
                            <?php echo ($row['nomenclatura']);?>
                            <div class="divider my-2"></div>
                            <h6><?php echo utf8_encode($row['produto']); ?></h6>
                        </td>
                        <td>
                            <span class="font-strong text-light font-13">
                                    <?php echo utf8_encode($row['vendedor']); ?>
                                </span>
                            <div class="divider my-2"></div>
                            <span class="font-strong text-light font-13">
                                    <?php echo utf8_encode($row['origem']); ?>
                                </span>
                        </td>
                        <td>
                            <div class="mb-2">
                                <small class="font-bold">
                                    <span class="<?php echo statusLabel($row['adesao']) ?>">
                                        <?php echo utf8_encode($row['adesao']) ?>
                                    </span>
                                </small>
                                <div class="my-2 divider"></div>
                                <span class="font-bold">
                                    <?php echo utf8_encode($row['contrato']) ?>
                                </span>
                            </div>
                        </td>
                        <td>
                            <div class="mb-2">
                                <small class="font-bold">
                                    <?php echo statusOS($row['tipo_os']) ?>
                                    <?php echo utf8_encode($row['os']) ?>
                                </small>
                                <div class="my-2 divider"></div>
                                <small class="font-bold">
                                    <?php echo utf8_encode($row['tipo_os']) ?>
                                </small>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="mb-2">
                                <small class="font-bold">
                                    <span class="<?php echo statusLabel($row['classificacao']) ?>">
                                        <?php echo utf8_encode($row['classificacao']) ?>
                                    </span>
                                </small>
                                <div class="divider my-2"></div>
                                <span><small class="text-muted ml-2">
                                     <?php echo utf8_encode($row['instalacao'])?: null ?></small></span>
                            </div>
                        </td>
                    </tr>
                <?php
                endif;
            endforeach;
            ?>
            </tbody>
        </table>
    </div>

<?php elseif ($page == 'loadanual_carteira'): $clientes->loadcarteiraAno('COMERCIAL');
    echo $clientes->getTotalclientes(); ?>
<?php endif; ?>
