<?php
require_once "../classes/Comissoes.php";

$page = isset($_GET['page']) ? $_GET['page'] : '';

$comissoes = new Comissoes();
$dt_i = $_POST['inicio'];
$dt_f = $_POST['fim'];
$grupo = $_POST['grupo'];
$comissoes->carregarComissoes($dt_i, $dt_f);

if ($page == 'loadcomissoes'):

    $comissoes->carregarOperadoresGrupo($grupo);
    foreach ($comissoes->getOperadoresdogrupo() as $item):
        ?>
        <div class="col-md-4 col-sm-6 col-lg-5 col-xl-3">
            <div class="card mb-4 border border-redenilf">
                <div class="card-header bg-redenilf text-center">
                    <h1 class="mb-4 mt-3"><i class="ti-user"></i></h1>
                    <h6 class="card-title mb-2"><?php echo $item['operador'] ?></h6>
                    <small><?php echo $item['grupo']; ?></small>
                </div>
                <div class="card-body text-center">
                    <div class="d-flex align-items-center justify-content-center">
                        <div class="text-center">
                            <div class="h1 mb-1"><i class="la la-wifi text-primary" data-toggle="tooltip"
                                                    title="Rádio"></i>
                            </div>
                            <div class="text-redenilfcolor font-strong"><?php
                                $comissoes->carregarvendasOperadores($item['grupo'], $item['operador'], 'Rádio');
                                $comissao_radio = $comissoes->getResultGrupo();
                                echo $comissao_radio ?></div>
                            <h6 class="text-muted text-uppercase">Rádio</h6>

                        </div>
                        <div class="text-center ml-4">
                            <div class="h1 mb-1"><i class="la la-link text-redenilfcolor" data-toggle="tooltip"
                                                    title="Fibra"></i></div>
                            <div class="text-redenilfcolor font-strong"><?php
                                $comissoes->carregarvendasOperadores($item['grupo'], $item['operador'], 'Fibra');
                                $comissao_fibra = $comissoes->getResultGrupo();
                                echo $comissao_fibra;
                                ?></div>
                            <h6 class="text-muted text-uppercase">Fibra</h6>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <div class="d-flex justify-content-around align-items-center mt-2">
                        <div class="text-center">
                    <span class="badge badge-redenilf font-13" data-toggle="tooltip"
                          title="Comissão">TOTAL <?php echo $comissao_radio + $comissao_fibra ?></span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>

<?php elseif ($page == 'loadtabcomissoes'): ?>
    <div class="modal-body">
        <div class="table-responsive row">
            <table class="table table-bordered table-border-redenilfcolor
                table-hover table-head-redenilfcolor" id="datatable-comissao">
                <thead class="thead-default thead-lg">
                <tr>
                    <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                    <th class="text-center">Nome</th>
                    <th class="text-center">Grupo</th>
                    <th class="text-center"><i class="mr-2 ti-user"></i>Operador</th>
                    <th class="text-center">Tipo</th>
                    <th class="text-center">Mensalidade</th>
                </tr>
                </thead>
                <tbody>
                <?php if($grupo != 'ALL'): ?>
                <?php foreach ($comissoes->getResult() as $item):
                if($grupo == $item['grupo'] && $item['tipo'] == 'INSTALACAO'):?>
                <tr class="font-strong">
                    <td class="text-center"><?php echo  date('d/m/Y', strtotime($item['data']));?></td>
                    <td><?php echo utf8_encode($item['nome']);?></td>
                    <td class="text-center"><?php echo $item['grupo'];?></td>
                    <td class="text-center"><?php echo $item['operador']?></td>
                    <td class="text-center"><?php echo unidade_financeira($item['unidade_financeira']);?></td>
                    <td class="text-center"><?php echo formata_valor($item['vlr_renovacao']);?></td>
                </tr>
                <?php endif;?>
                <?php endforeach?>
                <?php else:;?>
                <?php foreach ($comissoes->getResult() as $item):?>
                <tr class="font-strong">
                    <td class="text-center"><?php echo  date('d/m/Y', strtotime($item['data']));?></td>
                    <td><?php echo utf8_encode($item['nome']);?></td>
                    <td class="text-center"><?php echo $item['grupo'];?></td>
                    <td class="text-center"><?php echo utf8_encode(strtolower($item['operador']))?></td>
                    <td class="text-center"><?php echo unidade_financeira($item['unidade_financeira']);?></td>
                    <td class="text-center"><?php echo formata_valor($item['vlr_renovacao']);?></td>
                </tr>
                <?php endforeach;?>
                <?php endif ?>
                </tbody>
            </table>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-redenilf" data-dismiss="modal">Fechar</button>
    </div>
<?php elseif ($page == 'loadcomissoes_externo'): ?>
        <div class="table-responsive row">
            <table class="font-13 table table-bordered table-border-redenilfcolor
                table-hover table-head-redenilfcolor" id="datatable-comissaoexterno">
                <thead class="thead-default thead-lg">
                <tr>
                    <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                    <th class="text-center">Código</th>
                    <th class="text-center">Nome</th>
                    <th class="text-center"><i class="mr-2 ti-user"></i>Vendedor</th>
                    <th class="text-center">Tipo</th>
                    <th class="text-center">Mensalidade</th>
                    <th class="text-center">Faturado</th>
                    <th class="text-center">Status</th>
                </tr>
                </thead>
                <tbody>
                <?php if(!empty($comissoes->getResultVendasexterno())) :
                        foreach ($comissoes->getResultVendasexterno() as $item):?>
                <tr class="font-strong <?php if ($item['faturado'] == 'SIM' && $item['pago em'] !== null){
                    echo 'bg-success text-white';}elseif ($item['faturado'] == 'SIM' && $item['pago em'] == null){
                        echo 'bg-warning text-white';}elseif (empty($item['faturado']) && $item['cancelado'] == 'S'){
                        echo 'bg-danger text-white';}?>">
                    <td class="text-center"><?php echo  date('d/m/Y', strtotime($item['data']));?></td>
                    <td class="text-center"><?php echo $item['codpessoa'];?></td>
                    <td><?php echo utf8_encode($item['nome']);?></td>
                    <td class="text-center"><?php echo utf8_encode(strtoupper($item['operador']));?></td>
                    <td class="text-center"><?php echo unidade_financeira($item['unidade_financeira']);?></td>
                    <td class="text-center"><?php echo formata_valor($item['vlr_renovacao']);?></td>
                    <td class="text-center font-strong">
                        <?php if(empty($item['faturado'])){ echo 'NÃO'; } else { echo $item['faturado'];}?></td>
                    <td class="text-center"><?php if(empty($item['faturado']) && $item['cancelado'] == 'S'){ echo 'CANCELADO';}
                        elseif (empty($item['pago em'])){ echo 'PENDENTE';}
                    else{ echo '<div><small>Pago</small></div>'.$item['pago em'];}?>
                    </td>
                </tr>
                <?php endforeach;?>
                <?php endif; ?>
                </tbody>
            </table>
        </div>
<?php endif; ?>
