<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 15/02/2019
 * Time: 12:57
 */

require_once "../classes/ISP.php";
require_once "../funcoes/funcoes.php";
require_once "../classes/Clientes.php";
require_once "../classes/Previsao.php";
require_once "../classes/Dashboard_Adm.php";


$isp = new ISP();
$clientes = new Clientes();
$previsao = new Previsao();
$instalados = new Dashboard_Adm();

$page = isset($_GET['page']) ? $_GET['page'] : '';
$data_i = isset($_POST['data_i']) ? $_POST['data_i'] : '';
$data_f = isset($_POST['data_f']) ? $_POST['data_f'] : '';
$instalados->carregarOS($data_i, $data_f);
$isp->faturamento($data_i, $data_f);

if ($page == 'loadfaturamento') :
    $id = $_POST['id'];
    $days = $isp->getDia(); ?>
    <div class="table-responsive row">
        <table class="font-13 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-<?php echo $id; ?>">
            <thead class="thead-default thead-lg">
            <tr class="text-uppercase">
                <th class="text-center"></th>
                <?php if (!empty($isp->getDia())) {
                    foreach ($isp->getDia() as $item) {
                        echo "<th class='text-center'>" . date('j', strtotime($item)) . "</th>";
                    }
                } ?>
            </tr>
            </thead>
            <tbody>
            <tr class="text-primary">
                <td class="text-center">Acumulado</td>
                <?php if (!empty($isp->getAcumulado())) {
                    foreach ($isp->getAcumulado() as $item) {
                        echo "<td class='font-strong'>" . formata_valor($item) . "</td>";
                    }
                } ?>
            </tr>
            <tr class="text-danger">
                <td class="text-center">Atraso</td>
                <?php if (!empty($isp->getAtraso()))
                    for ($i = 0; $i < count($isp->getAtraso()); $i++) :?>
                        <td onclick="modal_fat('<?php echo $days[$i]; ?>','Atraso')" class='font-strong'
                            style="cursor: pointer"
                            data-toggle="tooltip" title="Exibir Clientes">
                            <?php echo formata_valor($isp->getAtraso()[$i]); ?></td>
                    <?php endfor; ?>
            </tr>
            <tr>
                <td class="text-center la-wi">Mês</td>
                <?php if (!empty($isp->getMes()))
                    for ($i = 0; $i < count($isp->getMes()); $i++) :?>
                        <td onclick="modal_fat('<?php echo $days[$i]; ?>','Mes')" class='font-strong'
                            style="cursor: pointer"
                            data-toggle="tooltip" title="Exibir Clientes">
                            <?php echo formata_valor($isp->getMes()[$i]); ?></td>
                    <?php endfor; ?>
            </tr>
            <tr class="text-success">
                <td class="text-center">Total</td>
                <?php if (!empty($isp->getTotal()))
                    for ($i = 0; $i < count($isp->getTotal()); $i++) :?>
                        <td onclick="modal_fat('<?php echo $days[$i]; ?>','Todos')" class='font-strong'
                            style="cursor: pointer"
                            data-toggle="tooltip" title="Exibir Clientes">
                            <?php echo formata_valor($isp->getTotal()[$i]); ?></td>
                    <?php endfor; ?>
            </tr>
            </tbody>
        </table>
    </div>
<?php elseif ($page == 'loadfaturamento_modal') :
    $id = $_POST['id'];
    $isp->carregarfaturamento_Dia2($data_i, $id);

    ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modal-<?php echo $id; ?>">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Data</th>
                            <th class="text-center">Nome</th>
                            <th class="text-center">Status Pagto</th>
                            <th class="text-center">Valor</th>
                            <th class="text-center">Cod Fatura</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($isp->getResult() as $item): ?>
                            <tr class="text-center">
                                <td><?php echo date('d/m/Y', strtotime($item['data_pagto'])); ?></td>
                                <td><?php echo utf8_encode($item['nome']); ?></td>
                                <td class="<?php if ($item['pagto'] == 'ATRASO') {
                                    echo "text-danger";
                                } else {
                                    echo "text-primary";
                                } ?>">
                                    <?php echo $item['pagto']; ?></td>
                                <td><?php echo number_format($item['valor_pago']); ?></td>
                                <td><?php echo $item['codfatura']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadchart'):

    $array = array();

    foreach ($isp->getResult() as $row) {

        array_push($array, ['data' => date('j', strtotime($row['data'])), 'valor' => $row['mes'] + $row['atraso']]);

    }

    echo json_encode($array);

    ?>
<?php elseif ($page == 'loadclientesnovos'):
    $tipo = $_POST['tipo'];
    $instalados->acumulados_mes($tipo, $data_i, $data_f); ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor
                        table-border-redenilfcolor table-hover" cellspacing="0" width="100%"
                           id="datatable-modalclientesnovos">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Instalacao</th>
                            <th class="text-center">Código</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Bairro</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($instalados->getAcumuladoAll())):
                            foreach ($instalados->getAcumuladoAll() as $item) :?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($item['data_fechamento'])); ?></td>
                                    <td><?php echo $item['codpessoa']; ?></td>
                                    <td><?php echo utf8_encode($item['nome_razaosocial']); ?></td>
                                    <td><?php echo unidade_financeira($item['tipo']); ?></td>
                                    <td><?php echo utf8_encode($item['bairro']); ?></td>
                                    <td><?php echo utf8_encode($item['cidade']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadclientesvendasdia'):
    $clientes->loadVendas_dia($_POST['grupo'], $_POST['segmento']);
    ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modalvendidodia">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Instalação</th>
                            <th class="text-center">Código</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($clientes->getVendidosDia())):
                            foreach ($clientes->getVendidosDia() as $item):; ?>
                                <tr>
                                    <td><?php echo date('d/m/Y', strtotime($item['agenda'])); ?></td>
                                    <td><?php echo $item['codpessoa']; ?></td>
                                    <td><?php echo utf8_encode($item['nome_razaosocial']); ?></td>
                                    <td><?php echo unidade_financeira($item['tipo']); ?></td>
                                    <td><?php echo utf8_encode($item['bairro']); ?></td>
                                    <td><?php echo utf8_encode($item['cidade']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadclientesprevisao'): $previsao->carregarPrevisaoISP(); ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modalprevisao">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Código</th>
                            <th class="text-center">Razão Social</th>
                            <th class="text-center">Contrato</th>
                            <th class="text-center">Previsão</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if (!empty($previsao->getPrevisaolista())):
                            foreach ($previsao->getPrevisaolista() as $item):; ?>
                                <tr>
                                    <td><?php echo $item['cliente']; ?></td>
                                    <td><?php echo utf8_encode($item['nome_razaosocial']); ?></td>
                                    <td><?php echo $item['codcontrato']; ?></td>
                                    <td><?php echo formata_valor($item['previsao']); ?></td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadanual_carteira'): $clientes->loadcarteiraAno('ISP');
    echo $clientes->getTotalclientes(); ?>
<?php endif; ?>
