<?php
/**
 * Created by PhpStorm.
 * User: dgddias
 * Date: 09/08/2018
 * Time: 10:35
 */
include_once "../classes/Menus.class.php";
include_once "../classes/Icones.class.php";

$menus = new Menus();
$page = isset($_GET['page']) ? $_GET['page'] : '';

if ($page === 'edit'):
    $id = $_POST['id'];
    $menus->editarMenu($id) ?>
    <form class="form-info" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <?php foreach ($menus->getMenu() as $row): ?>
                <div class="row">
                    <div class="col-sm-2 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">ID</label>
                        <input name="id-menu" class="form-control form-control-air" type="text" readonly
                               value="<?php echo $id ?>">
                    </div>
                    <div class="col-sm-3 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">Menu</label>
                        <input name="nome-menu" id="nome-menu" class="form-control form-control-air" type="text"
                               value="<?php echo $row['nome']; ?>">
                    </div>
                    <div class="col-sm-3 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">Alias</label>
                        <input name="alias-menu" class="form-control form-control-air" type="text"
                               value="<?php echo $row['alias']; ?>">
                    </div>
                    <div class="col-sm-4 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">URL</label>
                        <input name="url-menu" id="url-menu" class="form-control form-control-air" oninput="autocomplete_page_editmenu()" type="text"
                               value="<?php echo $row['url']; ?>">
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Página Associada</label>
                        <input name="page-menu" id="page-menu" readonly class="form-control form-control-air"
                               type="text" value="<?php echo $row['menu_page']; ?>">
                    </div>
                    <div class="col-sm-3 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">Config Menu</label>
                        <select name="config-menu" class="form-control form-control-air">
                            <option <?php if ($row['menu_config'] == 'S') {
                                echo 'selected';
                            }; ?> value="S">SIM
                            </option>
                            <option <?php if ($row['menu_config'] == 'N') {
                                echo 'selected';
                            }; ?> value="N">NÃO
                            </option>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">Ícone</label>
                        <select name="icone-menu" id="icone-menu" class="selectpicker form-control form-control-air"
                                data-selected-text-format="value">
                            <?php $icone = new Icones();
                            foreach ($icone->getIcones() as $row_icon): ?>
                                <option value="<?php echo $row_icon['nome_icon']; ?>" <?php if ($row['icon'] == $row_icon['nome_icon']) {
                                    echo "selected";
                                }; ?>
                                        data-icon="<?php echo $row_icon['nome_icon']; ?> mr-1"><?php echo $row_icon['nome_icon']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            <button type="submit" class="btn btn-redenilf">Salvar</button>
        </div>
    </form>
<?php elseif ($page === 'save'):
    $id = $_POST['id-menu'];
    $menus->setNome($_POST['nome-menu']);
    $menus->setUrl($_POST['url-menu']);
    $menus->setAlias($_POST['alias-menu']);
    $menus->setIcone($_POST['icone-menu']);
    $menus->setMenuconfig($_POST['config-menu']);
    $menus->setPagina($_POST['page-menu']);

    echo $menus->salvarMenu($id); ?>

<?php elseif ($page === 'save_menu') :

    $menus->setNome($_POST['nome-menu']);
    $menus->setUrl($_POST['url-menu']);
    $menus->setAlias($_POST['alias-menu']);
    $menus->setIcone($_POST['icone-menu']);
    $menus->setMenuconfig($_POST['config-menu']);
    $menus->setPagina($_POST['page-menu']);

    echo $menus->addMenu(); ?>

<?php elseif ($page === 'delete'):
    $id = $_POST['id'];
    echo $menus->deleteMenu($id);
    ?>

<?php elseif ($page === 'add'): ?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <div class="row">
                    <div class="col-sm-6 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">Menu</label>
                        <input name="nome-menu" id="nome-new-menu" class="form-control form-control-air text-lowercase"
                               type="text"
                               placeholder="Nome do Menu">
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Alias
                            <small class="text-redenilfcolor">(Apelido)</small>
                        </label>
                        <input name="alias-menu" class="form-control form-control-air" type="text"
                               placeholder="Digite o Apelido">
                    </div>
                    <div class="col-sm-6 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">URL</label>
                        <input name="url-menu" id="url-new-menu" oninput="autocomplete_page_menu()"
                               class="form-control form-control-air text-lowercase" type="text"
                               placeholder="Digite a URL do menu">
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Página Associada</label>
                        <input name="page-menu" id="page-new-menu" readonly class="form-control form-control-air"
                               type="text">
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Ícone</label>
                        <select name="icone-menu" id="icone-new-menu" class="selectpicker form-control form-control-air"
                                data-selected-text-format="value">
                            <option value="">Selecione</option>
                            <?php $icone = new Icones();
                            foreach ($icone->getIcones() as $row_icon): ?>
                                <option value="<?php echo $row_icon['nome_icon']; ?>"
                                        data-icon="<?php echo $row_icon['nome_icon']; ?> mr-1"><?php echo $row_icon['nome_icon']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-sm-6 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">Config Menu</label>
                        <select name="config-menu" id="config-new-menu" class="form-control form-control-air">
                            <option value="">Selecione</option>
                            <option value="S">SIM</option>
                            <option value="N">NÃO</option>
                        </select>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary btn-fix" data-dismiss="modal"><span class="btn-icon"><i
                                class="la la-close"></i>Fechar</span></button>
                <button type="submit" class="btn btn-redenilf btn-fix"><span class="btn-icon"><i class="la la-save"></i>Salvar</span>
                </button>
            </div>
        </div>
    </form>
<?php else: ?>
    <div class="table-responsive row">
        <table class="table table-bordered table-head-redenilfcolor table-border-redenilfcolor table-hover" id="tabela-menu">
            <thead class="thead-default thead-lg">
            <tr>
                <th>ID</th>
                <th class="text-center" data-toggle="tooltip" data-placement="top"
                    title="Informa o Apelido, se não especificado, o sistema irá atribuir ao Sidebar o nome do menu em vez do Apelido">
                    Alias
                </th>
                <th class="text-center">Nome</th>
                <th class="text-center">URL</th>
                <th class="text-center">Ícone</th>
                <th class="text-center" data-toggle="tooltip" data-placement="top"
                    title="Informa se o Menu será de acesso Administrativo">Menu (ADM)
                </th>
                <th class="text-center no-sort"></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($menus->getMenu() as $row): ?>
                <tr class="font-strong">
                    <td class="text-center"><?php echo $row['id_menu']; ?></td>
                    <td class="text-center"><?php echo $row['alias']; ?></td>
                    <td class="text-center"><?php echo $row['nome']; ?></td>
                    <td class="text-center"><?php echo $row['url']; ?></td>
                    <td class="text-center"><?php echo $row['icon']; ?></td>
                    <td class="text-center"><?php echo $row['menu_config']; ?></td>
                    <td class="text-center"><a class="text-light mr-2 font-16"
                                               href="javascript:;"><i
                                    class="ti-pencil" data-toggle="tooltip"
                                    data-placement="top"
                                    onclick="editar_m(<?php echo $row['id_menu']; ?>,'<?php echo $row['nome'] ?>')"
                                    title="Editar"></i></a>
                        <a class="text-light font-16 mr-2" href="javascript:;"
                           onclick="excluir_m(<?php echo $row['id_menu']; ?>,'<?php echo $row['nome'] ?>')"><i
                                    class="ti-trash"
                                    data-toggle="tooltip"
                                    data-placement="top"
                                    title="Excluir"></i></a>
                        <a class="text-light font-16" disabled href="javascript:;"
                           onclick="permissoes(<?php echo $row['id_menu'];?>,'<?php echo $row['nome'];?>',<?php echo $row['cod_page'];?>)"><i
                                    class="ti-unlock"
                                    data-toggle="tooltip"
                                    data-placement="top"
                                    title="Permissões"></i></a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>
