<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 17/04/2019
 * Time: 16:01
 */

require_once "../classes/Projetos.php";
require_once "../funcoes/funcoes.php";
require_once "../classes/Tags.php";

$page = isset($_GET['page']) ? $_GET['page'] : '';
$ece = isset($_GET['ece']) ? $_GET['ece'] : '';
$data_i = isset($_POST['data_i']) ? $_POST['data_i'] : '';
$data_f = isset($_POST['data_f']) ? $_POST['data_f'] : '';
$codprojeto = isset($_POST['codprojeto']) ? $_POST['codprojeto'] : '';
$projeto = new Projetos($codprojeto);
$projeto->carregarFaturamento($data_i, $data_f, $codprojeto);

if ($page == 'loadprojetoform'):
    $projeto->loadallProjetos($ece);
    ?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox">
                <div class="ibox-body">
                    <div class="form-group">
                        <select class="selectpicker form-control" data-live-search="true"
                                id="selectproject" name="selectproject" title="Selecione">
                            <?php foreach ($projeto->getCidadesProjeto() as $city): ?>
                                <optgroup label="<?php echo $city; ?>">
                                    <?php foreach ($projeto->getProjetos() as $item):
                                        if ($city === $item['cidade']):?>
                                            <option class="font-bold" value="<?php echo $item['id_projeto']; ?>">
                                                <?php echo $item['projeto']; ?>
                                            </option>
                                        <?php endif; ?>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                    <button type="submit" class="btn btn-redenilf">Buscar</button>
                </div>
            </div>
        </div>
    </form>
<?php elseif ($page == 'loadfaturamentoProjeto'):

    $target = $_POST['id'];
    $days = $projeto->getDia(); ?>
    <div class="table-responsive row">
        <table class="font-13 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-<?php echo $target; ?>">
            <thead class="thead-default thead-lg">
            <tr class="text-uppercase">
                <th class="text-center"></th>
                <?php if (!empty($projeto->getDia())) {
                    foreach ($projeto->getDia() as $item) {
                        echo "<th class='text-center'>" . date('j', strtotime($item)) . "</th>";
                    }
                } ?>
            </tr>
            </thead>
            <tbody>
            <tr class="text-primary">
                <td class="text-center">Acumulado</td>
                <?php
                if (!empty($projeto->getAcumulado())) {
                    foreach ($projeto->getAcumulado() as $item) {
                        echo "<td class='font-strong'>" . formata_valor($item) . "</td>";
                    }
                } ?>
            </tr>
            <tr class="text-danger">
                <td class="text-center">Atraso</td>
                <?php
                for ($i = 0; $i < count($projeto->getAtraso()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Atraso', <?php echo $codprojeto; ?>)"
                        class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($projeto->getAtraso()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            <tr>
                <td class="text-center">Mês</td>
                <?php
                for ($i = 0; $i < count($projeto->getMes()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Mes', <?php echo $codprojeto; ?>)"
                        class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($projeto->getMes()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            <tr class="text-success">
                <td class="text-center">Total</td>
                <?php
                for ($i = 0; $i < count($projeto->getTotal()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Todos', <?php echo $codprojeto; ?>)"
                        class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($projeto->getTotal()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            </tbody>
        </table>
    </div>
<?php elseif ($page == 'loadfaturamento_modal'):
    $id = $_POST['id'];
    $projeto->carregarfaturamento_Dia($data_i, $id, $codprojeto);; ?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modal-<?php echo $id; ?>">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Data</th>
                            <th class="text-center">Nome</th>
                            <th class="text-center">Status Pagto</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Valor</th>
                            <th class="text-center">Cod Fatura</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($projeto->getResultFaturamento() as $item): ?>
                            <tr class="text-center">
                                <td><?php echo date('d/m/Y', strtotime($item['data_pagto'])); ?></td>
                                <td><?php echo utf8_encode($item['nome']); ?></td>
                                <td class="<?php if ($item['pagto'] == 'ATRASO') {
                                    echo "text-danger";
                                } else {
                                    echo "text-primary";
                                } ?>">
                                    <?php echo $item['pagto']; ?></td>
                                <td><?php echo $item['tipo']; ?></td>
                                <td><?php echo formata_valor($item['valor_pago']); ?></td>
                                <td><?php echo $item['codfatura']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadchartProjetos') :
    $array = array();
    foreach ($projeto->getResultFaturamento() as $row) {

        array_push($array, ['data' => date('j', strtotime($row['data'])), 'valor' => $row['mes'] +
            $row['atraso']]);

    }
    echo json_encode($array);
    ?>
<?php elseif ($page == 'evolucaocarteira'):

    $projeto->searchBase($codprojeto); //VERIFICAR E ATUALIZA O TOTAL DE CLIENTES DO PROJETO NA BASE ANUAL
    echo $projeto->getCarteiraAnual();
    ?>
<?php elseif ($page == 'loadfaturamentoAnual'):
    $projeto->loadfaturamentoAnual($codprojeto);
    echo $projeto->getFaturamentoanual();
    ?>
<?php elseif ($page == 'loadfaturamentototal'):
    $projeto->loadfaturamentoTotal($codprojeto);
    echo $projeto->getFaturamentototal();
    ?>
<?php elseif ($page == 'loadtabelaclientes'):
    $tag = new Tags();
    ?>
    <div class="table-responsive row">
        <table class="font-13 font-strong table table-bordered table-head-info
                 table-hover" cellspacing="0" width="100%" id="datatable-clientesprojeto">
            <thead class="thead-lg">
            <tr class="text-uppercase">
                <th class="text-center">Adesão</th>
                <th class="text-center">Cliente</th>
                <th class="text-center">CTO</th>
                <th class="text-center">Endereço</th>
                <th class="text-center">Cidade</th>
                <th class="text-center">Plano</th>
            </tr>
            </thead>
            <tbody>
            <?php if (!empty($projeto->getResult())):foreach ($projeto->getResult() as $item): ?>
                <tr class="text-center">
                    <td><?php echo date('d/m/Y', strtotime($item['adesao'])); ?></td>
                    <td>
                        <div class="mb-2">
                            <h6>
                                <span class="float-left">
                                <?php echo utf8_encode($item['nome_razaosocial']); ?>
                            </span>
                            </h6>
                            <br/>
                            <span>
                                    <small class="font-13 text-muted ml-1 float-left">
                                       Cod: <?php echo $item['codpessoa']; ?>
                                    </small>
                                <?php
                                $tag->loadTagsClient($item['codpessoa']);
                                if (!empty($tag->getTagclient())) :
                                    ?>
                                    <small class="font-13 text-muted ml-1">
                                      Tag: <?php echo implode(', ', $tag->getTagclient()); ?>
                                </small>
                                <?php endif; ?>
                                <small class="font-13 text-muted ml-1 float-right">
                                        <?php echo tipo_os($item['tipo_os']); ?>
                                </small>
                            </span>
                        </div>
                    </td>
                    <td>
                        <span>
                            <?php echo $item['cto']; ?></span>
                    </td>
                    <td class="text-center">
                        <div class="mb-2">
                            <span>
                        <?php echo utf8_encode($item['logradouro']); ?>
                            </span>
                            <div class="divider my-2"></div>
                            <span>
                                    <small class="font-strong text-light font-12">
                                        <?php echo utf8_encode($item['bairro']); ?>
                                    </small>
                                </span>
                        </div>
                    </td>
                    <td class="text-center">
                        <div class="mb-2">
                            <span>
                       <?php echo utf8_encode($item['cidade']); ?>
                            </span>
                            <div class="divider my-2"></div>
                            <span>
                                    <small class="font-strong text-light font-12">
                                        <?php echo $item['condominio']; ?>
                                    </small>
                                </span>
                            <div class="-columns"></div>
                        </div>
                    </td>
                    <td class="text-center">
                        <div class="mb-2">
                            <span>
                       <?php echo utf8_encode($item['plano']); ?>
                            </span>
                            <div class="divider my-2"></div>
                            <span>
                                    <small class="font-strong text-light font-12 ml-1">
                                        Valor: <?php echo formata_valor($item['vlr_renovacao']); ?>
                                    </small>
                                </span>
                            <span style="border-right:2px solid rgba(0,0,0,.1);"></span>
                            <span>
                                    <small class="ml-1 text-light font-12">
                                        Bloq: <?php echo $item['bloqueado']; ?>
                                    </small>
                                </span>
                            <div class="-columns"></div>
                        </div>
                    </td>
                </tr>
            <?php endforeach;
            endif; ?>
            </tbody>
        </table>
    </div>
<?php elseif ($page == 'getmarkers'):
    echo $projeto->getMarkers(); ?>
<?php endif; ?>
