<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 25/09/2018
 * Time: 10:06
 */
require_once "../classes/Submenu.class.php";
require_once "../classes/Menus.class.php";
require_once "../classes/Icones.class.php";

$submenu = new Submenu();
$page = isset($_GET['page']) ? $_GET['page'] : ''; ?>

<?php if ($page == 'formulario_novosub'):
    $menu = new Menus();
    $icone = new Icones(); ?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Menu Pai</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="fa fa-lock"></i></span>
                            <select name="menu-sub" class="form-control form-control-air" id="menu-sub">
                                <option value="">Selecione</option>
                                <?php foreach ($menu->getMenu() as $row_menu): ?>
                                    <option value="<?php echo $row_menu['id_menu'] ?>">
                                        <?php echo ucfirst($row_menu['alias']) ?: $row_menu['nome']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Icone</label>
                        <select name="icone-sub" id="icone-sub" class="selectpicker form-control form-control-air"
                                data-selected-text-format="value">
                            <option value="">Selecione</option>
                            <?php
                            foreach ($icone->getIcones() as $row_icon): ?>
                                <option value="<?php echo $row_icon['nome_icon']; ?>"
                                        data-icon="<?php echo $row_icon['nome_icon']; ?> mr-1"><?php echo $row_icon['nome_icon']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Nome</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-user"></i></span>
                            <input class="form-control form-control-air" name="nome-sub" id="nome-sub"
                                   type="text" placeholder="Nome do Submenu">
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">URL</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-user"></i></span>
                            <input class="form-control form-control-air" oninput="autocomplete_page_submenu()" name="url-sub"
                                   id="url-sub"
                                   type="text" placeholder="URL do Submenu">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Página</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-user"></i></span>
                            <input class="form-control form-control-air" name="page-sub" id="page-sub"
                                   readonly type="text">
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Apelido</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-user"></i></span>
                            <input class="form-control form-control-air" name="alias-sub" id="alias-sub"
                                   type="text" placeholder="Apelido do Submenu">
                        </div>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                <button type="submit" class="btn btn-redenilf">Salvar</button>
            </div>
        </div>
    </form>

<?php elseif ($page == 'addsub'):

    $id_menu = $_POST['menu-sub'];
    $submenu->setNomeSub($_POST['nome-sub']);
    $submenu->setUrlSub($_POST['url-sub']);
    $submenu->setIconeSub($_POST['icone-sub']);
    $submenu->setAliasSub($_POST['alias-sub']);
    $submenu->setPageSub($_POST['page-sub']);
    echo $submenu->inserir_sub($id_menu);

?>
<?php elseif($page == 'formulario_sub'):
     $id_sub = $_POST['id_sub'];
     $menu = new Menus();
     $icone = new Icones();
     $submenu->buscarSubmenu($id_sub);
    ?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <div class="row">
                    <?php foreach ($submenu->getSubmenu() as $row): ?>
                    <div class="col-sm-2 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">ID</label>
                        <input name="id-submenu" id="id-submenu" class="form-control form-control-air" type="text"
                               value="<?php echo $row['id_submenu']; ?>">
                    </div>
                    <div class="col-sm-5 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">Nome</label>
                        <input name="nome-submenu" id="nome-submenu"
                               class="form-control form-control-air text-lowercase" type="text"
                               value="<?php echo $row['nome']; ?>">
                    </div>
                    <div class="col-sm-5 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Menu Pai</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="fa fa-lock"></i></span>
                            <select name="menu-submenu" class="form-control form-control-air" id="menu-submenu">
                                <?php foreach ($menu->getMenu() as $row_menu): ?>
                                    <option value="<?php echo $row_menu['id_menu']?>" <?php
                                        if($row_menu['id_menu'] == $row['cod_menu']){echo "selected";}?>>
                                        <?php echo ucfirst($row_menu['alias']) ?: $row_menu['nome']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4 pad_r">
                        <label class="text-redenilfcolor font-strong">URL</label>
                        <input name="url-submenu" class="form-control form-control-air text-lowercase" id="url-submenu" type="text"
                               value="<?php echo $row['url']; ?>">
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Ícone</label>
                        <select name="icone-submenu" class="selectpicker form-control form-control-air"
                                data-selected-text-format="value">
                            <option value="">Selecione</option>
                            <?php $icone = new Icones();
                            foreach ($icone->getIcones() as $row_icon): ?>
                                <option value="<?php echo $row_icon['nome_icon']; ?>" <?php if ($row['icon'] == $row_icon['nome_icon']) {
                                    echo "selected";
                                }; ?>
                                        data-icon="<?php echo $row_icon['nome_icon']; ?> mr-1"><?php echo $row_icon['nome_icon']; ?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Alias</label>
                        <input name="alias-submenu" class="form-control form-control-air" type="text"
                               value="<?php echo $row['alias']; ?>">
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Pagina</label>
                        <input name="page-submenu" readonly class="form-control form-control-air" id="page-submenu" type="text"
                               value="<?php echo $row['sub_page']; ?>">
                    </div>
                </div>
                <?php endforeach;
                ?>
            </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            <button type="submit" class="btn btn-redenilf">Salvar</button>
        </div>
    </form>
<?php elseif($page == 'editsub'):

    $id_sub = $_POST['id-submenu'];
    $submenu->setNomeSub($_POST['nome-submenu']);
    $submenu->setMenupai($_POST['menu-submenu']);
    $submenu->setUrlSub($_POST['url-submenu']);
    $submenu->setIconeSub($_POST['icone-submenu']);
    $submenu->setAliasSub($_POST['alias-submenu']);
    $submenu->setPageSub($_POST['page-submenu']);
    echo $submenu->editar_sub($id_sub);
    ?>
<?php elseif($page == 'delete_sub'):

    $id_sub = $_POST['id'];
     echo $submenu->remover_sub($id_sub);
    ?>
<?php else: ?>
    <div class="table-responsive">
        <table class="table table-bordered table-head-redenilfcolor table-border-redenilfcolor table-hover"
               id="tabela-submenu">
            <thead class="thead-default thead-lg">
            <tr>
                <th>ID</th>
                <th class="text-center" data-toggle="tooltip" data-placement="top"
                    title="Informa o Apelido, se não especificado, o sistema irá atribuir ao Sidebar o nome do menu em vez do Apelido">
                    Alias
                </th>
                <th class="text-center">Menu Pai</th>
                <th class="text-center">SubMenu</th>
                <th class="text-center">Página</th>
                <th class="text-center">URL</th>
                <th class="text-center">Ícone</th>
                               <th class="text-center no-sort"></th>
            </tr>
            </thead>
            <tbody>
            <?php
            if (!empty($submenu->getSubmenu())):
                foreach ($submenu->getSubmenu() as $row) : ?>
                    <tr class="font-strong">
                        <td><?php echo $row['id_submenu']; ?></td>
                        <td><?php echo $row['alias']; ?></td>
                        <td><?php echo ucfirst($row['menu_alias'])?:$row['menu'] ?></td>
                        <td><?php echo $row['nome']; ?></td>
                        <td><?php echo $row['sub_page']; ?><br/>
                        <td><?php echo $row['url']; ?></td>
                        <td><?php echo $row['icon']; ?></td>
                        <td><a class="text-light mr-2 font-16"
                               href="javascript:;"
                               onclick="formulario_editarSubmenu(<?php echo $row['id_submenu']; ?>)"><i
                                        class="ti-pencil" data-toggle="tooltip"
                                        data-placement="top"
                                        title="Editar"></i>
                            </a>
                            <a class="text-light font-16 mr-2" href="javascript:;"
                               onclick="remover_sub(<?php echo $row['id_submenu'];?>,'<?php echo $row['nome'];?>')"><i
                                        class="ti-trash"
                                        data-toggle="tooltip"
                                        data-placement="top"
                                        title="Remover"></i>
                            </a>
                            <a class="text-light font-16" disabled href="javascript:;"
                               onclick="permissoes_sub(<?php echo $row['id_submenu'];?>,'<?php echo $row['nome'];?>',<?php echo $row['cod_page'];?>)"><i
                                        class="ti-unlock"
                                        data-toggle="tooltip"
                                        data-placement="top"
                                        title="Permissões"></i></a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
            </tbody>
            </tbody>
        </table>
    </div>
<?php endif; ?>