<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 18/09/2018
 * Time: 15:30
 */
require_once "../classes/UsuariosConfig.php";
require_once "../classes/GrupoAcesso.class.php";
require_once "../classes/DepartamentosConfig.php";
require_once "../classes/Cidades_Filiais.php";

$usuarios = new Usuarios();
$grupos = new GrupoAcesso();
$departamento = new Departamentos();
$cidade_filiais = new Cidades_Filiais();

$page = isset($_GET['page']) ? $_GET['page'] : '';

//editar usuário
if ($page === 'formulario_edituser') :
    $id_user = $_POST['id'];
    $usuarios->editar($id_user); ?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <?php foreach ($usuarios->getArray() as $usuario): ?>
                    <div class="row">
                        <div class="col-sm-2 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">ID</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="ti-pin"></i></span>
                                <input class="form-control form-control-air" type="text" name="id-edituser" readonly
                                       value="<?php echo $usuario['id']; ?>">
                            </div>
                        </div>
                        <div class="col-sm-5 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">Nome</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="ti-user"></i></span>
                                <input class="form-control form-control-air" name="nome-user" id="nome-edituser"
                                       value="<?php echo $usuario['nome']; ?>" type="text">
                            </div>
                        </div>
                        <div class="col-sm-5 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">Email</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="ti-email"></i></span>
                                <input class="form-control form-control-air" name="email-user" type="email"
                                       id="email-edituser"
                                       value="<?php echo $usuario['email']; ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">Login</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="ti-unlock"></i></span>
                                <input class="form-control form-control-air" type="text" readonly
                                       value="<?php echo $usuario['login']; ?>">
                            </div>
                        </div>
                        <div class="col-sm-6 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">Cargo</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="fa fa-building-o"></i></span>
                                <input class="form-control form-control-air" type="text" name="cargo-user"
                                       id="cargo-edituser"
                                       value="<?php echo $usuario['cargo']; ?>">
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-sm-6 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">Grupo</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="fa fa-lock"></i></span>
                                <select name="grupo-user" class="form-control form-control-air" id="grupo-edituser">
                                    <?php foreach ($grupos->getGrupos() as $grupos): ?>
                                        <option value="<?php echo $grupos['id'] ?>"<?php if
                                        ($usuario['nome_nivel'] == $grupos['nome_nivel']) {
                                            echo "selected";
                                        }; ?>>
                                            <?php echo $grupos['nome_nivel']; ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">Departamento</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="fa fa-building"></i></span>
                                <select name="departamento-user" class="form-control form-control-air"
                                        id="departamento-edituser">
                                    <option value=""> Selecione o Departamento</option>
                                    <?php foreach ($departamento->getDepartamentos() as $departamento): ?>
                                    <option value="<?php echo $departamento['id_dep']; ?>"
                                        <?php if ($departamento['id_dep'] == $usuario['cod_dep']) {
                                            echo "selected";
                                        }; ?>><?php echo $departamento['nome_dep']; ?>
                                        <?php endforeach; ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                        <div class="col-sm-6 form-group mb-4">
                            <label class="text-redenilfcolor font-strong">Cidade</label>
                            <div class="input-group-icon input-group-icon-left">
                                <span class="input-icon input-icon-left"><i class="fa fa-building"></i></span>
                                <select name="cidade-user" class="form-control form-control-air"
                                        id="cidade-edituser">
                                    <option value=""> Selecione a Cidade</option>
                                    <?php foreach ($cidade_filiais->getCidadesFil() as $cidade): ?>
                                    <option value="<?php echo $cidade['idcidade']; ?>"
                                        <?php if ($cidade['idcidade'] == $usuario['codcidade']) {
                                            echo "selected";
                                        }; ?>><?php echo $cidade['cidade']; ?>
                                        <?php endforeach; ?>
                                    </option>
                                </select>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
                <button type="submit" class="btn btn-redenilf">Salvar</button>
            </div>
        </div>
    </form>

<?php elseif ($page == 'save_edituser'):
//salvar edição
    $id_user = $_POST['id-edituser'];
    $usuarios->setNome($_POST['nome-user']);
    $usuarios->setEmail($_POST['email-user']);
    $usuarios->setCargo($_POST['cargo-user']);
    $usuarios->setGrupo($_POST['grupo-user']);
    $usuarios->setDepartamento($_POST['departamento-user']);
    $usuarios->setCidade($_POST['cidade-user']);
    echo $usuarios->salvar_edit($id_user); ?>

<?php elseif ($page == 'formulario_novouser'):
//novo usuário?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Nome</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-user"></i></span>
                            <input class="form-control form-control-air" name="nome-user" id="nome-user"
                                   type="text" placeholder="Digite o Nome">
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Email</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-email"></i></span>
                            <input class="form-control form-control-air" name="email-user" type="email"
                                   id="email-user" placeholder="Digite o Email">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Login</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-unlock"></i></span>
                            <input class="form-control form-control-air" type="text" name="login-user"
                                   placeholder="Digite o Login"
                                   id="login-user">
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Senha</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="ti-key"></i></span>
                            <input class="form-control form-control-air" type="password" name="password-user"
                                   placeholder="Digite a Senha"
                                   id="password-user">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Grupo</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="fa fa-lock"></i></span>
                            <select name="grupo-user" class="form-control form-control-air" id="grupo-user">
                                <option value="">Selecione</option>
                                <?php foreach ($grupos->getGrupos() as $grupos): ?>
                                    <option value="<?php echo $grupos['id'] ?>">
                                        <?php echo $grupos['nome_nivel']; ?></option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Departamento</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="fa fa-building"></i></span>
                            <select name="departamento-user" class="form-control form-control-air"
                                    id="departamento-user">
                                <option value=""> Selecione</option>
                                <?php foreach ($departamento->getDepartamentos() as $departamento): ?>
                                    <option value="<?php echo $departamento['id_dep']; ?>">
                                        <?php echo $departamento['nome_dep']; ?>
                                    </option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Cargo</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="fa fa-building-o"></i></span>
                            <input class="form-control form-control-air" type="text" name="cargo-user"
                                   placeholder="Digite o Cargo"
                                   id="cargo-user">
                        </div>
                    </div>
                    <div class="col-sm-6 form-group mb-4">
                        <label class="text-redenilfcolor font-strong">Cidade</label>
                        <div class="input-group-icon input-group-icon-left">
                            <span class="input-icon input-icon-left"><i class="fa fa-map-o"></i></span>
                            <select name="cidade-user" class="form-control form-control-air"
                                    id="cidade-user">
                                <option value=""> Selecione</option>
                                <?php if (!empty($cidade_filiais->getCidadesFil())):
                                    foreach ($cidade_filiais->getCidadesFil() as $cidade): ?>
                                        <option value="<?php echo $cidade['idcidade']; ?>">
                                            <?php echo $cidade['cidade']; ?>
                                        </option>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </select>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            <button type="submit" class="btn btn-redenilf">Salvar</button>
        </div>
        </div>
    </form>

<?php elseif ($page == 'delete_user'):
    $id_user = $_POST['id'];
    echo $usuarios->excluir($id_user); ?>

<?php elseif ($page == 'save_user') :

    $usuarios->setNome($_POST['nome-user']);
    $usuarios->setEmail($_POST['email-user']);
    $usuarios->setLogin($_POST['login-user']);
    $usuarios->setPassword(md5($_POST['password-user']));
    $usuarios->setCargo($_POST['cargo-user']);
    $usuarios->setDepartamento($_POST['departamento-user']);
    $usuarios->setCidade($_POST['cidade-user']);
    $usuarios->setGrupo($_POST['grupo-user']);
    echo $usuarios->inserir();

    ?>
<?php else:
    $usuarios->carregar(); ?>
    <div class="table-responsive row">
        <table class="font-13 table table-bordered table-head-redenilfcolor table-border-redenilfcolor table-hover"
               id="tabela-usuarios">
            <thead class="thead-default thead-lg">
            <tr>
                <th>ID</th>
                <th class="text-center">Nome</th>
                <th class="text-center">Email</th>
                <th class="text-center">Login</th>
                <th class="text-center">Grupo</th>
                <th class="text-center">Data Cadastro</th>
                <th class="text-center">Última Alteração</th>
                <th class="text-center">Cargo</th>
                <th class="text-center">Departamento</th>
                <th class="text-center">Cidade</th>
                <th class="text-center no-sort"></th>
            </tr>
            </thead>
            <tbody>
            <?php foreach ($usuarios->getArray() as $row): ?>
                <tr class="font-strong">
                    <td class="text-center"><?php echo $row['id']; ?></td>
                    <td class="text-center"><?php echo $row['nome']; ?></td>
                    <td class="text-center"><?php echo $row['email']; ?></td>
                    <td class="text-center"><?php echo $row['login']; ?></td>
                    <td class="text-center"><?php echo $row['nome_nivel']; ?></td>
                    <td class="text-center"><?php echo date('d-m-Y', strtotime($row['data_cadastro'])); ?></td>
                    <td class="text-center"><?php if (!empty($row['data_alteracao'])) {
                            echo date('d-m-Y', strtotime($row['data_alteracao']));
                        } else {
                            echo "";
                        } ?></td>
                    <td class="text-center"><?php echo $row['cargo']; ?></td>
                    <td class="text-center"><?php echo $row['nome_dep']; ?><br/>
                        <small>Home: <?php echo $row['pagina_home']; ?></small>
                    </td>
                    <td class="text-center"><?php echo $row['cidade']; ?></td>
                    <td class="text-center"><a class="text-light mr-2 font-16"
                                               href="javascript:;"><i
                                    class="ti-pencil" data-toggle="tooltip"
                                    data-placement="top"
                                    onclick="formulario_user(<?php echo $row['id']; ?>)"
                                    title="Editar"></i></a>
                        <a class="text-light font-16 mr-2" href="javascript:;"
                           onclick="deletar_user(<?php echo $row['id']; ?>,'<?php echo $row['nome'] ?>')"><i
                                    class="ti-trash"
                                    data-toggle="tooltip"
                                    data-placement="top"
                                    title="Excluir"></i>
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
<?php endif; ?>