<?php
require_once "../classes/Cobranca.php";
require_once "../funcoes/funcoes.php";
$cobranca = new Cobranca();

$page = isset($_GET['page']) ? $_GET['page'] : '';

// CARREGA DADOS PARA GERACAO DO GRAFICO DE COBRANÇA
$dadosChartCobranca = $cobranca->chartSemana();
$cobranca->chartCobrancaAnualLiquidados();

$dadosChartAnual = $cobranca->getAnualLiquidados();
?>

<!-- DADOS DO GRAFICO DE COBRANÇA -->
<script type="text/javascript">
  const label = "<?php echo implode(',', $dadosChartCobranca['label'])?>";
  const data_liquidados = "<?php echo implode(',', $dadosChartCobranca['liquidados'])?>";
  const data_negociacao = "<?php echo implode(',', $dadosChartCobranca['negociacao'])?>";
  const data_spc = "<?php echo implode(',', $dadosChartCobranca['spc'])?>";
</script>

<!-- DADOS DO GRAFICO ANUAL -->
<script type="text/javascript">
  const label_anual = "<?php echo implode(',', $dadosChartAnual['label'])?>";
  const label2_anual = "<?php echo implode(',', $dadosChartAnual['label_2'])?>";
  const data_total = "<?php echo implode(',', $dadosChartAnual['total'])?>";
  const data_total2 = "<?php echo implode(',', $dadosChartAnual['total2'])?>";
  const data_valor_liquidado = "<?php echo implode(',', $dadosChartAnual['valorliquidado'])?>";
  const data_valor_spc = "<?php echo implode(',', $dadosChartAnual['valorspc'])?>";
</script>

<div class="page-content fade-in-up">

    <div class="row">
        <div class="col-lg-7">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Gerenciamento de Cobranças</div>
                    <div class="ibox-tools">
                        <i class="fa fa-calendar mr-2"></i>
                        <span class="h5" style="font-weight: 500">
                            <?php echo exibe_mes(date('m')) ?></i>
                        </span>
                    </div>
                </div>
                <div class="ibox-body">
                    <div id="data-chart-cobranca">
                        <canvas id="chart_cobranca" style="height:260px;"></canvas>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="text-muted mb-4">Detalhes do Acordo</div>
                    <div class="row">
                        <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="mb-4">Iniciados</div>
                            <span class="h4 mr-3">
                                <i class="fa fa-handshake-o text-primary h1 mb-0 mr-2"></i>
                                <span><?php echo count($cobranca->getTotalMes()) ?> </span>
                            </span>


                        </div>
                        <div class="col-6 text-center">
                            <div class="mb-4">Liquidados</div>
                            <span class="h4 mr-3">
                                <i class="fa fa-handshake-o text-success h1 mb-0 mr-2"></i>
                                <span><?php echo count($cobranca->getLiquidados()) ?></span>
                            </span>

                        </div>
                    </div>
                    <hr>
                    <div class="row">
                        <div class="col-3 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="text-muted">Liquidados</div>
                            <h5 class="text-success mt-1">R$ <?php
                                echo formata_valor(array_sum(array_column($cobranca->getLiquidados(), 'valor'))) ?>
                            </h5>
                        </div>
                        <div class="col-3 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="text-muted">Sem Acordo</div>
                            <h5 class="mt-1 text-danger">R$
                                <?php echo formata_valor(array_sum(array_column($cobranca->getNaoLiquidados(), 'valor'))) ?>
                            </h5>
                        </div>
                        <div class="col-3 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="text-muted">Em Negociação</div>
                            <h5 class="mt-1 text-warning"> R$
                                <?php echo formata_valor(array_sum(array_column($cobranca->getAguardandoLiquidados(), 'valor'))) ?>
                            </h5>
                        </div>
                        <div class="col-3 text-center">
                            <div class="text-muted">Total</div>
                            <h5 class="text-primary mt-1">R$
                                <?php echo formata_valor($cobranca->getTotal()) ?>
                            </h5>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-lg-5">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Equipamentos</div>
                    <div class="ibox-tools">
                        <i class="fa fa-calendar mr-2"></i>
                        <span class="h5" style="font-weight: 500">
                            <?php echo exibe_mes(date('m')) ?></i>
                        </span>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="h2 m-0"><?php echo ($cobranca->getTotalEquipameentos()) ?><i
                                class="ti-stats-up float-right text-success font-40"></i>
                    </div>
                    <div class="text-muted m-t-5">Total de Equipamentos</div>
                    <div class="my-4">
                        <div class="h4 m-0"><?php echo count($cobranca->getEquipamentoRetirado()) ?></div>
                        <div class="flexbox">
                            <small>Retirados</small>
                            <span class="text-success font-12" style="font-size: 12px;"><i class="fa fa-level-up"></i> <?php echo formata_valor($cobranca->getResultadoRetirados()) ?> %</span>
                        </div>
                        <div class="progress mt-1">
                            <div class="progress-bar bg-success" role="progressbar" style="width:<?php echo $cobranca->getResultadoRetirados() ?>%; height:5px;"
                                 aria-valuenow="52" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                    <div class="mb-4">
                        <div class="h4 m-0"><?php echo count($cobranca->getEquipamentoPerdido()) ?></div>
                        <div class="flexbox">
                            <small>Perdidos</small>
                            <span class="text-warning font-12" style="font-size: 12px;"><i class="fa fa-level-down"></i> -<?php echo formata_valor($cobranca->getResultadoPerdidos()) ?>%</span>
                        </div>
                        <div class="progress mt-1">
                            <div class="progress-bar bg-danger" role="progressbar" style="width:<?php echo $cobranca->getResultadoPerdidos() ?>%; height:5px;"
                                 aria-valuenow="45" aria-valuemin="0" aria-valuemax="100"></div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Acordos Realizados no Ano</div>
                </div>
                <div class="ibox-body">
                    <div class="row">
                        <div class="col-lg-12">
                            <canvas id="chart_cobranca_anual" style="height:80px;"></canvas>
                        </div>
                        <div class="ml-4" style="margin-top: 21px">
                            <h4 class="text-success ml-1">R$ <?php
                                echo formata_valor(array_sum($cobranca->getAnualLiquidados()['valorliquidado'])) ?>
                            </h4>
                            <div class="text-muted">
                                <span class="text-success mr-2"><i class="ti-stats-up mr-1"></i></span>Acumulados Liquidados
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>


