<?php
/**
 * Created by PhpStorm.
 * User: suporte
 * Date: 08/01/2019
 * Time: 11:21
 */

require_once "../../classes/Logradouro.php";
$logradouro = new Logradouro();
$logradouro->loadaddress();

$page = isset($_GET['page']) ? $_GET['page'] : '';

if ($page == 'add'):?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <div class="row">
                    <div class="col-sm-12 form-group">
                        <label class="text-redenilfcolor font-strong">Logradouro</label>
                        <input name="name-address" class="form-control form-control-air text-uppercase"
                               type="text">
                    </div>
                    <div class="col-sm-6 form-group">
                        <label class="text-redenilfcolor font-strong">Bairro</label>
                        <input name="name-bairro" class="form-control form-control-air text-uppercase"
                               type="text">
                    </div>
                    <div class="col-sm-6 form-group">
                        <label class="text-redenilfcolor font-strong">Cidade</label>
                        <input name="name-city" class="form-control form-control-air"
                               type="text">
                    </div>
                    <div class="col-sm-6 form-group">
                        <label class="text-redenilfcolor font-strong">Latitude</label>
                        <input name="name-lat" class="form-control form-control-air text-uppercase"
                               type="text">
                    </div>
                    <div class="col-sm-6 form-group">
                        <label class="text-redenilfcolor font-strong">Longitude</label>
                        <input name="name-long" class="form-control form-control-air text-uppercase"
                               type="text">
                    </div>
                </div>
            </div>
        </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            <button type="submit" class="btn btn-redenilf">Salvar</button>
        </div>
    </form>

<?php elseif ($page == 'saveadd'):
    $logradouro->setLogradouro(strtoupper($_POST['name-address']));
    $logradouro->setBairro(strtoupper($_POST['name-bairro']));
    $logradouro->setCidade($_POST['name-city']);
    $logradouro->setLatitude($_POST['name-lat']);
    $logradouro->setLongitude($_POST['name-long']);
    echo $logradouro->insert(); ?>

<?php elseif ($page == 'edit'):
    $id = $_POST['id'];
    $logradouro->loadedit($id); ?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <?php foreach ($logradouro->getArray() as $item): ?>
                    <div class="row">
                        <div class="col-sm-12 form-group">
                            <label class="text-redenilfcolor font-strong">Logradouro</label>
                            <input type="hidden" name="id" value="<?php echo $item['id'] ?>">
                            <input name="name-address" class="form-control form-control-air text-uppercase"
                                   type="text" value="<?php echo $item['logradouro'] ?>">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="text-redenilfcolor font-strong">Bairro</label>
                            <input name="name-bairro" class="form-control form-control-air text-uppercase"
                                   type="text" value="<?php echo $item['bairro'] ?>">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="text-redenilfcolor font-strong">Cidade</label>
                            <input name="name-city" class="form-control form-control-air"
                                   type="text" value="<?php echo $item['cidade'] ?>">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="text-redenilfcolor font-strong">Latitude</label>
                            <input name="name-lat" class="form-control form-control-air text-uppercase"
                                   type="text" value="<?php echo $item['lat'] ?>">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="text-redenilfcolor font-strong">Longitude</label>
                            <input name="name-long" class="form-control form-control-air text-uppercase"
                                   type="text" value="<?php echo $item['lng'] ?>">
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            <button type="submit" class="btn btn-redenilf">Salvar</button>
        </div>
    </form>

<?php elseif ($page == 'saveedit'):
    $id = $_POST['id'];
    $logradouro->setLogradouro($_POST['name-address']);
    $logradouro->setBairro($_POST['name-bairro']);
    $logradouro->setCidade($_POST['name-city']);
    $logradouro->setLatitude($_POST['name-lat']);
    $logradouro->setLongitude($_POST['name-long']);
    echo $logradouro->salvar_edit($id);
    ?>


<?php elseif ($page == 'delete'):
    $id = $_POST['id'];
    $logradouro->loadedit($id); ?>
    <form class="form-success" action="javascript:;">
        <div class="modal-body">
            <div class="ibox-body">
                <?php foreach ($logradouro->getArray() as $item): ?>
                    <div class="row">
                        <div class="col-sm-12 form-group">
                            <label class="text-redenilfcolor font-strong">Logradouro</label>
                            <input type="hidden" name="id" value="<?php echo $item['id'] ?>">
                            <input name="name-address" class="form-control form-control-air text-uppercase"
                                   type="text" value="<?php echo $item['logradouro'] ?>">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="text-redenilfcolor font-strong">Bairro</label>
                            <input name="name-bairro" class="form-control form-control-air text-uppercase"
                                   type="text" value="<?php echo $item['bairro'] ?>">
                        </div>
                        <div class="col-sm-6 form-group">
                            <label class="text-redenilfcolor font-strong">Cidade</label>
                            <input name="name-city" class="form-control form-control-air text-uppercase"
                                   type="text" value="<?php echo $item['cidade'] ?>">
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-dismiss="modal">Fechar</button>
            <button type="submit" class="btn btn-danger">Deletar</button>
        </div>
    </form>

<?php elseif ($page == 'savedelete'):
    $id = $_POST['id'];
    echo $logradouro->del_address($id);
     ?>

<?php
else:
    ?>
    <div class="table-responsive row">
        <table class="font-13 table table-bordered table-head-redenilfcolor table-border-redenilfcolor table-hover"
               id="tabela-logradouro">
            <thead class="thead-default thead-lg">
            <tr>
                <th class="text-center">ID</th>
                <th class="text-center">Logradouro</th>
                <th class="text-center">Bairro</th>
                <th class="text-center">Lat</th>
                <th class="text-center">Long</th>
                <th class="text-center">Cidade</th>
                <th class="text-center no-sort"></th>
            </tr>
            </thead>
            <tbody>

            <?php
            if (!empty($logradouro->getArray())):
                foreach ($logradouro->getArray() as $item):
                    ?>
                    <tr class="font-strong">
                        <td class="text-center"><?php echo $item['id']; ?></td>
                        <td class="text-center"><?php echo $item['logradouro']; ?></td>
                        <td class="text-center"><?php echo $item['bairro']; ?></td>
                        <td class="text-center"><?php echo $item['lat']; ?></td>
                        <td class="text-center"><?php echo $item['lng']; ?></td>
                        <td class="text-center"><?php echo $item['cidade']; ?></td>
                        <td class="text-center"><a class="text-light mr-2"
                                                   href="javascript:;"><i
                                        class="ti-pencil" data-toggle="tooltip"
                                        data-placement="top"
                                        onclick="edit_address(<?php echo $item['id']; ?>)"
                                        title="Editar"></i></a>
                            <a class="text-light mr-2" href="javascript:;"
                               onclick="delete_address(<?php echo $item['id']; ?>)"><i
                                        class="ti-trash"
                                        data-toggle="tooltip"
                                        data-placement="top"
                                        title="Excluir"></i></a>
                        </td>
                    </tr>
                <?php
                endforeach;
                ?>
            <?php endif; ?>
            </tbody>
        </table>
    </div>
<?php
endif; ?>

