<?php
header("Content-type: text/xml");

/*Busca os markers no BD e transforma o resulta em XML*/
include_once "../../classes/Markers.php";

$markers = new Markers();

function parseToXML($htmlStr)
{
    $xmlStr = str_replace('<', '&lt;', $htmlStr);
    $xmlStr = str_replace('>', '&gt;', $xmlStr);
    $xmlStr = str_replace('"', '&quot;', $xmlStr);
    $xmlStr = str_replace("'", '&#39;', $xmlStr);
    $xmlStr = str_replace("&", '&amp;', $xmlStr);
    return $xmlStr;
}

// Select all the rows in the markers table
$markers->loadmarkers();

// Start XML file, echo parent node
    echo '<markers>';

// Iterate through the rows, printing XML nodes for each
    foreach ($markers->getArray() as $row) {

        // Add to XML document node
        echo '<marker ';
        echo 'name="' . parseToXML($row['name']) . '" ';
        echo 'address="' . parseToXML($row['address']) . '" ';
        echo 'bairro="' . parseToXML($row['bairro']) . '" ';
        echo 'lat="' . $row['lat'] . '" ';
        echo 'lng="' . $row['lng'] . '" ';
        echo 'type="' . $row['type'] . '" ';
        echo '/>';
    }

// End XML file
    echo '</markers>';

?>