<?php
require_once "../../classes/Residencia.php";
require_once "../../classes/Previsao.php";
require_once "../../funcoes/funcoes.php";

//primeiro dia do mes
$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
// ultimo dia do mes
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

// primeiro dia do mes retrasado
$dt_i3 = date('d-m-Y', mktime(0, 0, 0, date('m') - 2,
    1, date('Y')));
// ultimo dia do mes retrasado
$dt_f3 = date('d-m-Y', mktime(23, 59, 59, date('m') - 1,
    date('d') - date('j'), date('Y')));

// primeiro dia do mes passado
$dt_i2 = date('d-m-Y', mktime(0, 0, 0, date('m') - 1,
    1, date('Y')));
// ultimo dia do mes passado
$dt_f2 = date('d-m-Y', mktime(0, 0, 0, date('m'),
    date('d') - date('j'), date('Y')));

$page = isset($_GET['page']) ? $_GET['page'] : '';

$data_i = isset($_POST['data_i']) ? $_POST['data_i'] : '';
$data_f = isset($_POST['data_f']) ? $_POST['data_f'] : '';

$residencial = new Residencia();
$previsao = new Previsao();


$residencial->faturamento($data_i, $data_f);

if ($page == 'loadfaturamento') :
    $id = $_POST['id'];
    $days = $residencial->getDia(); ?>

<!-- START TABELA DE FATURAMENTO -->
    <div class="table-responsive row">
        <table class="font-13 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-<?php echo $id; ?>">
            <thead class="thead-default thead-lg">
            <tr class="text-uppercase">
                <th class="text-center"></th>
                <?php if (!empty($residencial->getDia())) {
                    foreach ($residencial->getDia() as $item) {
                        echo "<th class='text-center'>" . date('j', strtotime($item)) . "</th>";
                    }
                } ?>
            </tr>
            </thead>
            <tbody>
            <tr class="text-primary">
                <td class="text-center">Acumulado</td>
                <?php if (!empty($residencial->getAcumulado())) {
                    foreach ($residencial->getAcumulado() as $item) {
                        echo "<td class='font-strong'>" . formata_valor($item) . "</td>";
                    }
                } ?>
            </tr>
            <tr class="text-danger">
                <td class="text-center">Atraso</td>
                <?php
                for ($i = 0; $i < count($residencial->getAtraso()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Atraso')" class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($residencial->getAtraso()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            <tr>
                <td class="text-center">Mês</td>
                <?php
                for ($i = 0; $i < count($residencial->getMes()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Mes')" class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($residencial->getMes()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            <tr class="text-success">
                <td class="text-center">Total</td>
                <?php
                for ($i = 0; $i < count($residencial->getTotal()); $i++) :?>
                    <td onclick="modal_fat('<?php echo $days[$i]; ?>','Todos')" class='font-strong'
                        style="cursor: pointer"
                        data-toggle="tooltip" title="Exibir Clientes">
                        <?php echo formata_valor($residencial->getTotal()[$i]); ?></td>
                <?php endfor; ?>
            </tr>
            </tbody>
        </table>
    </div>
<!-- END TABELA DE FATURAMENTO -->


<?php elseif ($page == 'loadfaturamento_modal') :
    $id = $_POST['id'];
    $residencial->carregarfaturamento_Dia2($data_i, $id);

    ?>

 <!-- START MODAL FATURAMENTO CLIENTES DO DIA -->
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modal-<?php echo $id; ?>">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Data</th>
                            <th class="text-center">Nome</th>
                            <th class="text-center">Status Pagto</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Valor</th>
                            <th class="text-center">Cod Fatura</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php foreach ($residencial->getResult() as $item): ?>
                            <tr class="text-center">
                                <td><?php echo date('d/m/Y', strtotime($item['data_pagto'])); ?></td>
                                <td><?php echo utf8_encode($item['nome']); ?></td>
                                <td class="<?php if ($item['pagto'] == 'ATRASO') {
                                    echo "text-danger";
                                } else {
                                    echo "text-primary";
                                } ?>">
                                    <?php echo $item['pagto']; ?></td>
                                <td><?php echo $item['tipo']; ?></td>
                                <td><?php echo formata_valor($item['valor_pago']); ?></td>
                                <td><?php echo $item['codfatura']; ?></td>
                            </tr>
                        <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
 <!-- END MODAL FATURAMENTO CLIENTES DO DIA -->


<?php elseif ($page == 'loadchart'):

    $array = array();

    foreach ($residencial->getResult() as $row) {

        array_push($array, ['data' => date('j', strtotime($row['data'])), 'valor' => $row['mes'] + $row['atraso']]);

    }
    echo json_encode($array); ?>
<?php else: $previsao->carregarPrevisaoRes();
    ?>
    <!-- START CARTÕES DE PREVISÃO -->
    <div class="row">
        <?php $residencial->faturamento($dt_i3, $dt_f3);
        $previsao->buscaPrevisao('RESIDENCIAL',
            exibe_mes(date('m', strtotime($dt_f3))), date('Y', strtotime('-2 months'))); ?>
        <div class="col-sm-6 col-md-4 col-lg-4">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                                strtotime($dt_f3))); ?></span></div>
                    <div class="ibox-tools">
                        <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="row m-b-20">
                        <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="text-muted">NO MÊS</div>
                            <div class="h6 text-success mt-1">
                                R$ <?php echo formata_valor(array_sum($residencial->getMes())); ?>
                            </div>
                        </div>
                        <div class="col-6 text-center">
                            <div class="text-muted">ATRASO</div>
                            <div class="h6 text-danger mt-1">
                                R$ <?php echo formata_valor(array_sum($residencial->getAtraso())) ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                    <h6 class="text-center text-uppercase text-white">
                        Previsão: <?php echo formata_valor($previsao->getResult()); ?></h6>
                </div>
                <div class="ibox-body bg-success">
                    <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php echo formata_valor(array_sum($residencial->getMes())
                                                + array_sum($residencial->getAtraso())) ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php echo round((($previsao->getResult() -
                                                        array_sum($residencial->getMes())) /
                                                    $previsao->getResult()) * 100); ?>%</span>
                                    </span>
                    </div>
                    <div>
                        <canvas id="chart_a" style="height:147px;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <?php $residencial->faturamento($dt_i2, $dt_f2);
        $previsao->buscaPrevisao('RESIDENCIAL', exibe_mes(date('m', strtotime($dt_f2))),
            date('Y', strtotime('-1 month'))); ?>
        <div class="col-sm-6 col-md-4 col-lg-4">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                                strtotime($dt_f2))); ?></span></div>
                    <div class="ibox-tools">
                        <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="row m-b-20">
                        <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="text-muted">NO MÊS</div>
                            <div class="h6 text-success mt-1">
                                R$ <?php echo formata_valor(array_sum($residencial->getMes())); ?>
                            </div>
                        </div>
                        <div class="col-6 text-center">
                            <div class="text-muted">ATRASO</div>
                            <div class="h6 text-danger mt-1">
                                R$ <?php echo formata_valor(array_sum($residencial->getAtraso())); ?>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                    <h6 class="text-center text-uppercase text-white">Previsão:
                        R$ <?php echo formata_valor($previsao->getResult()); ?></h6>
                </div>
                <div class="ibox-body bg-success">
                    <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php echo formata_valor(array_sum($residencial->getMes())
                                                + array_sum($residencial->getAtraso())) ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php echo round((($previsao->getResult() -
                                                        array_sum($residencial->getMes())) /
                                                    $previsao->getResult()) * 100); ?>%</span>
                                    </span>
                    </div>
                    <div>
                        <canvas id="chart_b" style="height:147px;"></canvas>
                    </div>
                </div>
            </div>
        </div>
        <?php $residencial->faturamento($dt_i, $dt_f);
        $previsao->buscaPrevisao('RESIDENCIAL', exibe_mes(date('m'))); ?>
        <div class="col-sm-6 col-md-4 col-lg-4">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m')); ?>
                    </span></div>
                    <div class="ibox-tools">
                        <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="row m-b-20">
                        <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="text-muted">NO MÊS</div>
                            <div class="h6 text-success mt-1">
                                R$ <?php if (!empty($residencial->getMes())) {
                                    echo formata_valor(array_sum($residencial->getMes()));
                                } else {
                                    echo 0;
                                } ?></div>
                        </div>
                        <div class="col-6 text-center">
                            <div class="text-muted">ATRASO</div>
                            <div class="h6 text-danger mt-1">
                                R$ <?php if (!empty($residencial->getAtraso())) {
                                    echo formata_valor(array_sum($residencial->getAtraso()));
                                } else {
                                    echo 0;
                                } ?></div>
                        </div>
                    </div>
                </div>
                <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                    <h6 class="text-center text-uppercase text-white">Previsão:
                        R$ <?php echo formata_valor($previsao->getResult()); ?></h6>
                </div>
                <div class="ibox-body bg-success">
                    <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if (!empty($residencial->getAcumulado())) {
                                                echo formata_valor(array_sum($residencial->getMes())
                                                    + array_sum($residencial->getAtraso()));
                                            } else {
                                                echo 0;
                                            } ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="A Faturar">
                                            <i class="ti-stats-up text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php if (!empty($residencial->getAcumulado())) {
                                                echo round((($previsao->getResult() -
                                                            array_sum($residencial->getMes())) /
                                                        $previsao->getResult()) * 100);
                                            } else {
                                                echo 0;
                                            } ?>%</span>
                                    </span>
                    </div>
                    <div>
                        <canvas id="chart_c" style="height:147px;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END CARTÕES DE PREVISÃO -->



<?php endif; ?>
