<?php
require_once "../../classes/Clientes.php";
require_once "../../classes/Dashboard_Adm.php";
require_once "../../funcoes/funcoes.php";
require_once "../../classes/Mk_Crm.php";



$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
$data_4 = date('Y-m-d', mktime(23, 59, 59, date('m') +1,
    date("t"), date('Y')));
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));

//PEGA primeiro do mes 3 MESES ATRÁS
$date_3 = date('Y-m-d', mktime(0, 0, 0, date('m') - 3,
    1, date('Y')));

$page = isset($_GET['page']) ? $_GET['page'] : '';

$data_i = isset($_POST['data_i']) ? $_POST['data_i'] : '';
$data_f = isset($_POST['data_f']) ? $_POST['data_f'] : '';


$clientes = new Clientes();
$instalados = new Dashboard_Adm();
$instalados->carregarOS($dt_i, $data_4);
$indicadores = new Clientes();
$indicadoresCrm = new Mk_Crm();


?>
<?php if($page == 'loadclientesnovos') :
    $tipo = $_POST['tipo'];
    $instalados->acumulados_mes($tipo, $data_i, $data_f);?>
    <div class="modal-body">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor
                        table-border-redenilfcolor table-hover" cellspacing="0" width="100%" id="datatable-modalclientesnovos">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Instalacao</th>
                            <th class="text-center">Código</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Bairro</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if(!empty($instalados->getAcumuladoAll())):
                            foreach ($instalados->getAcumuladoAll() as $item) :?>
                                <tr>
                                    <td><?php echo date('d/m/Y',  strtotime($item['data_fechamento']));?></td>
                                    <td><?php echo $item['codpessoa'];?></td>
                                    <td><?php echo utf8_encode($item['nome_razaosocial']);?></td>
                                    <td><?php echo unidade_financeira($item['tipo']);?></td>
                                    <td><?php echo utf8_encode($item['bairro']);?></td>
                                    <td><?php echo utf8_encode($item['cidade']);?></td>
                                </tr>
                            <?php endforeach;?>
                        <?php endif;?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif($page == 'loadclientesvendasdia'):
    $clientes->loadVendas_dia($_POST['grupo'],$_POST['segmento']);
    ?>
    <div class="modal-body .modal-xl">
        <div class="ibox">
            <div class="ibox-body">
                <div class="table-responsive row">
                    <table class="font-11 font-strong table table-bordered table-head-redenilfcolor table-border-redenilfcolor
                 table-hover" cellspacing="0" width="100%" id="datatable-modalvendidodia">
                        <thead class="thead-default thead-lg">
                        <tr class="text-uppercase">
                            <th class="text-center">Instalação</th>
                            <th class="text-center">Código</th>
                            <th class="text-center">Cliente</th>
                            <th class="text-center">Tipo</th>
                            <th class="text-center">Plano de Contas</th>
                            <th class="text-center">Plano</th>
                            <th class="text-center">Bairro</th>
                            <th class="text-center">Cidade</th>
                        </tr>
                        </thead>
                        <tbody>
                        <?php if(!empty($clientes->getVendidosDia())):
                            foreach ($clientes->getVendidosDia() as $item):;?>
                                <tr>
                                    <td><?php echo $item['agenda'];?></td>
                                    <td><?php echo $item['codpessoa'];?></td>
                                    <td><?php echo utf8_encode($item['nome_razaosocial']);?></td>
                                    <td><?php echo unidade_financeira($item['tipo']);?></td>
                                    <td><?php echo $item['planocontas'];?></td>
                                    <td><?php echo $item['plano'];?></td>
                                    <td><?php echo utf8_encode($item['bairro']);?></td>
                                    <td><?php echo utf8_encode($item['cidade']);?></td>
                                </tr>
                            <?php endforeach;?>
                        <?php endif;?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
<?php elseif ($page == 'loadanual_carteira'):
    $clientes->loadcarteiraAno('RESIDENCIAL');
    echo $clientes->getTotalclientes();?>
<?php elseif ($page == 'formresumo'):

   $inicio = $_POST['inicio'];
   $fim = $_POST['fim'];


    function statusOS($string){

        $span = null;

        switch (utf8_encode($string)) {

            case 'INSTALAÇÃO':
                $span = '<span class="btn-icon-only btn-redenilf font-strong">
                                         <i class="la la-wrench" data-toggle="tooltip" title="Instalação"></i>
                                    </span><br/>';
                break;
            case 'MIGRAÇÃO':
                $span = ' <span class="btn-icon-only btn-redenilf font-strong">
                                         <i class="la la-angle-double-right" data-toggle="tooltip" title="Migração"></i>
                                    </span><br/>';
                break;
        }

        return $span;

    }

    ?>

    <div class="table-responsive row">
        <table class="table table-bordered table-hover table-head-info" id="datatable">
            <thead class="thead-lg">
            <tr>
                <th class="text-center"><i class="fa fa-calendar-plus-o"></i></th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Cliente</th>
                <th class="text-center"><i class="mr-2 ti-location-pin"></i>Endereço</th>
                <th class="text-center"><i class="mr-2 ti-plus"></i>Produto</th>
                <th class="text-center"><i class="mr-2 ti-user"></i>Vendedor</th>
                <th class="text-center"><i class="mr-2 ti-money"></i>Fatura</th>
                <th class="text-center"><i class="mr-2 ti-money"></i>Tipo</th>
                <th class="text-center"><i class="mr-2 ti-stats-up"></i>Instalação</th>
            </tr>
            </thead>
            <tbody class="font-13">
            <?php

            foreach ($indicadoresCrm->getResult() as $row) :
                if ($row['data_criacao'] >= $inicio && $row['data_criacao'] <= $fim
                && strstr(unidade_financeira($row['unidade_financeira']), ' ') == ' Residencial'
                ) :
                    ?>
                    <tr class="text-center">
                        <td class="text-light font-strong"><?php echo date('d/m/Y', strtotime($row['data_criacao'])); ?></td>

                        <td>
                            <div class="mb-2">
                                <h6><?php echo utf8_encode($row['nome_razaosocial']); ?></h6>
                            </div>
                        </td>
                        <td>
                            <div class="mb-2">
                                <span class="font-strong text-light font-13">
                                    <?php echo utf8_encode($row['cidade']); ?>
                                </span>
                                <div class="divider my-2"></div>
                                <span>
                                    <small class="font-strong text-light font-12">
                                        <?php echo utf8_encode($row['bairro']); ?>
                                    </small>
                                </span>
                            </div>
                        </td>
                        <td class="text-center text-light font-strong">
                            <?php echo ($row['nomenclatura']);?>
                                <div class="divider my-2"></div>
                                <h6><?php echo utf8_encode($row['produto']); ?></h6>
                        </td>
                        <td>
                            <span class="font-strong text-light font-13">
                                    <?php echo utf8_encode($row['vendedor']); ?>
                                </span>
                            <div class="divider my-2"></div>
                            <span class="font-strong text-light font-13">
                                    <?php echo utf8_encode($row['origem']); ?>
                                </span>
                        </td>
                        <td>
                            <div class="mb-2">
                                <small class="font-bold">
                                    <span class="<?php echo statusLabel($row['adesao']) ?>">
                                        <?php echo utf8_encode($row['adesao']) ?>
                                    </span>
                                </small>
                                <div class="my-2 divider"></div>
                                <span class="font-bold">
                                    <?php echo utf8_encode($row['contrato']) ?>
                                </span>
                            </div>
                        </td>
                        <td>
                            <div class="mb-2">
                                <small class="font-bold">
                                    <?php echo statusOS($row['tipo_os']) ?>
                                    <?php echo utf8_encode($row['os']) ?>
                                </small>
                                <div class="my-2 divider"></div>
                                <small class="font-bold">
                                    <?php echo utf8_encode($row['tipo_os']) ?>
                                </small>
                            </div>
                        </td>
                        <td class="text-center">
                            <div class="mb-2">
                                <small class="font-bold">
                                    <span class="<?php echo statusLabel($row['classificacao']) ?>">
                                        <?php echo utf8_encode($row['classificacao']) ?>
                                    </span>
                                </small>
                                <div class="divider my-2"></div>
                                <span><small class="text-muted ml-2">
                                     <?php echo utf8_encode($row['instalacao'])?: null ?></small></span>
                            </div>
                        </td>
                    </tr>
                <?php
                endif;
            endforeach;
            ?>
            </tbody>
        </table>
    </div>

<?php else: ?>
<div class="row mb-4">
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-info text-white"><i class="ti-user"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira(nomenclatura('Residencial'), 1);
                        echo number_format($clientes->getTotalclientes(), 0, ',', '.'); ?>
                    </h4>
                    <small>USUÁRIOS</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-info" data-toggle="tooltip" title="Total Residencial Instalados
                    neste mês" onclick="clientesNovos('Residencial', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $instalados->acumulados_mes('Residencial', $dt_i, $dt_f);
                            echo $instalados->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-primary text-white"><i class="la la-wifi"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('Rádio');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>RÁDIO</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-primary" data-toggle="tooltip" title="Rádio Instalados
                    neste mês" onclick="clientesNovos('Rádio Residencial', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $instalados->acumulados_mes('Rádio Residencial', $dt_i, $dt_f);
                        echo $instalados->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-success text-white"><i class="la la-link"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('Fibra');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>FIBRA</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-success" data-toggle="tooltip" title="Fibra Instaladas
                    neste mês" onclick="clientesNovos('Fibra Residencial', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $instalados->acumulados_mes('Fibra Residencial', $dt_i, $dt_f);
                        echo $instalados->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-warning text-white"><i class="ti-calendar"></i>
                    <h4 class="m-0"><?php $instalados->pendente_tipo('Residencial', $dt_i, $dt_f);
                        echo $instalados->getPendenteTipo();?>
                    </h4>
                    <small>AGUARDANDO</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-warning" data-toggle="tooltip" title="Vendas cadastradas e agendadas
                    realizadas na data de hoje" onclick="vendasDia(32,3)"
                        style="cursor: pointer">
                        <?php
                        //GRUPO CAC-Vendas MK = 32 e grupo atendimento residencial = 3
                        $clientes->loadVendas_dia(32, 3);
                        if(!empty($clientes->getVendidosDia())){
                        echo count($clientes->getVendidosDia());
                        }else{
                            echo 0;
                        }?>
                    </h4>
                    <div class="text-muted font-13">VENDAS HOJE</div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php endif; ?>
