<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 02/10/2018
 * Time: 12:18
 */

function exibe_mes($a)
{

    if (strlen($a) > 3) {
        $me = date('m', strtotime($a));
    } else {
        $me = $a;
    }
    switch (date($me)) {
        case "01":
            $me = 'Janeiro';
            break;
        case "02":
            $me = 'Fevereiro';
            break;
        case "03":
            $me = 'Março';
            break;
        case "04":
            $me = 'Abril';
            break;
        case "05":
            $me = 'Maio';
            break;
        case "06":
            $me = 'Junho';
            break;
        case "07":
            $me = 'Julho';
            break;
        case "08":
            $me = 'Agosto';
            break;
        case "09":
            $me = 'Setembro';
            break;
        case "10":
            $me = 'Outubro';
            break;
        case "11":
            $me = 'Novembro';
            break;
        case "12":
            $me = 'Dezembro';
            break;
    }

    return $me;
}

//FUNÇAO QUE RETORNA O TIPO DE ACORDO COM A SUA NOMENCLATURA
function unidade_financeira($nomenclatura)
{

    if (empty($nomenclatura)) {

        return 'Sem Contrato';
    }
    //Identifica a nomenclatura
    $tipo = substr($nomenclatura, 0, 5);

    // Unidades Residenciais
    $residencial = ['03.01', '03.06', '03.04'];
    $residencial_cortesia = '03.01.01.02';
    $residencial_fibra = '03.06';
    $residencial_cable = '03.04';

    // Unidades Comerciais
    $comercial = '03.02';
    $comercial_fibra = '03.02.06';
    $comercial_cortesia = '03.02.02';

    // Unidades Empresariais
    $empresarial = '03.03';
    $empresarial_cortesia = '03.03.04';
    $empresarial_fibra = ['03.03.13', '03.03.14', '03.03.15', '03.03.18', '03.03.24', '03.03.21', '03.03.20'];

    // Unidades ISP
    $isp = '03.08';
    $isp_linkip = '03.08.01';
    $isp_linkbgp = '03.08.02';
    $isp_lantolan = '03.08.03';
    $isp_trasnporteptt = '03.08.04';
    $isp_cortesia = '03.08.05';

    // Unidade Genérica
    $interfone = '03.07';


    //Classificacao das nomenclaturas do residencial
    if (in_array($tipo, $residencial)) {

        if (strstr($nomenclatura, $residencial_cortesia)) {

            return 'Cortesia';

        } elseif (strstr($nomenclatura, $residencial_fibra)) {

            return 'Fibra Residencial';

        } elseif (strstr($nomenclatura, $residencial_cable)) {

            return 'Fibra Residencial';

        } else {

            return 'Rádio Residencial';
        }
    }

    //Classificacao das nomenclaturas do comercial
    if ($tipo == $comercial) {

        if (strstr($nomenclatura, $comercial_cortesia)) {

            return "Cortesia";

        } elseif (strstr($nomenclatura, $comercial_fibra)) {

            return 'Fibra Comercial';

        } else {

            return 'Rádio Comercial';
        }
    }

    //Classificacao das nomenclaturas do empresarial
    if ($tipo == $empresarial) {

        if (strstr($nomenclatura, $empresarial_cortesia)) {

            return 'Cortesia';

        } elseif (in_array($nomenclatura, $empresarial_fibra)) {

            return 'Fibra Empresarial';

        } else {

            return 'Rádio Empresarial';
        }
    }

    //Classificacao das nomenclaturas do empresarial
    if ($tipo == $isp) {

        if (strstr($nomenclatura, $isp_cortesia)) {

            return 'Cortesia';
        }

        if (strstr($nomenclatura, $isp_linkip)) {

            return 'Fibra LINK IP ISP';

        } elseif (strstr($nomenclatura, $isp_linkbgp)) {


            return 'Fibra LINK BGP ISP';

        } elseif (strstr($nomenclatura, $isp_lantolan)) {


            return 'Fibra LAN TO LAN ISP';

        } else {


            return 'Fibra TRANSPORTE PTT ISP';
        }
    }


    //Classificacao das nomenclaturas genéricas
    if ($tipo == $interfone) {

        return 'Interfone';
    }

}

function empresa($planodecontas)
{

    if (empty($planodecontas)) {

        return 'Sem Contrato';
    }

    $technet = ['03.01.03', '03.02.06.00', '03.03.24', '03.03.25', '03.06.24', '03.07.02'];
    $redenilf = ['03.01', '03.02', '03.04'];
    $cross = ['03.02.06', '03.06', '03.03'];


    if (in_array($planodecontas, $technet)) {

        $empresa = 'Technet';

    } elseif ($planodecontas !== '03.02.06' && in_array(substr($planodecontas, 0, 5), $redenilf)) {

        $empresa = 'Redenilf';


    } elseif ($planodecontas === '03.02.06' || in_array(substr($planodecontas, 0, 5), $cross)) {


        $empresa = 'Cross';

    } else {
        $empresa = 'Não definida';
    }

    return $empresa;

}

//FUNCAO QUE RETORNA A NOMENCLATURA DE ACORDO COM O TIPO
function nomenclatura($tipo)
{

    $tipo = strtolower($tipo);

    if ($tipo == 'residencial') {

        $nomeclatura = ["03.06", "03.01", "03.04"];

        return $nomeclatura;
    }

    if ($tipo == 'comercial') {

        $nomeclatura = ["03.02"];

        return $nomeclatura;
    }

    if ($tipo == 'isp') {

        $nomeclatura = ["03.08"];

        return $nomeclatura;
    }

    if ($tipo == 'interfone') {

        $nomeclatura = ["03.07"];

        return $nomeclatura;
    }

    if ($tipo == 'empresarial') {

        $nomeclatura = ["03.03"];

        return $nomeclatura;
    }

}

//VERIFICA SE É FINAL DE SEMANA
function verificafinaldesemana($data)
{


    $data = date('w', strtotime($data));

    if ($data == 0 || $data == 6) {

        return true;
    } else {

        return false;
    }
}

function exibediadasemana($data)
{

    return ucfirst(strftime('%a %d/%m', strtotime($data)));
}

function formata_valor($valor)
{

    $valor = number_format(($valor), 2, ',', '.');

    return $valor;

}

function getdiasuteisMes($startDate, $endDate, $setor)
{
    $inicio = strtotime($startDate);
    $fim = strtotime($endDate);

    if ($inicio > $fim) {

        return 0;
    } else {

        $dias = array();

        if ($setor === 'Financeiro') {
            $feriados = array('01/01/2022', '28/02/2022', '15/04/2022', '21/04/2022', '01/05/2022', '16/06/2022', '07/09/2022', '12/10/2022', '02/11/2022',
                '15/11/2022', '25/12/2022', '30/12/2022', '01/01/2023', '21/02/2023', '07/04/2023', '21/04/2023', '01/05/2023', '08/06/2023', '07/09/2023',
                '12/10/2023', '02/11/2023', '15/11/2023', '25/12/2023', '30/12/2023');
            /*
            $feriados = array('01/01/2020', '25/02/2020', '10/04/2020', '21/04/2020', '01/05/2020', '11/06/2020',
                '07/09/2020', '12/10/2020', '02/11/2020', '15/11/2020', '25/12/2020', '01/01/2021', '16/02/2021', '02/04/2021', '21/04/2021', '01/05/2021', '03/06/2021',
                '07/09/2021', '12/10/2021', '02/11/2021', '15/11/2021', '25/12/2021');
            */
        } else {
            $feriados = array('01/01/2022', '28/02/2022', '15/04/2022', '21/04/2022', '01/05/2022', '16/06/2022', '07/09/2022', '12/10/2022', '02/11/2022',
                '15/11/2022', '25/12/2022', '30/12/2022', '01/01/2023', '21/02/2023', '07/04/2023', '21/04/2023', '01/05/2023', '08/06/2023', '07/09/2023',
                '12/10/2023', '02/11/2023', '15/11/2023', '25/12/2023', '30/12/2023');
/*
            $feriados = array('01/01/2020', '25/02/2020', '10/04/2020', '21/04/2020', '01/05/2020', '11/06/2020',
                '07/09/2020', '12/10/2020', '02/11/2020', '15/11/2020', '25/12/2020', '01/01/2021', '02/04/2021', '21/04/2021', '01/05/2021', '03/06/2021',
                '07/09/2021', '12/10/2021', '02/11/2021', '15/11/2021', '25/12/2021');
*/
        }

        while ($inicio <= $fim) {

            $qualodia = date('N', $inicio);

            if ($qualodia <= 5 && !(in_array(date('d/m/Y', $inicio), $feriados))) {

                if (!empty($setor)) {
                    // datas somente o dia
                    $dias[] = date('d', $inicio);
                } else {

                    // data para o pos venda no formato d/m/Y
                    $dias[] = date('d-m-Y', $inicio);
                }

            }
            $inicio += 86400; // +1 day
        };

        return $dias;
    }
}

function getdiasuteisCR($startDate, $endDate)
{
    $inicio = strtotime($startDate);
    $fim = strtotime($endDate);

    if ($inicio > $fim) {

        return 0;
    } else {

        $dias = array();

        $feriados = array('01/01/2022', '28/02/2022', '15/04/2022', '21/04/2022', '01/05/2022', '16/06/2022', '07/09/2022', '12/10/2022', '02/11/2022',
            '15/11/2022', '25/12/2022', '30/12/2022', '01/01/2023', '21/02/2023', '07/04/2023', '21/04/2023', '01/05/2023', '08/06/2023', '07/09/2023',
            '12/10/2023', '02/11/2023', '15/11/2023', '25/12/2023', '30/12/2023');

        /*
        $feriados = array('01/01/2020', '25/02/2020', '10/04/2020', '21/04/2020', '01/05/2020', '11/06/2020',
            '07/09/2020', '12/10/2020', '02/11/2020', '15/11/2020', '25/12/2020', '01/01/2021', '16/02/2021',
            '02/04/2021', '21/04/2021', '01/05/2021', '03/06/2021',
            '07/09/2021', '12/10/2021', '02/11/2021', '15/11/2021', '25/12/2021');
*/
        while ($inicio <= $fim) {

            $qualodia = date('N', $inicio);

            if ($qualodia <= 5 && !(in_array(date('d/m/Y', $inicio), $feriados))) {

                $dias[] = date('d-m-Y', $inicio);

            }
            $inicio += 86400; // +1 day
        };


        return $dias;
    }
}

function personalizaurl($string)
{
    $string = mb_convert_encoding($string, 'UTF-8');
    $string = mb_strtoupper($string);
    $string = str_replace('AVENIDA', "AV.", $string);
    $string = str_replace('RUA', "R.", $string);
    $string = str_replace('RODOVIA', "ROD.", $string);
    $string = str_replace('TRAVESSA', "TV.", $string);
    $string = str_replace('ESTRADA', "ESTR.", $string);

    return str_replace(" ", "+", preg_replace("/&([a-z])[a-z]+;/i", "$1", htmlentities(trim($string))));
}

function verifica_ecerramento_os($codencerramento)
{


    $encerramentos = array(['codigo' => 1, 'descricao' => 'FINALIZADO COM SUCESSO'],
        ['codigo' => 65, 'descricao' => 'FINALIZADO COM SUCESSO'],
        ['codigo' => 60, 'descricao' => 'FINALIZADO COM SUCESSO'],
        ['codigo' => 62, 'descricao' => 'FINALIZADO COM SUCESSO'],);

    foreach ($encerramentos as $item) {


        if ($item['codigo'] == $codencerramento) {

            return $item['descricao'];
        }

    }
}

//RETORNA ULTIMA PALAVRA DE UMA FRASE
function ultima_string($string)
{

    $string = explode(' ', $string);
    $string = array_pop($string);
    return $string;

}

// RETORNA OS DIAS DESTA SEMANA ()
function diasdasemana()
{

    $semana = array();
    $date = gmdate('w');
    $date = $date - 1;


    //ACUMULADO SEMANA
    for ($i = 0; $i <= $date; $i++) {

        $inicio = date('Y-m-d', strtotime('-' . $i . ' days'));

        array_push($semana, $inicio);

    }

    sort($semana);

    return $semana;
}

//RETORNA O TIPO DE UMA OS
function tipo_os($os)
{

    switch ($os) {
        case "1":
            $os = 'Instalação';
            break;
        case "2":
            $os = 'Manutenção';
            break;
        case "3":
            $os = 'Transferência';
            break;
        case "4":
            $os = 'Upgrade';
            break;
        case "5":
            $os = 'Cancelamento';
            break;
        case "6":
            $os = 'Transferência';
            break;
        case "27":
            $os = 'Migração';
            break;
        case "29":
            $os = 'OS-Interna';
            break;
        case "32":
            $os = 'Manutenção';
            break;
        case "62":
            $os = 'Inativos Cancelamento';
            break;
        default:
            $os = 'Tipo não identificado';
            break;

    }

    return $os;

}

function color_os($os)
{

    switch ($os) {
        case "Instalação":
            $color = 'yellow';
            break;
        case "Manutenção":
            $color = '#87cefa';
            break;
        case "Transferência":
            $color = 'green';
            break;
        case "Upgrade":
            $color = '#4169e1';
            break;
        case "Cancelamento":
            $color = '#8b4513';
            break;
        case "Migração":
            $color = 'orange';
            break;
        case "OS-Interna":
            $color = '#696969';
            break;
        default:
            $color = 'red';
            break;

    }

    return $color;

}

//ORDENA ARRAY MULTISORT POR CAMPO ESCOLHIDO

function ordenaarray_multi($array, $nomedocampo)
{

    $new_array = array();

    foreach ($array as $key => $row) {

        $new_array[$key] = $row[$nomedocampo];
    }

    array_multisort($new_array, SORT_ASC, $array);


    return $array;
}

function getDatas($date)
{

    $newDate = null;

    switch ($date) {

        case 'first_month':
            $newDate = date('Y-m-d', mktime(0, 0, 0, date('m'), 1,
                date('Y')));
            break;
        case 'last_month':
            $newDate = date('Y-m-d', mktime(23, 59, 59, date('m'),
                date("t"), date('Y')));
            break;
        case 'today':
            $newDate = date('Y-m-d');
            break;
        case 'first_month1':
            $newDate = date('Y-m-d', mktime(0, 0, 0, date('m') - 1, 1,
                date('Y')));
            break;
        case 'last_month1':
            $newDate = date('d-m-Y', mktime(0, 0, 0, date('m'),
                date('d') - date('j'), date('Y')));
            break;
        case 'first_month2':
            $newDate = date('d-m-Y', mktime(0, 0, 0, date('m') - 2,
                1, date('Y')));
            break;
        case 'last_month2':
            $newDate = date('d-m-Y', mktime(23, 59, 59, date('m') - 1,
                date('d') - date('j'), date('Y')));
            break;

    }

    return $newDate;
}

function iniciaisdeumapalavra($palavra)
{

    $string = $palavra;
    preg_match_all('/\b\w/u', $string, $m);
    $string = implode('', $m[0]);
    return substr($string, 0, 2);
}

//Função que retorna cores da label de acordo com a string fornecida
function statusLabel($string)
{
    $label = null;

    switch ($string) {

        case 'LIQUIDADO':
            $label = 'label label-success';
            break;
        case 'AUTORIZADO':
            $label = 'label label-warning';
            break;
        case 'SUSPENSO':
            $label = 'label label-info';
            break;
        case 'CONCLUIDO':
            $label = 'label label-success';
            break;
        case 'REEMBOLSO':
            $label = 'label label-pink';
            break;
        case 'SEM ADESAO':
            $label = 'label label-info';
            break;
    }

    return $label;

}

function statusTR($item)
{

    $result = null;

    if (array_search('FALTA', $item) ||
        //array_search('FALTA BLOQUEAR', $item) ||
        array_search('FALTA PARCELA ADESAO', $item) ||
        array_search('FALTA FATURAR', $item)) {


        $result = 'bg-danger-50';

    } else if (array_search('AGUARDANDO', $item)
        || array_search('AGUARDANDO PAGAMENTO', $item)
        || array_search('AGUARDANDO AGENDAMENTO', $item)
        || array_search('AGUARDANDO INSTALACAO', $item)
        || array_search('PENDENTE', $item)) {

        $result = 'bg-warning-50';

    } else if (array_search('CONCLUIDO', $item)) {

        $result = 'bg-success-50';
    } else if (array_search('LIQUIDADO', $item)) {

        $result = 'label-redenilf';
    }

    return $result;
}


function diasdaSemanaEmUmMes()
{

    $dias = array();
    $dias_2 = array();
    $data = new DateTime('first day of this month');
    $dow = $data->format('N');
    if ($dow == 6 || $dow == 7) {
        // se for sábado ou domingo, ajusta para a próxima segunda-feira
        $data->modify('Monday');
    }
    $mes = $data->format('m');
    $mesmo_mes = TRUE;
    while ($mesmo_mes) {
        $inicio = $data->format("d/m");
        $inicio2 = $data->format("Y-m-d");
        $data->modify('Friday');
        if ($mes != $data->format('m')) {
            // foi para o mês seguinte, voltar para o mês atual e ajustar para para o último dia
            $data = new DateTime('last day of this month');
            $mesmo_mes = FALSE;
        }
        /*
        echo  "{$inicio} - {$data->format('d-m-Y')} <br>";*/
        array_push($dias, "{$inicio} - {$data->format('d/m')}");
        array_push($dias_2, "{$inicio2} / {$data->format('Y-m-d')}");

        $data->modify('Monday');
        if ($mes != $data->format('m')) {
            break; // se a próxima segunda-feira está no mês seguinte, sai do loop
        }
    }

    return ["format_1" => $dias, "format_2" => $dias_2];

}


?>
