$(function() {

    loadNewFluxo();

});

//remove o active da classe tab-panel devido a um BUG do bootstrap
$('#myTab-cac a').on('click', function () {

    $('.tab-pane').removeClass('active')

});

const loadNewFluxo = () => {

    $.ajax({
        type: 'GET',
        url: './control/dashboards/manager_dashcac.php?page=loadNewFluxo',
        beforeSend() {

            $('#load_cacvendas2').html('<div class="ibox-body">' +
              '<div class="card mb-4">\n' +
              '    <div class="card-body text-center">\n' +
              '        <div class="d-flex align-items-center justify-content-center">\n' +
              '            <div class="loader">\n' +
              '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
              '                <div class="loader-inner"></div>\n' +
              '                <div class="loader-inner"></div>\n' +
              '                <div class="loader-inner"></div>\n' +
              '            </div>\n' +
              '        </div>\n' +
              '    </div>\n' +
              '  </div>\n' +
              '</div>');

        },
        success: function (response) {

            const groupColumn = 0;

            $('#load_cacvendas2').html(response);
            $.fn.dataTable.moment("DD/MM/YYYY");

            $('#datatable-newfluxo').DataTable({
                "columnDefs": [
                    { "visible": false, "targets": groupColumn }
                ],
                fixedHeader: true,
                pageLength: 20,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                "order": [[0, "desc"]],
                "drawCallback": function ( settings ) {
                    var api = this.api();
                    var rows = api.rows({page: 'current'}).nodes();
                    var last = null;

                    api.column(groupColumn, {page: 'current'}).data().each(function (group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before(
                              '<tr class="group text-left"><td colspan="9">' + group + '</td></tr>'
                            );

                            last = group;
                        }
                    });
                },
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal( {
                        } ),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll( {
                            tableClass: 'table'
                        } )
                    }
                },
                "sDom": 'rtip'
            })
            $('[data-toggle="tooltip"]').tooltip();

            const table = $('#datatable-newfluxo').DataTable();

            $('#key-search2').on('keyup', function() {
                table.search(this.value).draw();
            });

        }
    });
}


function onclickAutosearch(value) {

    var table = $('#datatable').DataTable();

    table.search(value).draw();

    document.querySelector('#key-search').value = value;
}

const searchFluxoNew = (value) => {
    const table = $('#datatable-newfluxo').DataTable();

    table.search(value).draw();

    document.querySelector('#key-search2').value = value;
}
