$(function () {
    loadfluxo();
});

$('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {

    const target = $(e.target).attr("href"); // activated tab

    if (target == '#tab-3-1') {
        loadfluxo();
    } else if (target == '#tab-3-2') {
        loadInativos();
    }
});

function loadfluxo() {

    const groupColumn = 0;

    $.ajax({
        type: 'GET',
        url: './control/manager_cancelamento.php?page=loadfluxo',
        beforeSend() {

            $('#loadFluxo').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $('#loadFluxo').html(response);
            $.fn.dataTable.moment("DD/MM/YYYY");
            const table = $('#datatable-fluxo').DataTable({
                "columnDefs": [
                    {"visible": false, "targets": groupColumn}
                ],
                "order": [[groupColumn, 'asc']],
                pageLength: 20,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                "order": [[0, "desc"]],
                "drawCallback": function (settings) {
                    var api = this.api();
                    var rows = api.rows({page: 'current'}).nodes();
                    var last = null;

                    api.column(groupColumn, {page: 'current'}).data().each(function (group, i) {
                        if (last !== group) {
                            $(rows).eq(i).before(
                                '<tr class="group"><td colspan="7">' + group + '</td></tr>'
                            );

                            last = group;
                        }
                    });
                },
                fixedHeader: false,
                destroy: true,
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal({}),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll({
                            tableClass: 'table'
                        })
                    }
                },
                "sDom": 'rtip',
            });

            $('[data-toggle="tooltip"]').tooltip();

            $('#key-search-fluxo').on('keyup', function () {
                table.search(this.value).draw();
            });

            $('#type-status-fluxo').on('change', function () {
                table.search($(this).val()).draw();
            });
        }
    });
}

function loadInativos() {

    $.ajax({
        type: 'GET',
        url: './control/manager_cancelamento.php?page=loadinativos',
        beforeSend() {

            $('#loadInativos').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $('#loadInativos').html(response);
            $('[data-toggle="popover"]').popover();
            $('#datatable-inativos').DataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                pageLength: 30,
                responsive: true,
                "order": [[4, "desc"]],
            });
        }
    });
}

function onclickAutosearch(value) {

    var table = $('#datatable-fluxo').DataTable();

    table.search(value).draw();

    document.querySelector('#key-search-fluxo').value = value;
}

//remove o active da classe tab-panel devido a um BUG do bootstrap
$('#tab-cancelamento a').on('click', function () {

    $('.tab-pane').removeClass('active')

});

