// Chart c
$(function () {

  const start = moment().startOf('month'), end = moment().endOf('month'),
    maxdate = moment().endOf('year');

  $.getJSON("./control/manager_cancelamento.php?page=loadanual", function (data) {

    const meses = [];
    const meses2 = [];
    const valor = [];

    $.each(data, function (key, val) {

      meses.push(val.mes.substring(0, 1));
      meses2.push(val.mes);
      valor.push(val.valor);
    });

    var chartdata_c = {
      labels: meses,
      datasets: [
        {
          label: "Total",
          backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
          borderColor: "#fff",
          hoverBackgroundColor: '#fff',
          data: valor
        }
      ]
    };
    var chartOptions_c = {
      tooltips: {
        callbacks: {
          title: function (tooltipItem) {

            return meses2[tooltipItem[0].index];

          }
        }

      },
      responsive: true,
      maintainAspectRatio: false,
      showScale: false,
      scales: {
        xAxes: [{
          gridLines: {
            display: false,
            drawBorder: false,
          },
          ticks: {
            fontColor: '#fff'
          }
        }],
        yAxes: [{
          gridLines: {
            display: false,
            drawBorder: false,
            drawTicks: false,
            tickMarkLength: 0
          },
          ticks: {
            display: false,
            padding: 0,
            fontColor: '#eee'
          },
        }]
      },
      legend: {display: false}
    };
    var ctx = document.getElementById("chart_c").getContext("2d");
    new Chart(ctx, {type: 'bar', data: chartdata_c, options: chartOptions_c});

  });

  $('#reportrange-cancelamento').daterangepicker({
    ranges: {
      'Hoje': [moment(), moment()],
      'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
      'Mês Passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')],
      'Esta Semana': [moment().day(1), moment().day(5)],
      'Este Mês': [moment().startOf('month'), moment().endOf('month')],
      'Este Ano': [moment().startOf('year'), moment().endOf('year')],
    },
    buttonClasses: ["btn btn-default"],
    applyClass: "btn-sm btn-redenilf",
    cancelClass: "btn-sm",
    todayHighlight: true,
    separator: " to ",
    locale: {
      format: "DD/MM/YYYY",
      applyLabel: "Aplicar",
      cancelLabel: "Limpar",
      fromLabel: "From",
      toLabel: "To",
      customRangeLabel: "Personalizado",
      daysOfWeek: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
      monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
      firstDay: 1
    },
    showCustomRangeLabel: true,
    startDate: start,
    endDate: end,
    "minDate": "01/04/2019",
    "maxDate": maxdate,
  }, cb);
  cb(start, end);

  historico_os_cancelamento();
});

function cb(start, end) {
  $('#reportrange-cancelamento span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
  load(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
}

function load(start, end) {

  $.ajax({
    type: 'POST',
    url: './control/manager_cancelamento.php?page=load',
    data: {inicio: start, fim: end},
    beforeSend() {

      $('#load_cancelamento').html('<div class="ibox-body">' +
        '<div class="card mb-4">\n' +
        '    <div class="card-body text-center">\n' +
        '        <div class="d-flex align-items-center justify-content-center">\n' +
        '            <div class="loader">\n' +
        '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '            </div>\n' +
        '        </div>\n' +
        '    </div>\n' +
        '  </div>\n' +
        '</div>');

    },
    success: function (response) {
      $('#load_cancelamento').html(response);
      $.fn.dataTable.moment("DD/MM/YYYY");
      const table = $('#datatable').DataTable({
        pageLength: 20,
        "language": {
          "url": "js/json/pt_BR.json"
        },
        "order": [[0, "desc"]],
        fixedHeader: false,
        responsive: {
          details: {
            display: $.fn.dataTable.Responsive.display.modal({}),
            renderer: $.fn.dataTable.Responsive.renderer.tableAll({
              tableClass: 'table'
            })
          }
        },
        "sDom": 'rtip',
      });

      $('[data-toggle="tooltip"]').tooltip();

      $('#key-search').on('keyup', function () {
        table.search(this.value).draw();
      });

      $('#type-status').on('change', function () {
        table.search($(this).val()).draw();

      });

    }
  })

}

function busca_cli_equip(e) {


  let tipo = e.getAttribute('data-type'), mes = e.getAttribute('data-month'), modal = $('#modal_extraLarge');

  modal.modal('show');
  modal.find('.modal-title').html('Equipamentos Perdidos ' + tipo);
  $.ajax({
    type: 'POST',
    url: './control/manager_cancelamento.php?page=loadClienteEequip',
    data: {tipo: tipo, mes: mes},
    beforeSend() {

      $('.modal-extralarge-result').html('<div class="col-md-12">' +
        '<div class="card mb-4">\n' +
        '    <div class="card-body text-center">\n' +
        '        <div class="d-flex align-items-center justify-content-center">\n' +
        '            <div class="loader">\n' +
        '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '            </div>\n' +
        '        </div>\n' +
        '    </div>\n' +
        '  </div>\n' +
        '</div>');

    },
    success: (response) => {

      $('.modal-extralarge-result').html(response);
      $('#table_perdidos').DataTable({
        "language": {
          "url": "js/json/pt_BR.json"
        },
        dom: "lBfrtip",
        buttons: [{extend: "print", text: "Imprimir", className: "btn btn-sm btn-redenilf"}],
        responsive: true,
        "order": [[3, "desc"]],
      })
    }

  })

}

function busca_cancelados(e) {


  let tipo = e, modal = $('#modal_extraLarge');

  modal.modal('show');
  modal.find('.modal-title').html('Cancelados ' + tipo);
  $.ajax({
    type: 'POST',
    url: './control/manager_cancelamento.php?page=loadCanceladosDetalhes',
    data: {tipo: tipo},
    beforeSend() {

      $('.modal-extralarge-result').html('<div class="col-md-12">' +
        '<div class="card mb-4">\n' +
        '    <div class="card-body text-center">\n' +
        '        <div class="d-flex align-items-center justify-content-center">\n' +
        '            <div class="loader">\n' +
        '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '            </div>\n' +
        '        </div>\n' +
        '    </div>\n' +
        '  </div>\n' +
        '</div>');

    },
    success: (response) => {

      $('.modal-extralarge-result').html(response);
      $('#table_cancelados').DataTable({
        "language": {
          "url": "js/json/pt_BR.json"
        },
        dom: "lBfrtip",
        buttons: [{extend: "print", text: "Imprimir", className: "btn btn-sm btn-redenilf"}],
        responsive: true,
        "order": [[0, "desc"]],
      })
    }

  })

}


const historico_os_cancelamento = () => {

  $.ajax({
    type: 'GET',
    url: './control/manager_cancelamento.php?page=historico_os',
    beforeSend() {

      $('#historico_os_cancelamento').html('<div class="ibox-body">' +
        '<div class="card mb-4">\n' +
        '    <div class="card-body text-center">\n' +
        '        <div class="d-flex align-items-center justify-content-center">\n' +
        '            <div class="loader">\n' +
        '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '            </div>\n' +
        '        </div>\n' +
        '    </div>\n' +
        '  </div>\n' +
        '</div>');

    },
    success: function (response) {

      $('#historico_os_cancelamento').html(response);
      $('[data-toggle="tooltip"]').tooltip();
      $('#help_cancelamento').popover({
        content: "<strong style='color: rgba(191,40,90,0.7);'>Cancelados: </strong>Quantidade de cancelamentos" +
          " executados diariamente no mês.<hr> <strong style='color: #c8aa7b;'>Em Cancelamento: </strong>" +
          " Quantidade de O.S aberta diariamente que estão pendentes e contrato ainda não cancelado.",
        placement: "top",
        html: true,
        trigger: "hover",
      });

      //CHART HISTORICO O.S CANCELAMENTO
      const label = $('#line_os_cancelamento').attr('data-dates');
      const cancelados_data = $('#line_os_cancelamento').attr('data-cancelados_dia');
      const abertos_data = $('#line_os_cancelamento').attr('data-pendente_dia');


      var lineData = {
        labels: label.split(','),
        datasets: [
          {
            // Green
            label: "Cancelados",
            //data: [0],
            data: cancelados_data.split(','),
            backgroundColor: 'rgba(255,123,171,0.7)',
            borderColor: 'rgba(255,64,129, 0.7)',
            pointBackgroundColor: 'rgba(191,40,90,0.7)',
            pointBorderColor: 'rgba(255,64,129, 0.7)',
            borderWidth: 1,
            pointBorderWidth: 1,
            pointRadius: 0,
            pointHitRadius: 30,
          },
          {
            // Purple
            label: "Em Cancelamento",
            data: abertos_data.split(','),
            borderColor: '#d2c398',
            backgroundColor: '#eacb99',
            pointBackgroundColor: '#c8aa7b',
            pointBorderColor: '#d2c398',
            borderWidth: 1,
            pointBorderWidth: 1,
            pointRadius: 0,
            pointHitRadius: 30,
          },

        ],
      };
      var lineOptions = {
        responsive: true,
        maintainAspectRatio: false,
        showScale: false,
        scales: {
          xAxes: [{
            gridLines: {
              display: false,
            },
          }],
          yAxes: [{
            gridLines: {
              display: false,
              drawBorder: false,
            },
          }]
        },
        legend: {
          labels: {
            boxWidth: 12
          }
        },
      };

      const os_cancelamento_chart = document.getElementById("line_os_cancelamento").getContext("2d");
      new Chart(os_cancelamento_chart, {type: 'line', data: lineData, options: lineOptions});

      /*
                  // CHART ACUMULADO HISTORICO CONEXAO
                  const desbloqueados_mes = $('#chart_acumulado_historico_conexao').attr('data-desbloqueados');
                  const bloqueados_mes = $('#chart_acumulado_historico_conexao').attr('data-bloqueados');
                  const chart_acumulado = {
                      labels: ["FEV", "", "", "", "", "", '', '', '', '', ''],
                      datasets: [
                          {
                              label: "Desbloqueados",
                              backgroundColor: '#18C5A9',
                              borderColor: "#fff",
                              data: [desbloqueados_mes, 0]
                          },
                          {
                              label: "Bloqueados",
                              backgroundColor: 'rgba(255,123,171,0.7)',
                              borderColor: "#fff",
                              data: [bloqueados_mes, 0]
                          }
                      ]
                  };
                  const chartOptions_acumulado = {
                      responsive: true,
                      maintainAspectRatio: false,
                      showScale: false,
                      scales: {
                          xAxes: [{
                              gridLines: {
                                  display: false,
                                  drawBorder: false,
                              },
                          }],
                          yAxes: [{
                              gridLines: {
                                  display: false,
                                  drawBorder: false,
                                  drawTicks: false,
                                  tickMarkLength: 0
                              },
                              ticks: {
                                  display: false,
                                  padding: 0,
                              },
                          }]
                      },
                      legend: {display: false}
                  };

                  const acumulado_chart = document.getElementById("chart_acumulado_historico_conexao").getContext("2d");
                  new Chart(acumulado_chart, {type: 'bar', data: chart_acumulado, options: chartOptions_acumulado});
      */

    }
  })


}

