$(function () {

  moment.locale('pt-br');

  loadCobranca();
  loadCobranca2();
  loadSPC();

  //remove o active da classe tab-panel devido a um BUG do bootstrap
  $('#myTab-cob a').on('click', function () {

    $('.tab-pane').removeClass('active')

  });

});


function loadCobranca() {

  $.ajax({
    type: 'GET',
    url: './control/manager_cobranca.php?page=loadCobranca',
    beforeSend() {

      $('#loadCobranca').html('<div class="ibox-body">' +
        '<div class="card mb-4">\n' +
        '    <div class="card-body text-center">\n' +
        '        <div class="d-flex align-items-center justify-content-center">\n' +
        '            <div class="loader">\n' +
        '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '                <div class="loader-inner"></div>\n' +
        '            </div>\n' +
        '        </div>\n' +
        '    </div>\n' +
        '  </div>\n' +
        '</div>');

    },
    success: function (response) {
      $('#loadCobranca').html(response);
      $('[data-toggle="popover"]').popover();
      $('#datatable-cobranca').DataTable({
        "destroy": true,
        "language": {
          "url": "js/json/pt_BR.json"
        },
        pageLength: 30,
        responsive: true,
        "order": [[0, "asc"]],
        "sDom": 'rtip'
      });

      const table = $('#datatable-cobranca').DataTable();

      $('#key-search-dias').on('keyup', function () {

        const regex = '\\b' + this.value + '\\b';
        table.column(4).search(regex, true, false).draw();

      });

      $('#key-search-cobranca').on('keyup', function () {

        table.search(this.value).draw();

      });
    }
  });

}

function loadCobranca2() {

  $.ajax({
    type: 'GET',
    url: './control/manager_cobranca.php?page=loadCobranca2',
    beforeSend() {

      $('#loadCobranca2').html('<div class="ibox-body">' +
          '<div class="card mb-4">\n' +
          '    <div class="card-body text-center">\n' +
          '        <div class="d-flex align-items-center justify-content-center">\n' +
          '            <div class="loader">\n' +
          '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
          '                <div class="loader-inner"></div>\n' +
          '                <div class="loader-inner"></div>\n' +
          '                <div class="loader-inner"></div>\n' +
          '            </div>\n' +
          '        </div>\n' +
          '    </div>\n' +
          '  </div>\n' +
          '</div>');

    },
    success: function (response) {
      $('#loadCobranca2').html(response);
      $.fn.dataTable.moment("DD/MM/YYYY");

      $('[data-toggle="popover"]').popover();
      $('#datatable-cobranca2').DataTable({
        "destroy": true,
        "language": {
          "url": "js/json/pt_BR.json"
        },
        pageLength: 30,
        responsive: true,
        autoWidth: true,
        "order": [[0, "desc"]],
        "sDom": 'rtip'
      });

      const table = $('#datatable-cobranca2').DataTable();

      $('#key-search-dias2').on('keyup', function () {

        const regex = '\\b' + this.value + '\\b';
        table.column(4).search(regex, true, false).draw();

      });

      $('#key-search-cobranca2').on('keyup', function () {

        table.search(this.value).draw();

      });
    }
  });
}


function loadSPC() {

  $.ajax({
    type: 'GET',
    url: './control/manager_cobranca.php?page=loadSPC',
    beforeSend() {

      $('#loadSPC').html('<div class="ibox-body">' +
          '<div class="card mb-4">\n' +
          '    <div class="card-body text-center">\n' +
          '        <div class="d-flex align-items-center justify-content-center">\n' +
          '            <div class="loader">\n' +
          '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
          '                <div class="loader-inner"></div>\n' +
          '                <div class="loader-inner"></div>\n' +
          '                <div class="loader-inner"></div>\n' +
          '            </div>\n' +
          '        </div>\n' +
          '    </div>\n' +
          '  </div>\n' +
          '</div>');

    },
    success: function (response) {
      $('#loadSPC').html(response);
      $.fn.dataTable.moment("DD/MM/YYYY");

      $('[data-toggle="popover"]').popover();
      $('#datatable-spc').DataTable({
        "destroy": true,
        "language": {
          "url": "js/json/pt_BR.json"
        },
        pageLength: 30,
        responsive: true,
        autoWidth: true,
        "order": [[0, "desc"]],
        "sDom": 'rtip'
      });

      const table = $('#datatable-spc').DataTable();

      $('#key-search-spc2').on('keyup', function () {

        table.search(this.value).draw();

      });
    }
  });
}




