$(function () {

    moment.locale('pt-br');

    loadWidgetCobranca();

});

const loadWidgetCobranca = () => {

    $.ajax({
        type: 'GET',
        url: './control/manager_widgetCobranca.php',
        beforeSend() {
            $('#loadChartCobranca').html(
                '<div class="ibox">' +
                '<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando cobranças...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>' +
                '</div>');
        },
        success: (response) => {
            $('#loadChartCobranca').html(response);

            //INICIO GRAFICO DE CULUNAS
            const chartCobranca = document.getElementById("chart_cobranca").getContext("2d");
            new Chart(chartCobranca, {
                type: 'bar',
                data: {
                    labels: label.split(','),
                    datasets: [
                        {
                            label: "SPC",
                            data: data_spc.split(','),
                            borderColor: '#f75a5f',
                            backgroundColor: '#f75a5f',
                            pointBackgroundColor: '#f75a5f',
                            pointBorderColor: '#f75a5f',
                            borderWidth: 1,
                            pointBorderWidth: 1,
                            pointRadius: 0,
                            pointHitRadius: 30,
                        },{
                            label: "Em Negociação",
                            data: data_negociacao.split(','),
                            backgroundColor: '#f39c12',
                            borderColor: '#f39c12',
                            pointBackgroundColor: '#f39c12',
                            pointBorderColor: '#f39c12',
                            borderWidth: 1,
                            pointBorderWidth: 1,
                            pointRadius: 0,
                            pointHitRadius: 30,
                        },{
                            label: "Liquidados",
                            data: data_liquidados.split(','),
                            borderColor: '#18c5a9',
                            backgroundColor: '#18c5a9',
                            pointBackgroundColor: '#18c5a9',
                            pointBorderColor: '#18c5a9',
                            borderWidth: 1,
                            pointBorderWidth: 1,
                            pointRadius: 0,
                            pointHitRadius: 30,
                        },
                    ],
                },
                options: {
                    responsive: true,
                    maintainAspectRatio: false,
                    showScale: false,
                    scales: {
                        xAxes: [{
                            gridLines: {
                                display: false,
                            },
                            barPercentage: 0.7,
                            categoryPercentage: 0.5
                        }],
                        yAxes: [{
                            gridLines: {
                                display: false,
                                drawBorder: false,
                            },
                        }]
                    },
                    legend: {
                        labels: {
                            boxWidth: 12
                        }
                    },
                }
            });
            //FIM GRAFICO DE COLUNAS



            //GRAFICO DE COLUNAS NO FIM POR ANO
            const chartCobrancaAnual = {
                labels: label_anual.split(','),
                datasets: [
                    {
                        label: "Liquidados",
                        backgroundColor: '#18C5A9',
                        borderColor: "#fff",
                        data: data_total.split(',')
                    },{
                        label: "Sem Acordo",
                        backgroundColor: '#f75a5f',
                        borderColor: "#fff",
                        data: data_total2.split(',')
                    }
                ]
            };
            const chartOptions_Anual = {
                tooltips: {
                    callbacks: {
                        title: function (tooltipItem) {

                            if (tooltipItem[0].datasetIndex == 0){
                                return `${label2_anual.split(',')[tooltipItem[0].index]} => Total: ${formatMoney(data_valor_liquidado.split(',')[tooltipItem[0].index])}`;
                            }else{
                                return `${label2_anual.split(',')[tooltipItem[0].index]} => Total: ${formatMoney(data_valor_spc.split(',')[tooltipItem[0].index])}`;
                            }



                        }
                    }
                },
                responsive: true,
                maintainAspectRatio: false,
                showScale: false,
                scales: {
                    xAxes: [{
                        stacked: true,
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                    }],
                    yAxes: [{
                        stacked: true,
                        gridLines: {
                            display: false,
                            drawBorder: false,
                            drawTicks:false,
                            tickMarkLength: 0
                        },
                        ticks: {
                            display: false,
                            padding: 0,
                        },
                    }]
                },
                legend: {display: false}
            };

//FUNÇÃO PARA FORMATAR VALORES COM AS CASA DECIMAIS CORRETAS
            function formatMoney(n, c, d, t) {
                c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
                return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
            }

            const cobranca_anual_liquidados = document.getElementById("chart_cobranca_anual").getContext("2d");
            new Chart(cobranca_anual_liquidados, {type: 'bar', data: chartCobrancaAnual, options: chartOptions_Anual});

        }
    });

};
