class PosvendaController {


    constructor() {

        this._modaltitle = document.querySelector("#modal_extraLarge .modal-title");

        this.initialize();
    }

    initialize() {

        this.loadposvendaPF();

    }

    invokeModal() {

        return $('#modal_extraLarge').modal('show');

    }

    hideModal() {

        return $('#modal_extraLarge').modal('hide');


    }

    invokeLoading() {

        return '<div class="col-md-12">' +
            '<div class="card mb-4">\n' +
            '    <div class="card-body text-center">\n' +
            '        <div class="d-flex align-items-center justify-content-center">\n' +
            '            <div class="loader">\n' +
            '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
            '                <div class="loader-inner"></div>\n' +
            '                <div class="loader-inner"></div>\n' +
            '                <div class="loader-inner"></div>\n' +
            '            </div>\n' +
            '        </div>\n' +
            '    </div>\n' +
            '  </div>\n' +
            '</div>'

    }

    // PESSOA FISICA PO VENDA

    loadposvendaPF() {


        var groupColumn = 0;

        let thiss = this;

        $.ajax({
            type: "GET",
            url: './control/posvenda/control_posvendapf.php',
            beforeSend() {

                $('#carrega-tabela-pf').html(thiss.invokeLoading());

            },
            success: function (data) {

                $('#carrega-tabela-pf').html(data);
                $.fn.dataTable.moment("DD/MM/YYYY");
                $('#tabela-posvendapf').DataTable({
                    "columnDefs": [
                        { "visible": false, "targets": groupColumn }
                    ],
                    "order": [[ groupColumn, 'desc' ]],
                    pageLength: 20,
                    "lengthMenu": [[20, 50, 100, -1], [20, 50, 100, "Todos"]],
                    "language": {
                        "url": "js/json/pt_BR.json"
                    },
                    fixedHeader: !0,
                    keys: !0,
                    "drawCallback": function ( settings ) {
                        var api = this.api();
                        var rows = api.rows({page: 'current'}).nodes();
                        var last = null;

                        api.column(groupColumn, {page: 'current'}).data().each(function (group, i) {
                            if (last !== group) {
                                $(rows).eq(i).before(
                                    '<tr class="group"><td class="text-white font-bold" style="background-color: #0b2a4c"' +
                                    ' colspan="7">' + group + '</td></tr>'
                                );

                                last = group;
                            }
                        });
                    },
                    responsive: {
                        details: {
                            display: $.fn.dataTable.Responsive.display.modal({}),
                            renderer: $.fn.dataTable.Responsive.renderer.tableAll({
                                tableClass: 'table'
                            })
                        }
                    },
                });
                $('[data-toggle="tooltip"]').tooltip();

            }

        });

    }

    editar_pos_pf(val) {

        this.invokeModal();
        //salva a referencia
        let thiss = this;
        this.modaltitle = 'Lista de Clientes';
        $.ajax({
            type: "POST",
            url: './control/posvenda/control_posvendapf.php?page=edit',
            data: {id: val},
            beforeSend() {

                $('.modal-extralarge-result').html(thiss.invokeLoading());

            },
            success: (response) => {

                $('.modal-extralarge-result').html(response);

                this.controleform_Edit();

                $('#form-posvendapf').on('submit', function (e) {

                        e.preventDefault();
                        thiss.controleSalvar(this);

                    }
                );


            }

        });

    }

    controleform_Edit() {


        var $adesao = $('#adesao'), $datacartao = $('#datacartao'), $valorcartao = $('#valorcartao'),
            $avista = $('#avista'), $classificacao = $('#classificacao'), $consultor = $('#consultor');

        if ($classificacao.val() === '7') {

            $consultor.css('display', 'block');
        } else {

            $consultor.css('display', 'none');
            $('#select-consultor').val('');

        }
        $adesao.change(function () {

            if ($adesao.val() == 'CARTAO') {

                $datacartao.css('display', 'block');
                $valorcartao.css('display', 'block');
                $avista.css('display', 'none');
                $('#datacartao input').datepicker({
                    language: "pt-BR",
                    format: "dd/mm/yyyy",
                    todayHighlight: true
                });
                $('.valor').mask('#.##0,00', {reverse: true});
                $('#status-boleto').val('');

            } else if ($adesao.val() == 'BOLETO') {

                $datacartao.css('display', 'none');
                $valorcartao.css('display', 'none');
                $avista.css('display', 'block');
                $('#dt-cartao').val('');
                $('#cartao').val('');

            } else {
                $datacartao.css('display', 'none');
                $valorcartao.css('display', 'none');
                $avista.css('display', 'none');
                $('#status-boleto').val('');
                $('#dt-cartao').val('');
                $('#cartao').val('');


            }

        }).trigger('change');

        $classificacao.change(function () {

            if ($classificacao.val() === '7') {

                $consultor.css('display', 'block');

            } else {

                $consultor.css('display', 'none');
                $('#select-consultor').val('');

            }

        }).trigger('change');

    }

    controleSalvar(refer) {

        let thiss = this;
        var data = $(refer).serialize();
        var check = [];
        $('.getvalor').each(function () {

            if ($(this).is(":checked")) {
                check.push($(this).val());
            }

        });
        check = check.toString();

        if ($('#adesao').val() == '' && $('#posvenda').val() == 'SIM') {

            toastr.error('Informe o tipo da Adesão');
            $('#adesao').focus();
            return false;
        }
        if ($('#adesao').val() == 'BOLETO' && $('#status-boleto').val() == '') {

            toastr.error('Informe se o boleto foi pago');
            $('#status-boleto').focus();
            return false;
        }
        if ($('#classificacao').val() == '' && $('#posvenda').val() == 'SIM') {

            toastr.warning('Informe a Origem da Venda');
            $('#classificacao').focus();
            return false;
        }

        if ($('#status-boleto').val() == 'NAO' && $('#status').val() == 'CONCLUIDO') {

            toastr.warning('Cliente não Pagou a Parcela a Vista');
            return false;
        }
        if ($('#classificacao').val() == '7' && $('#select-consultor').val() == '') {

            toastr.warning('Insira o nome do Vendedor Externo');
            return false;
        }
        if ($('#status').val() == 'CONCLUIDO' && $('#posvenda').val() == 'NAO') {

            toastr.warning('Pos Venda não foi concluído');
            return false;

        }

        $.ajax({
            type: 'POST',
            url: './control/posvenda/control_posvendapf.php?page=salve',
            data: data + '&tipo=' + check,
            success: function () {
                toastr.success('Atualizado com Sucesso');
                thiss.hideModal();
                $("#tabela-posvendapf").dataTable().fnDestroy();
                thiss.loadposvendaPF();
            }
        });
    }

    // FIM PESSOA FISICA POS VENDA

    //PESSOA JURIDICA PJ

    loadposvendaPJ() {

        var groupColumn = 0;

        let thiss = this;

        $.ajax({
            type: "GET",
            url: './control/posvenda/control_posvendapj.php',
            beforeSend() {

                $('#carrega-tabela-pj').html(thiss.invokeLoading());

            },
            success: function (data) {

                $('#carrega-tabela-pj').html(data);
                $.fn.dataTable.moment("DD/MM/YYYY");
                $('#tabela-posvendapj').dataTable({
                    "columnDefs": [
                        { "visible": false, "targets": groupColumn }
                    ],
                    "order": [[ groupColumn, 'desc' ]],
                    "language": {
                        "url": "js/json/pt_BR.json"
                    },
                    fixedHeader: !0,
                    keys: !0,
                    pageLength: 20,
                    "lengthMenu": [[20, 50, 100, -1], [20, 50, 100, "Todos"]],
                    "drawCallback": function ( settings ) {
                        var api = this.api();
                        var rows = api.rows({page: 'current'}).nodes();
                        var last = null;

                        api.column(groupColumn, {page: 'current'}).data().each(function (group, i) {
                            if (last !== group) {
                                $(rows).eq(i).before(
                                    '<tr class="group"><td class="text-white font-bold" style="background-color: #0b2a4c"' +
                                    ' colspan="7">' + group + '</td></tr>'
                                );

                                last = group;
                            }
                        });
                    },
                    responsive: {
                        details: {
                            display: $.fn.dataTable.Responsive.display.modal({}),
                            renderer: $.fn.dataTable.Responsive.renderer.tableAll({
                                tableClass: 'table'
                            })
                        }
                    },
                });
                $('[data-toggle="tooltip"]').tooltip();

            }

        });

    }

    editar_pos_pj(val) {

        this.invokeModal();
        //salva a referencia
        let thiss = this;
        this.modaltitle = 'Lista de Clientes';
        $.ajax({
            type: "POST",
            url: './control/posvenda/control_posvendapj.php?page=edit',
            data: {id: val},
            beforeSend() {

                $('.modal-extralarge-result').html(thiss.invokeLoading());

            },
            success: (response) => {

                $('.modal-extralarge-result').html(response);

                this.controleform_Edit_PJ();

                $('#form-posvendapj').on('submit', function (e) {

                        e.preventDefault();
                        thiss.controleSalvar_pj(this);

                    }
                );


            }

        });

    }

    controleSalvar_pj(refer){

        let thiss = this;

        var data = $(refer).serialize();
        var check = [];
        $('.getvalor').each(function () {

            if ($(this).is(":checked")) {
                check.push($(this).val());
            }

        });
        check = check.toString();
        if ($('#adesao').val() == '' && $('#posvenda').val() == 'SIM') {

            toastr.error('Informe o tipo da Adesão');
            $('#adesao').focus();
            return false;
        }
        if ($('#adesao').val() == 'BOLETO' && $('#tipo_boleto').val() == '') {

            toastr.warning('Informe o tipo do Boleto');
            $('#tipo_boleto').focus();
            return false;
        }
        if ($('#tipo_boleto').val() == 'A VISTA' && $('#status-boleto').val() == '') {

            toastr.warning('Informe se o boleto foi pago');
            $('#tipo_boleto').focus();
            return false;
        }

        if ($('#classificacao').val() == '' && $('#posvenda').val() == 'SIM') {

            toastr.warning('Informe a Origem da Venda');
            $('#classificacao').focus();
            return false;
        }

        if ($('#status-boleto').val() == 'NAO' && $('#status').val() == 'CONCLUIDO') {

            toastr.warning('Cliente não Pagou a Parcela a Vista');
            return false;
        }

        if ($('#posvenda').val() == 'NAO' && $('#status').val() == 'CONCLUIDO') {

            toastr.warning('Pós-Venda não Concluído');
            return false;
        }

        $.ajax({

            type: 'POST',
            url: './control/posvenda/control_posvendapj.php?page=salve',
            data: data + '&tipo=' + check,
            success: function () {

                toastr.success('Atualizado com Sucesso');
                 thiss.hideModal();
                $("#tabela-posvendapj").dataTable().fnDestroy();
                thiss.loadposvendaPJ();
            }
        });

    }

    controleform_Edit_PJ(){

        var $adesao = $('#adesao'), $datacartao = $('#datacartao'), $valorcartao = $('#valorcartao'),
            $avista = $('#avista'), $tipo_boleto = $('#tipo-boleto'), $classificacao = $('#classificacao');
        $adesao.change(function () {

            if ($adesao.val() == 'CARTAO') {

                $datacartao.css('display', 'block');
                $valorcartao.css('display', 'block');
                $avista.css('display', 'none');
                $tipo_boleto.css('display', 'none');
                $('#datacartao input').datepicker({
                    language: "pt-BR",
                    format: "dd/mm/yyyy",
                    todayHighlight: true
                });
                $('.valor').mask('#.##0,00', {reverse: true});
                $('#status-boleto').val('');
                $('#tipo_boleto').val('');

            } else if ($adesao.val() == 'BOLETO') {

                $datacartao.css('display', 'none');
                $valorcartao.css('display', 'none');
                $tipo_boleto.css('display', 'block');
                $('#dt-cartao').val('');
                $('#cartao').val('');
                if ($('#tipo_boleto').val() == 'A VISTA') {
                    $avista.css('display', 'block');
                }
                $tipo_boleto.change(function () {
                    if ($('#tipo_boleto').val() == '') {
                        $avista.css('display', 'none');
                        $('#status-boleto').val('');
                    } else if ($('#tipo_boleto').val() == 'A PRAZO') {
                        $avista.css('display', 'none');
                    } else {
                        $avista.css('display', 'block');
                    }
                });

            } else {
                $datacartao.css('display', 'none');
                $valorcartao.css('display', 'none');
                $avista.css('display', 'none');
                $tipo_boleto.css('display', 'none');
                $('#status-boleto').val('');
                $('#tipo_boleto').val('');
                $('#dt-cartao').val('');
                $('#cartao').val('');


            }

        }).trigger('change');

    }



    set modaltitle(value) {

        this._modaltitle.innerHTML = value;
    }


    get modaltitle() {

        return this._modaltitle.innerHTML;
    }

}
