$(function () {
    var start = moment(), end = moment(), start_month = moment().startOf('month'), end_month = moment().endOf('month');

    c3.generate({
        bindto: '#gaugeChart',
        data: {
            columns: [
                ['Instalados', $('#gaugeChart').attr('data-instalados')]
            ],

            type: 'gauge'
        },
        gauge: {
            max: $('#gaugeChart').attr('data-meta')
        },
        color: {
            pattern: ['#18C5A9', '#f2f3fa']

        },
        size: {
            height: 130
        }

    });

    // Chart a
    $.getJSON("./control/dashboards/manager_dashadm.php?page=loadvendasanual", function (data) {

        const meses = [];
        const meses2 = [];
        const valor = [];

        $.each(data, function (key, val) {

            meses.push(val.mes.substring(0, 1));
            meses2.push(val.mes);
            valor.push(val.valor);
        });


        var chartdata = {
            labels: meses,
            datasets: [
                {
                    label: "Total",
                    backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                    borderColor: "#fff",
                    hoverBackgroundColor: '#fff',
                    data: valor
                }
            ]
        };
        var chartOptions = {
            tooltips: {
                callbacks: {
                    title: function (tooltipItem) {

                        return meses2[tooltipItem[0].index];

                    }
                }

            },
            responsive: true,
            maintainAspectRatio: false,
            showScale: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                    },
                    ticks: {
                        fontColor: '#fff'
                    }
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                        drawTicks: false,
                        tickMarkLength: 0
                    },
                    ticks: {
                        display: false,
                        padding: 0,
                        fontColor: '#eee'
                    },
                }]
            },
            legend: {display: false}
        };
        var ctx = document.getElementById("chart_a").getContext("2d");
        new Chart(ctx, {type: 'bar', data: chartdata, options: chartOptions});

    });

    load_top_cidades(start_month.format('YYYY-MM-DD'), end_month.format('YYYY-MM-DD'));

    function cb(start, end) {
        $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        load_resumoVendas(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        minDate: "01/08/2018",
        maxDate: "31/12/2020",
        showDropdowns: !0,
        timePicker12Hour: !0,
        ranges: {
            'Hoje': [moment(), moment()],
            'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Últimos 7 Dias': [moment().subtract(6, 'days'), moment()],
            'Últimos 30 Dias': [moment().subtract(29, 'days'), moment()],
            'Este Mês': [moment().startOf('month'), moment().endOf('month')],
            'Mês Passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        buttonClasses: ["btn btn-default"],
        applyClass: "btn-small btn-redenilf",
        cancelClass: "btn-small",
        format: "DD/MM/YYYY",
        separator: " to ",
        locale: {
            applyLabel: "Aplicar",
            cancelLabel: "Limpar",
            fromLabel: "From",
            toLabel: "To",
            customRangeLabel: "Personalizado",
            daysOfWeek: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
            monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
            firstDay: 1
        }
    }, cb);
    cb(start, end);

});


function load_resumoVendas(a, b) {


    $.ajax({

        type: 'POST',
        url: './control/dashboards/manager_dashadm.php?page=formresumo',
        data: {inicio: a, fim: b},
        beforeSend() {

            $('#resumo-vendas').html('<div class="sidenav-backdrop backdrop"></div>\n' +
                '<div class="preloader-backdrop">\n' +
                '    <div class="page-preloader">Carregando</div>\n' +
                '</div>')

        },
        success: function (response) {

            $('#resumo-vendas').html(response);
            $('#datatable').DataTable({
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                pageLength: 50,
                fixedHeader: true,
                responsive: true,
                "sDom": 'rtip',
                buttons: [
                    {
                        extend: 'collection',
                        text: 'Export',
                        buttons: [
                            'copy',
                            'excel',
                            'print',
                            'csv'

                        ]
                    },
                ],
                columnDefs: [{
                    orderable: false
                }]
            });

            $('[data-toggle="tooltip"]').tooltip();

            var table = $('#datatable').DataTable();
            $('#key-search').on('keyup', function () {
                table.search(this.value).draw();
            });
            $('#type-filter').on('change', function () {
                table.column(6).search($(this).val()).draw();
            });

        }

    });
}

function exporttable(value) {

    var table = $('#datatable').DataTable();

    table.buttons(value).trigger();

}

function load_top_cidades(start, end) {

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: './control/dashboards/manager_dashadm.php?page=loadcidadestop',
        data: {data_i: start, data_f: end},
        beforeSend() {
            $('#top_cidades').html('<div class="ibox-body">' +
                '<div class="card">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $("#top_cidades").empty();
            Morris.Donut({
                element: 'top_cidades',
                data: response,
                resize: true,
                colors: ['#18c3a8', '#5c6bbe', '#2dc2c9', '#f4595e', '#f39c12', '#28a745', '#ef6594'],
            });

        }
    });
}




