
$(function () {
    moment.locale('pt-br');
    $('.easypie').each(function () {
        $(this).easyPieChart({
            trackColor: $(this).attr('data-trackColor') || '#f2f2f2',
            scaleColor: false,
        });
    });
    const start = moment().startOf('month'), end = moment().endOf('month'),
        maxdate = moment().endOf('year');

    $('#reportrange-crm').daterangepicker({
        ranges: {
            'Hoje': [moment(), moment()],
            'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Amanhã': [moment().add(1, 'days'), moment().add(1, 'days')],
            'Esta Semana': [moment().day(1), moment().day(5)],
            'Este Mês': [moment().startOf('month'), moment().endOf('month')],
            'Este Ano': [moment().startOf('year'), moment().endOf('year')],
        },
        buttonClasses: ["btn btn-default"],
        applyClass: "btn-sm btn-redenilf",
        cancelClass: "btn-sm",
        todayHighlight: true,
        separator: " to ",
        locale: {
            format: "DD/MM/YYYY",
            applyLabel: "Aplicar",
            cancelLabel: "Limpar",
            fromLabel: "From",
            toLabel: "To",
            customRangeLabel: "Personalizado",
            daysOfWeek: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
            monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
            firstDay: 1
        },
        showCustomRangeLabel: true,
        startDate: start,
        endDate: end,
        "minDate": "01/04/2019",
        "maxDate": maxdate,
    }, cb);
    cb(start, end);

    function cb(start, end) {
        $('#reportrange-crm span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        loadReuniao(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    }

    function op(start, end) {
        $('#reportrange-oportunidade span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        loadOportunidade(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    }

    function so(start, end) {
        $('#reportrange-soma-oportunidade span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        somaOportunidade(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    }

    $('#reportrange-oportunidade').daterangepicker({
        ranges: {
            'Hoje': [moment(), moment()],
            'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Amanhã': [moment().add(1, 'days'), moment().add(1, 'days')],
            'Esta Semana': [moment().day(1), moment().day(5)],
            'Este Mês': [moment().startOf('month'), moment().endOf('month')],
            'Este Ano': [moment().startOf('year'), moment().endOf('year')],
        },
        buttonClasses: ["btn btn-default"],
        applyClass: "btn-sm btn-redenilf",
        cancelClass: "btn-sm",
        todayHighlight: true,
        separator: " to ",
        locale: {
            format: "DD/MM/YYYY",
            applyLabel: "Aplicar",
            cancelLabel: "Limpar",
            fromLabel: "From",
            toLabel: "To",
            customRangeLabel: "Personalizado",
            daysOfWeek: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
            monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
            firstDay: 1
        },
        showCustomRangeLabel: true,
        startDate: start,
        endDate: end,
        "minDate": "01/04/2019",
        "maxDate": maxdate,
    }, op);
    op(start, end);

    $('#reportrange-soma-oportunidade').daterangepicker({
        ranges: {
            'Hoje': [moment(), moment()],
            'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Amanhã': [moment().add(1, 'days'), moment().add(1, 'days')],
            'Esta Semana': [moment().day(1), moment().day(5)],
            'Este Mês': [moment().startOf('month'), moment().endOf('month')],
            'Este Ano': [moment().startOf('year'), moment().endOf('year')],
        },
        buttonClasses: ["btn btn-default"],
        applyClass: "btn-sm btn-redenilf",
        cancelClass: "btn-sm",
        todayHighlight: true,
        separator: " to ",
        locale: {
            format: "DD/MM/YYYY",
            applyLabel: "Aplicar",
            cancelLabel: "Limpar",
            fromLabel: "From",
            toLabel: "To",
            customRangeLabel: "Personalizado",
            daysOfWeek: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
            monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
            firstDay: 1
        },
        showCustomRangeLabel: true,
        startDate: start,
        endDate: end,
        "minDate": "01/04/2019",
        "maxDate": maxdate,
    }, so);
    so(start, end);
});


function loadReuniao(start, end) {

    $.ajax({
        type: 'POST',
        url: './control/dashboards/manager_dashcrm.php?page=loadReuniao',
        data: {inicio: start, fim: end},
        beforeSend() {

            $('#loadReuniao').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $('#loadReuniao').html(response);
            $('.easypie').each(function () {
                $(this).easyPieChart({
                    trackColor: $(this).attr('data-trackColor') || '#f2f2f2',
                    scaleColor: false,
                });
            });
        }
    });
};

function formatMoney(n, c, d, t) {
    c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
    return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
}


function loadOportunidade(start, end) {

    $.ajax({
        type: 'POST',
        url: './control/dashboards/manager_dashcrm.php?page=loadOportunidade',
        data: {inicio: start, fim: end},
        beforeSend() {

            $('#loadOportunidade').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $('#loadOportunidade').html(response);
            $('.easypie').each(function () {
                $(this).easyPieChart({
                    trackColor: $(this).attr('data-trackColor') || '#f2f2f2',
                    scaleColor: false,
                });
            });
            $.fn.dataTable.moment('DD/MM/YYYY');
            var api;
            $('#datatable-oportunidade').DataTable({
                "columnDefs" : [
                    {
                        "targets" : [8],
                        "visible" : false,
                        "searchable" : true,
                    }
                ],
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                "sDom" : 'rtip',
                responsive: false,
                "order": [[0, "desc"]],
                "footerCallback": function (tfoot, data, start, end, display) {
                     api = this.api();

                    // Remove the formatting to get integer data for summation
                    var intVal = function (i) {
                        return typeof i === 'string' ?
                            i.replace(/[\$,]/g, '') * 1 :
                            typeof i === 'number' ?
                                i : 0;

                    };

                    // Total over all pages

                    if (api.column().data().length) {
                        var total = api
                            .column(8)
                            .data()
                            .reduce(function (a, b) {
                                return intVal(a) + intVal(b);
                            })
                    } else {
                        total = 0
                    }



                    // Total over this page

                    if (api.column().data().length) {
                        var pageTotal = api
                            .column(8, {page: 'current'})
                            .data()
                            .reduce(function (a, b) {
                                return intVal(a) + intVal(b);
                            })
                    } else {
                        pageTotal = 0
                    }


                    // Update footer
                    $(api.column(6).footer()).html(
                        'R$ ' + formatMoney(pageTotal) + ' ( Total Geral ' + ' R$ ' +formatMoney(total) + ' )'
                    );
                },

            });

            $('#key-search').on('keyup', function () {
                  api = api.search(this.value).draw();

            });
            $('#type-filter-table-oportunidades').on('change', function () {
                  api.column(7).search($(this).val()).draw();
            });





            // carrega o easypie a cada troca de página
            $('#datatable-oportunidade').on('page.dt', function () {
                $('.easypie').each(function () {
                    $(this).easyPieChart({
                        trackColor: $(this).attr('data-trackColor') || '#f2f2f2',
                        scaleColor: false,
                    });
                });
            });
        }
    });
};

function somaOportunidade(start, end) {

    $.ajax({
        type: 'POST',
        url: './control/dashboards/manager_dashcrm.php?page=loadSomaOportunidades',
        data: {inicio: start, fim: end},
        beforeSend() {

            $('#loadSomaOportunidades').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $('#loadSomaOportunidades').html(response);
            $('.easypie').each(function () {
                $(this).easyPieChart({
                    trackColor: $(this).attr('data-trackColor') || '#f2f2f2',
                    scaleColor: false,
                });
            });
        }
    });
};
