$(function () {
    var start = moment(), end = moment(),
        maxdate = moment().add(1, 'month');

    $.getJSON("./control/dashboards/manager_dashos.php?page=chart_os_mes", function (data) {
       loadchart_os(data);
    });


    $('#reportrange').daterangepicker({
        ranges: {
            'Hoje': [moment(), moment()],
            'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Amanhã': [moment().add(1, 'days'), moment().add(1, 'days')],
            'Esta Semana': [moment().day(1), moment().day(5)],
            'Este Mês': [moment().startOf('month'), moment().endOf('month')],
        },
        buttonClasses: ["btn btn-default"],
        applyClass: "btn-sm btn-redenilf",
        cancelClass: "btn-sm",
        todayHighlight: true,
        separator: " to ",
        locale: {
            format: "DD/MM/YYYY",
            applyLabel: "Aplicar",
            cancelLabel: "Limpar",
            fromLabel: "From",
            toLabel: "To",
            customRangeLabel: "Personalizado",
            daysOfWeek: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
            monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
            firstDay: 1
        },
        showCustomRangeLabel: true,
        startDate: start,
        endDate: end,
        "minDate": moment().startOf('month').subtract(1, 'year'),
        "maxDate": maxdate,
    }, cb);
    cb(start, end);


    function cb(start, end) {
        $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        loadtabelaTecnico(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    }

    load_tipo_os(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    chart_os_pendente(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));


});

//CARREGA GRAFICO ACUMULADO DE OS AUTOMATICAMENTE
function loadchart_os(data) {

    let datas = [];
    let instalacao = [];
    let manutencao = [];
    let retirada = [];
    let transferencia = [];
    let migracao = [];

    $.each(data, function (index, value) {

        if (value.Migração === undefined) {
            value.Migração = 0;
        }
        if (value.Transferência === undefined) {
            value.Transferência = 0;
        }
        if (value.Instalação === undefined) {
            value.Instalação = 0;
        }
        if (value.Manutenção === undefined) {
            value.Manutenção = 0;
        }
        if (value.Cancelamento === undefined) {
            value.Cancelamento = 0;
        }

        datas.push(index.substr(8,9));
        instalacao.push(value.Instalação);
        manutencao.push(value.Manutenção);
        retirada.push(value.Cancelamento);
        transferencia.push(value.Transferência);
        migracao.push(value.Migração);

    });

    var ctx = document.getElementById("visitors_chart").getContext("2d");
    var visitors_chart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: datas,
            datasets: [
                {
                    label: "Tranferência",
                    data: transferencia,
                    backgroundColor: 'rgba(255,165,0,0.7)',
                    borderColor: 'rgba(255,165,0,0.7)',
                    pointBackgroundColor: 'rgba(255,165,0,0.7)',
                    pointBorderColor: 'rgba(255,165,0,0.7)',
                    borderWidth: 1,
                    pointBorderWidth: 1,
                    pointRadius: 0,
                    pointHitRadius: 30,
                }, {
                    label: "Migração",
                    data: migracao,
                    backgroundColor: 'rgba(0,128,0,0.7)',
                    borderColor: 'rgba(0,128,0,0.7)',
                    pointBackgroundColor: 'rgba(0,128,0,0.7)',
                    pointBorderColor: 'rgba(0,128,0,0.7)',
                    borderWidth: 1,
                    pointBorderWidth: 1,
                    pointRadius: 0,
                    pointHitRadius: 30,
                },
                {
                    label: "Cancelamento",
                    data: retirada,
                    borderColor: 'rgb(139,69,19)',
                    backgroundColor: 'rgb(139,69,19)',
                    pointBackgroundColor: 'rgb(139,69,19)',
                    pointBorderColor: 'rgb(139,69,19)',
                    borderWidth: 1,
                    pointBorderWidth: 1,
                    pointRadius: 0,
                    pointHitRadius: 30,
                }, {
                    label: "Manutenção",
                    data: manutencao,
                    backgroundColor: 'rgba(135,206,250,0.7)',
                    borderColor: 'rgba(135,206,250,0.7)',
                    pointBackgroundColor: 'rgba(135,206,250,0.7)',
                    pointBorderColor: 'rgba(135,206,250,0.7)',
                    borderWidth: 1,
                    pointBorderWidth: 1,
                    pointRadius: 0,
                    pointHitRadius: 30,
                },
                {
                    label: "Instalação",
                    data: instalacao,
                    borderColor: 'rgba(255,255,0,0.9)',
                    backgroundColor: 'rgba(255,255,0,0.9)',
                    pointBackgroundColor: 'rgba(255,255,0,0.9)',
                    pointBorderColor: 'rgba(255,255,0,0.9)',
                    borderWidth: 1,
                    pointBorderWidth: 1,
                    pointRadius: 0,
                    pointHitRadius: 30,
                },
            ],
        },
        options: {
            tooltips: {
                callbacks: {
                    title: function (tooltipItem) {

                        return 'Dia: ' + datas[tooltipItem[0].index];
                    }
                }

            },
            responsive: true,
            maintainAspectRatio: false,
            showScale: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                    },
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                    },
                }]
            },
            legend: {
                labels: {
                    boxWidth: 12
                }
            },
        }
    });

    //CARREGA O GRAFICO ACUMULADO DE ACORDO COM O BOTAO DA DATA ESCOLHIDO
    $('#chart_tabs a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var id = $(this).attr('data-id');
        if (id === 'Mes') {

            // Chart a
            $.getJSON("./control/dashboards/manager_dashos.php?page=chart_os_mes", function (data) {

                let datas = [];
                let instalacao = [];
                let manutencao = [];
                let retirada = [];
                let transferencia = [];
                let migracao = [];

                $.each(data, function (index, value) {

                    if (value.Migração === undefined) {
                        value.Migração = 0;
                    }
                    if (value.Transferência === undefined) {
                        value.Transferência = 0;
                    }
                    if (value.Instalação === undefined) {
                        value.Instalação = 0;
                    }
                    if (value.Manutenção === undefined) {
                        value.Manutenção = 0;
                    }
                    if (value.Cancelamento === undefined) {
                        value.Cancelamento = 0;
                    }

                    datas.push(index.substr(8,9));
                    instalacao.push(value.Instalação);
                    manutencao.push(value.Manutenção);
                    retirada.push(value.Cancelamento);
                    transferencia.push(value.Transferência);
                    migracao.push(value.Migração);

                });

                visitors_chart.data.labels = datas;
                visitors_chart.options.tooltips.callbacks.title = (function (tooltipItem) {

                    return 'Dia: ' + datas[tooltipItem[0].index];

                });

                $.each(visitors_chart.data.datasets, function (index, value) {

                    if (visitors_chart.data.datasets[index].label === 'Instalação') {
                        visitors_chart.data.datasets[index].data = instalacao;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Manutenção') {
                        visitors_chart.data.datasets[index].data = manutencao;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Cancelamento') {
                        visitors_chart.data.datasets[index].data = retirada;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Migração') {
                        visitors_chart.data.datasets[index].data = migracao;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Transferência') {
                        visitors_chart.data.datasets[index].data = transferencia;

                    }
                });

                visitors_chart.update();
            });


        }else if(id === 'Ano'){

            $.getJSON("./control/dashboards/manager_dashos.php?page=chart_os_ano", function (data) {

                let datas = [];
                let instalacao = [];
                let manutencao = [];
                let retirada = [];
                let transferencia = [];
                let migracao = [];

                $.each(data, function (index, value) {

                    if (value.Migração === undefined) {
                        value.Migração = 0;
                    }
                    if (value.Transferência === undefined) {
                        value.Transferência = 0;
                    }
                    if (value.Instalação === undefined) {
                        value.Instalação = 0;
                    }
                    if (value.Manutenção === undefined) {
                        value.Manutenção = 0;
                    }
                    if (value.Cancelamento === undefined) {
                        value.Cancelamento = 0;
                    }

                    datas.push(index);
                    instalacao.push(value.Instalação);
                    manutencao.push(value.Manutenção);
                    retirada.push(value.Cancelamento);
                    transferencia.push(value.Transferência);
                    migracao.push(value.Migração);

                });

                visitors_chart.data.labels = datas;
                visitors_chart.options.tooltips.callbacks.title = (function (tooltipItem) {

                    return 'Mês: ' + datas[tooltipItem[0].index];

                });

                $.each(visitors_chart.data.datasets, function (index, value) {

                    if (visitors_chart.data.datasets[index].label === 'Instalação') {
                        visitors_chart.data.datasets[index].data = instalacao;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Manutenção') {
                        visitors_chart.data.datasets[index].data = manutencao;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Cancelamento') {
                        visitors_chart.data.datasets[index].data = retirada;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Migração') {
                        visitors_chart.data.datasets[index].data = migracao;

                    }
                    if (visitors_chart.data.datasets[index].label === 'Transferência') {
                        visitors_chart.data.datasets[index].data = transferencia;

                    }
                });

                visitors_chart.update();
            });

        }
    });
}

function loadtabelaTecnico(start, end) {

    $.ajax({

        type: 'POST',
        url: './control/dashboards/manager_dashos.php',
        data: {inicio: start, fim: end},
        beforeSend() {

            $('#tabela-tecnicos').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>')

        },
        success: function (response) {

            $('#tabela-tecnicos').html(response);
            $('#datatable-tec').DataTable({
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                responsive: true,
                autoWidth: false,
                "order": [[7, "desc"]]
            });

            $('.easypie').each(function () {
                $(this).easyPieChart({
                    trackColor: $(this).attr('data-trackColor') || '#f2f2f2',
                    scaleColor: false,
                });
            });

            $('[data-toggle="tooltip"]').tooltip();

        }

    });
}

function load_tipo_os(start, end) {

    $.ajax({
        type: 'POST',
        url: './control/dashboards/manager_dashos.php?page=load_os_tipo',
        data: {inicio: start, fim: end},
        beforeSend() {

            $('#load_tipo_os').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('#load_tipo_os').html(response);
            $('.easypie').each(function () {
                $(this).easyPieChart({
                    barColor: $(this).attr('data-bar-color') || '#fffffb',
                    scaleColor: false,
                });

            });
        }

    });

}

function chart_os_pendente(start, end) {

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: './control/dashboards/manager_dashos.php?page=chart_os_pendente',
        data: {inicio: start, fim: end},
        beforeSend() {
            $('#chart_os_pendente').html('<div class="ibox-body">' +
                '<div class="card">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $("#chart_os_pendente").empty();
            Morris.Donut({
                element: 'chart_os_pendente',
                data: response,
                resize: true,
                colors: ['#8b4513', 'yellow', '#87cefa', 'orange', 'green'],
            });
            const valor = [];
            $.each(response, function (key, val) {
                valor.push(val.value);
            });

            const total = arr => arr.reduce((a, b) => a + b, 0);

            $('#pendentes_tipo').text(total(valor));
        }
    });
}


