$(function () {

    moment.locale('pt-br');

    var start = moment().startOf('month'), // primeiro dia deste mes
        end = moment().subtract(1, "days"), // ontem
        now = moment(), // hoje
        start_last1 = moment().subtract(1, "month").startOf("month"), // primeiro dia do mes passado
        end_last1 = moment().subtract(1, "month").subtract(1, "days"), // mesmo dia do mes passado menos 1 dia
        start_last2 = moment().subtract(2, "month").startOf("month"), // primeiro  dia do mes retrasado
        end_last2 = moment().subtract(2, "month").subtract(1, "days"); // mesmo dia do mes retrasado menos 1 dia


    // CARREGA WIDGETS DE FATURAMENTO
    $.getJSON("./control/financeiro/manager_financeiro.php?page=loadchart1", function (data) {

        const dias = [], valor = [];
        let total;
        const reducer = (accumulator, currentValue) => accumulator + currentValue;


        $.each(data, function (key, val) {

            dias.push(val.dia);
            valor.push(val.valor)
        });

        var chartdata_1 = {
            labels: dias,
            datasets: [
                {
                    label: " Total",
                    backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                    borderColor: "#fff",
                    hoverBackgroundColor: '#fff',
                    data: valor
                }
            ]
        };
        var chartOptions_1 = {
            tooltips: {
                callbacks: {
                    title: function (tooltipItem) {

                        return 'Dia: ' + dias[tooltipItem[0].index];

                    },
                    label: function (tooltipItem) {

                        return 'R$ ' + formatMoney(tooltipItem.yLabel);

                    }
                }

            },
            responsive: true,
            maintainAspectRatio: false,
            showScale: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                    },
                    ticks: {
                        fontColor: '#fff'
                    }
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                        drawTicks: false,
                        tickMarkLength: 0
                    },
                    ticks: {
                        display: false,
                        padding: 0,
                        fontColor: '#eee'
                    },
                }]
            },
            legend: {display: false}
        };

        var ctx = document.getElementById("chart_1").getContext("2d");
        new Chart(ctx, {type: 'bar', data: chartdata_1, options: chartOptions_1});
        total = formatMoney(valor.reduce(reducer));
        $('.total_1').text('R$ ' + total);
    });

    $.getJSON("./control/financeiro/manager_financeiro.php?page=loadchart2", function (data) {

        const dias = [], valor = [];
        let total;
        const reducer = (accumulator, currentValue) => accumulator + currentValue;


        $.each(data, function (key, val) {

            dias.push(val.dia);
            valor.push(val.valor)
        });

        var chartdata_1 = {
            labels: dias,
            datasets: [
                {
                    label: " Total",
                    backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                    borderColor: "#fff",
                    hoverBackgroundColor: '#fff',
                    data: valor
                }
            ]
        };
        var chartOptions_1 = {
            tooltips: {
                callbacks: {
                    title: function (tooltipItem) {

                        return 'Dia: ' + dias[tooltipItem[0].index];

                    },
                    label: function (tooltipItem) {

                        return 'R$ ' + formatMoney(tooltipItem.yLabel);

                    }
                }

            },
            responsive: true,
            maintainAspectRatio: false,
            showScale: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                    },
                    ticks: {
                        fontColor: '#fff'
                    }
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                        drawTicks: false,
                        tickMarkLength: 0
                    },
                    ticks: {
                        display: false,
                        padding: 0,
                        fontColor: '#eee'
                    },
                }]
            },
            legend: {display: false}
        };

        var ctx = document.getElementById("chart_2").getContext("2d");
        new Chart(ctx, {type: 'bar', data: chartdata_1, options: chartOptions_1});
        total = formatMoney(valor.reduce(reducer));
        $('.total_2').text('R$ ' + total);
    });

    $.getJSON("./control/financeiro/manager_financeiro.php?page=loadchart3", function (data) {

        const dias = [], valor = [];
        let total;
        const reducer = (accumulator, currentValue) => accumulator + currentValue;


        $.each(data, function (key, val) {

            dias.push(val.dia);
            valor.push(val.valor)
        });

        var chartdata_1 = {
            labels: dias,
            datasets: [
                {
                    label: " Total",
                    backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                    borderColor: "#fff",
                    hoverBackgroundColor: '#fff',
                    data: valor
                }
            ]
        };
        var chartOptions_1 = {
            tooltips: {
                callbacks: {
                    title: function (tooltipItem) {

                        return 'Dia: ' + dias[tooltipItem[0].index];

                    },
                    label: function (tooltipItem) {

                        return 'R$ ' + formatMoney(tooltipItem.yLabel);

                    }
                }

            },
            responsive: true,
            maintainAspectRatio: false,
            showScale: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                    },
                    ticks: {
                        fontColor: '#fff'
                    }
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                        drawTicks: false,
                        tickMarkLength: 0
                    },
                    ticks: {
                        display: false,
                        padding: 0,
                        fontColor: '#eee'
                    },
                }]
            },
            legend: {display: false}
        };

        var ctx = document.getElementById("chart_3").getContext("2d");
        new Chart(ctx, {type: 'bar', data: chartdata_1, options: chartOptions_1});
        total = formatMoney(valor.reduce(reducer));
        $('.total_3').text('R$ ' + total);
    });


    // CARREGA COMPARATIVO DE VENCIMENTO

    loadcomparativo_fat(start.format('DD-MM-YYYY'), end.format('DD-MM-YYYY'), start_last1.format('DD-MM-YYYY'),
        end_last1.format('DD-MM-YYYY'), start_last2.format('DD-MM-YYYY'), end_last2.format('DD-MM-YYYY'));

    function cb(start, end) {
        $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        tabela_extrato(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    }

    $('#reportrange').daterangepicker({
        showCustomRangeLabel: false,
        startDate: start,
        endDate: end,
        ranges: {
            "Este Mês": [moment().startOf("month"), moment()
            ],
            "Mês Passado": [
                moment().subtract(1, "month").startOf("month"), moment().subtract(1, "month").endOf("month")
            ],
            "Mês Retrasado": [
                moment().subtract(2, "month").startOf("month"), moment().subtract(2, "month").endOf("month")
            ]
        },
        locale: {
            format: "DD/MM/YYYY",
            separator: " - ",
            applyLabel: "Aplicar",
            cancelLabel: "Cancelar",
            daysOfWeek: [
                "Dom",
                "Seg",
                "Ter",
                "Qua",
                "Qui",
                "Sex",
                "Sab"
            ],
            monthNames: [
                "Janeiro",
                "Fevereiro",
                "Março",
                "Abril",
                "Maio",
                "Junho",
                "Julho",
                "Agosto",
                "Setembro",
                "Outubro",
                "Novembro",
                "Dezembro"
            ]
        }
    }, cb);
    cb(start, end < start ? now : end);

    chart_recebimentoanual();

    //remove o active da classe tab-panel devido a um BUG do bootstrap
    $('#tabFinanceiro a').on('click', function () {

        $('.tab-pane').removeClass('active')

    });

    historico_conexao_new();
});


const loadModalHistorico = (tipo) =>{

    $("#modal_extraLarge").modal('show');
    $("#modal_extraLarge .modal-title").html("<h5>Clientes " + tipo + "</h5>");
    $.ajax({
        type: 'POST',
        url: './control/financeiro/manager_financeiro.php?page=historico_conexao_modal',
        data: {data: tipo},
        beforeSend() {

            $('#modal_extraLarge .modal-extralarge-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {
            $("#modal_extraLarge .modal-extralarge-result").html(response);
            $('#datatable-modal-' + tipo + '').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                "order": [[0, "desc"]],
            });

        }
    });

}
const historico_conexao_new = () => {

    $.ajax({
        type: 'GET',
        url: './control/financeiro/manager_financeiro.php?page=historico_conexao_new',
        beforeSend() {

            $('#historico_conexao_new').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('#historico_conexao_new').html(response);
            $('[data-toggle="tooltip"]').tooltip();


            //CHART HISTORICO CONEXAO
            const label = $('#line_conexao_historico').attr('data-dates');
            const desbloqueados_data = $('#line_conexao_historico').attr('data-desbloqueados_dia');
            const bloqueados_data = $('#line_conexao_historico').attr('data-bloqueados_dia');
            const reduzidos_data = $('#line_conexao_historico').attr('data-reduzidos_dia');

            var lineData = {
                labels: label.split(','),
                datasets: [
                    {
                        // Purple
                        label: "Desbloqueados",
                        //data: [35, 32, 70, 40, 56, 55, 40, 37, 48, 30],
                        data: desbloqueados_data.split(','),
                        //data: [10, 25, 33, 42, 33, 25, 35, 37, 48, 30],
                        borderColor: 'rgba(24,197,169,1)',
                        backgroundColor: 'rgba(24,197,169,.7)',
                        pointBackgroundColor: 'rgba(17,148,126,0.7)',
                        pointBorderColor: 'rgba(24,197,169,1)',
                        borderWidth: 1,
                        pointBorderWidth: 1,
                        pointRadius: 0,
                        pointHitRadius: 30,
                    }, {
                        // Pink
                        label: "Bloqueados",
                        //data: [28, 48, 40, 19, 86, 27, 32, 67, 32, 22],
                        data: bloqueados_data.split(','),
                        backgroundColor: 'rgba(255,123,171,0.7)',
                        borderColor: 'rgba(255,64,129, 0.7)',
                        pointBackgroundColor: 'rgba(191,40,90,0.7)',
                        pointBorderColor: 'rgba(255,64,129, 0.7)',
                        borderWidth: 1,
                        pointBorderWidth: 1,
                        pointRadius: 0,
                        pointHitRadius: 30,
                    }, {
                        // Green
                        label: "Reduzidos",
                        //data: [24, 75, 63, 50, 42, 85, 33, 45, 56, 37],
                        data: reduzidos_data.split(','),
                        borderColor: '#d2c398',
                        backgroundColor: '#eacb99',
                        pointBackgroundColor: '#c8aa7b',
                        pointBorderColor: '#d2c398',
                        borderWidth: 1,
                        pointBorderWidth: 1,
                        pointRadius: 0,
                        pointHitRadius: 30,
                    },
                ],
            };
            var lineOptions = {
                responsive: true,
                maintainAspectRatio: false,
                showScale: false,
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                        },
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                    }]
                },
                legend: {
                    labels: {
                        boxWidth: 12
                    }
                },
            };
            const historico_chart = document.getElementById("line_conexao_historico").getContext("2d");
            new Chart(historico_chart, {type: 'line', data: lineData, options: lineOptions});


            // CHART ACUMULADO HISTORICO CONEXAO
            const desbloqueados = $('#chart_acumulado_historico_conexao').attr('data-desbloqueados');
            const bloqueados = $('#chart_acumulado_historico_conexao').attr('data-bloqueados');
            const label_mes = $('#chart_acumulado_historico_conexao').attr('data-label-mes');
            const chart_acumulado = {
                labels: label_mes.split(','),
                datasets: [
                    {
                        label: "Desbloqueados",
                        backgroundColor: '#18C5A9',
                        borderColor: "#fff",
                        data: desbloqueados.split(',')
                    },
                    {
                        label: "Bloqueados",
                        backgroundColor: 'rgba(255,123,171,0.7)',
                        borderColor: "#fff",
                        data: bloqueados.split(',')
                    }
                ]
            };
            const chartOptions_acumulado = {
                responsive: true,
                maintainAspectRatio: false,
                showScale: false,
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                            drawTicks: false,
                            tickMarkLength: 0
                        },
                        ticks: {
                            display: false,
                            padding: 0,
                        },
                    }]
                },
                legend: {display: false}
            };

            const acumulado_chart = document.getElementById("chart_acumulado_historico_conexao").getContext("2d");
            new Chart(acumulado_chart, {type: 'bar', data: chart_acumulado, options: chartOptions_acumulado});


        }
    })


}

function loadcomparativo_fat(start, now, start_last1, end_last1, start_last2, end_last2) {

    $.ajax({
        type: 'POST',
        url: './control/financeiro/manager_financeiro.php?page=comparativo_fat',
        data: {dt_a: start, dt_b: now, dt_c: start_last1, dt_d: end_last1, dt_e: start_last2, dt_f: end_last2},
        beforeSend() {

            $('#loadcomparativo').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('#loadcomparativo').html(response);

        }
    })

}


function tabela_extrato(start, end) {
    //CARREGA TABELA DE FATURAMENTO
    $.ajax({
        type: 'POST',
        url: './control/financeiro/manager_financeiro.php?page=extratodetalhado',
        data: {data_i: start, data_f: end},
        beforeSend() {

            $('#load_extrato_detalhado').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('#load_extrato_detalhado').html(response);
            $('#tabela_extrato_detalhado').dataTable({
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
            $('[data-toggle="tooltip"]').tooltip();
        }
    })
}

function formatMoney(n, c, d, t) {
    c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
    return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
}

function chart_recebimentoanual() {

    $.getJSON("./control/financeiro/manager_financeiro.php?page=loadanual_recebimento", function (data) {

        Morris.Area({
            element: 'chart_anual_recebimentos',
            data: data,
            xkey: 'mes',
            ykeys: ['valor'],
            parseTime: false,
            labels: ['valor'],
            hoverCallback: function (d, e, content, dd) {
                return '<span class="font-bold">' + dd.mes + '</span>' + '<br/>' +
                    'Valor: ' + formatMoney(dd.valor)
            },
            pointSize: 3,
            hideHover: 'auto',
            resize: true,
            pointFillColors: ['#fff'],
            pointStrokeColors: ['#006e78'],
            lineColors: ['#0eaaa0'],
            lineWidth: 2,
        });
    });

}
