$(function () {
    $('#forgot-form').validate({
        errorClass: "help-block",
        rules: {
            email: {
                required: true,
                email: true
            }
        },
        messages: {
            email: "Insira um email válido"
        },

        highlight: function (e) {
            $(e).closest(".form-group").addClass("has-error")
        },
        unhighlight: function (e) {
            $(e).closest(".form-group").removeClass("has-error")
        }

    });
});


$('#forgot-form').submit(function () {

    let email = $('#email').val();
    email = validMail(email);

    if (email) {
        const data = $('#forgot-form').serialize();
        $.ajax({
            type:'POST',
            url: './control/manager_forgotpassword.php',
            data: data,
            success: function (response) {

                if (response == 0) {
                    toastr.success("Email Enviado com Sucesso", "Aguarde o Contato do Administrador", {
                        progressBar: true, onHidden: function () {
                            window.location.replace("login.php");

                        }
                    });
                } else if (response == 2) {

                    toastr.info('Marque a Caixa Recaptcha');


                }else if(response == 3) {

                    toastr.error("Acesso Negado");
                }else {

                    toastr.error("Erro ao enviar mensagem. Contate o Administrador");

                }
            }
        });

    } else {
        return false
    }
});

function validMail(email) {
    return /^(([^<>()\[\]\.,;:\s@\"]+(\.[^<>()\[\]\.,;:\s@\"]+)*)|(\".+\"))@(([^<>()\.,;\s@\"]+\.{0,1})+([^<>()\.,;:\s@\"]{2,}|[\d\.]+))$/.test(email);
}

