$(function () {


    //DEFINE AS DATAS
    moment.locale('pt-br');

    var target = '#tab-1-3';
    var start = moment().startOf('month'), // primeiro dia deste mes
        end = moment().subtract(1, "days"), // ontem
        now = moment(), // hoje
        start_last1 = moment().subtract(1, "month").startOf("month"), // primeiro dia do mes passado
        end_last1 = moment().subtract(1, "month").endOf("month"), // ultimo dia do mes passado
        start_last2 = moment().subtract(2, "month").startOf("month"), // primeiro  dia do mes retrasado
        end_last2 = moment().subtract(2, "month").endOf("month"); // ultimo dia do mes retrasado


    //CARREGA TABELA EXTRATO COM O MES CORRENTE
        loadisp_fat(start.format('DD-MM-YYYY'), now.format('DD-MM-YYYY'), target);


    //CARREGA TABELA EXTRATO DE ACORDO COM O MES ESCOLHIDO NAS TABS
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {


        var target = $(e.target).attr("href"); // activated tab

        if (target == '#tab-1-3') {


          loadisp_fat(start.format('DD-MM-YYYY'), now.format('DD-MM-YYYY'), target);

        } else if(target == '#tab-1-2'){

           loadisp_fat(start_last1.format('DD-MM-YYYY'), end_last1.format('DD-MM-YYYY'), target);
        }else {

           loadisp_fat(start_last2.format('DD-MM-YYYY'), end_last2.format('DD-MM-YYYY'), target);
        }
    });

    //CARREGA OS CHARTS DOS CARTÕES DE PREVISAO
    loadchart(start_last2.format('DD-MM-YYYY'), end_last2.format('DD-MM-YYYY'), 'chart_a');
    loadchart(start_last1.format('DD-MM-YYYY'), end_last1.format('DD-MM-YYYY'), 'chart_b');
    loadchart(start.format('DD-MM-YYYY'), end.format('DD-MM-YYYY'), 'chart_c');

    //CARREGA CHART EVOLUCAO CARTEIRA DE CLIENTES
    chart_clientesCarteira();

});

// FUNCAO PARA CARREGAR A TABELA DE EXTRATO
function loadisp_fat(dt_i, dt_f, target) {
    target = target.substring(1);
    //CARREGA TABELA DE FATURAMENTO
    $.ajax({
        type: 'POST',
        url: './control/manager_isp.php?page=loadfaturamento',
        data: {data_i: dt_i, data_f: dt_f, id: target},
        beforeSend() {

            $('.'+target+'').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('.'+target+'').html(response);
            $('#datatable-'+target+'').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
            $('[data-toggle="tooltip"]').tooltip();
        }
    });

}

//remove o active da classe tab-panel devido a um BUG do bootstrap
$('#myTab-fatisp a').on('click', function () {

    $('.tab-pane').removeClass('active')

});

// FUNCAO PARA CARREGAR A MODAL DA TABELA DE EXTRATO
function modal_fat(day, tipo) {


    $("#modal_Large").modal('show');
    $("#modal_Large .modal-title").html('<h5>Clientes - <small>'+tipo+'</small></h5>');
    $.ajax({
            type: 'POST',
            url: './control/manager_isp.php?page=loadfaturamento_modal',
            data: {data_i: day, data_f: day, id: tipo},
            beforeSend() {

                $('#modal_Large .modal-large-result').html('<div class="modal-body">' +
                    '<div class="card mb-4">\n' +
                    '    <div class="card-body text-center">\n' +
                    '        <div class="d-flex align-items-center justify-content-center">\n' +
                    '            <div class="loader">\n' +
                    '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                    '                <div class="loader-inner"></div>\n' +
                    '                <div class="loader-inner"></div>\n' +
                    '                <div class="loader-inner"></div>\n' +
                    '            </div>\n' +
                    '        </div>\n' +
                    '    </div>\n' +
                    '  </div>\n' +
                    '</div>');

            },
            success: function (response) {

                $("#modal_Large .modal-large-result").html(response);
                $('#datatable-modal-'+tipo+'').dataTable({
                    "destroy": true,
                    "language": {
                        "url": "js/json/pt_BR.json"
                    },
                });
            }
        });

}

// FUNCAO PARA CARREGAR OS CHARTS
function loadchart(data_i, data_f, id) {

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: './control/manager_isp.php?page=loadchart',
        data: {data_i: data_i, data_f: data_f, id: id},
        beforeSend() {
            $('#'+id+'').html('<div class="ibox-body">' +
                '<div class="card">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            const data = [], valor = [];

            $.each(response, function (key, val) {

                data.push(val.data);
                valor.push(val.valor)
            });

            // Chart a

            var chartdata = {
                labels: data,
                datasets: [
                    {
                        label: "Dia",
                        backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                        borderColor: "#fff",
                        hoverBackgroundColor: '#fff',
                        data: valor
                    }
                ]
            };
            var chartOptions = {
                tooltips: {
                    callbacks: {
                        title: function (tooltipItem) {

                            return 'Dia: ' + data[tooltipItem[0].index];

                        },
                        label: function (tooltipItem) {

                            return 'R$ ' + formatMoney(tooltipItem.yLabel);

                        }
                    }

                },
                responsive: true,
                maintainAspectRatio: false,
                showScale: false,
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                        ticks: {
                            fontColor: '#fff'
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                            drawTicks:false,
                            tickMarkLength: 0
                        },
                        ticks: {
                            display: false,
                            padding: 0,
                            fontColor: '#eee'
                        },
                    }]
                },
                legend: {display: false}
            };
            var ctx = document.getElementById(id).getContext("2d");
            new Chart(ctx, {type: 'bar', data: chartdata, options: chartOptions});
        }
    });
}

//FUNÇÃO PARA FORMATAR VALORES COM AS CASA DECIMAIS CORRETAS
function formatMoney(n, c, d, t) {
    c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
    return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
}


function clientesNovos(tipo, data_i, data_f) {

    $("#modal_extraLarge").modal('show');
    $("#modal_extraLarge .modal-title").html('<h5>Clientes ISP</h5>');

    $.ajax({
        type: 'POST',
        url: './control/manager_isp.php?page=loadclientesnovos',
        data: {tipo: tipo, data_i: data_i, data_f: data_f},
        beforeSend() {

            $('#modal_extraLarge .modal-extralarge-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $("#modal_extraLarge .modal-extralarge-result").html(response);
            $('#datatable-modalclientesnovos').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
        }
    });
}

function vendasDia(grupo, segmento) {

    $("#modal_Large").modal('show');
    $("#modal_Large .modal-title").html('<h5>Vendidos ISP</h5>');

    $.ajax({
        type: 'POST',
        url: './control/manager_isp.php?page=loadclientesvendasdia',
        data: {grupo:grupo, segmento:segmento},
        beforeSend() {

            $('#modal_Large .modal-large-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $("#modal_Large .modal-large-result").html(response);
            $('#datatable-modalvendidodia').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
        }
    });
}


function listaclientesPrevisao() {

    $("#modal_Large").modal('show');
    $("#modal_Large .modal-title").html('<h5>Previsao ISP</h5>');

    $.ajax({
        type: 'GET',
        url: './control/manager_isp.php?page=loadclientesprevisao',
        beforeSend() {

            $('#modal_Large .modal-large-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $("#modal_Large .modal-large-result").html(response);
            $('#datatable-modalprevisao').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
        }
    });

}


function chart_clientesCarteira() {

    $.getJSON("./control/manager_isp.php?page=loadanual_carteira", function (data) {

        Morris.Area({
            element: 'chart_clientesCarteira',
            data: data,
            xkey: 'mes',
            ykeys: ['total'],
            parseTime: false,
            labels: ['total'],
            hoverCallback: function(d, e, content, dd){return '<span class="font-bold">'+dd.mes+'</span>'+'<br/>' +
                'Total: '+dd.total},
            pointSize: 3,
            hideHover: 'auto',
            resize: true,
            pointFillColors: ['#fff'],
            pointStrokeColors: ['#006e78'],
            lineColors: ['#0eaaa0'],
            lineWidth: 2,
        });
    });

}



