$(document).ready(function () {

    //Jquery Validate Plugin
    $('#login-form').validate({
        rules: {
            usuario: {
                required: true
            },
            password: {
                required: true
            }
        },
        messages: {
            usuario: "Informe o Usúario de Acesso!",
            password: "Informe a Senha de Acesso!"
        },

        highlight: function (e) {
            $(e).closest(".form-group").addClass("has-error");
        },
        unhighlight: function (e) {
            $(e).closest(".form-group").removeClass("has-error");
        },
        errorElement: 'span',
        errorClass: 'help-block',
        errorPlacement: function (error, element) {
            if (element.parent('.input-group-icon').length) {
                error.insertAfter(element.parent());
            } else {
                error.insertAfter(element);
            }
        }
        //submitHandler: submitForm() // verificar se existe success ou false
    });

    $('#login-form').submit(function () {

        var user = $('#usuario').val();
        var passwd = $('#password').val();
        let url = $('#url').val();

        if (user === "" || passwd === "") {
            return false;
        } else {
            const data = $('#login-form').serialize();
            $.ajax({
                type: 'POST',
                url: url,
                data: data,
                beforeSend: function () {
                    $("#login-submit").html('<i class="fa fa-spinner fa-spin" aria-hidden="true"></i> &nbsp; Carregando');
                },
                success: function (response) {
                    if ((response) === 'denied') {
                        $("#login-submit").html('<span>LOGAR</span>');
                        toastr.error('Usuário ou Senha Incorretos', 'Aviso', {
                            showMethod: 'slideDown',
                            progressBar: true,
                            timeOut: 3000,
                            onHidden: function () {
                                window.location.reload()
                            }
                        });

                    } else if ((response) === 'recaptcha') {
                        $("#login-submit").html('<span>LOGAR</span>');
                        toastr.warning("Marque a Caixa Recaptcha");
                    } else {
                        location.href = response;
                    }
                }
            });
        }
    });

});