$(function () {


    carrega_markers();

    //Evento dos tabs.
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {
        var target = $(e.target).attr("href"); // activated tab
        if (target == '#tab-markers') {

            //Chama a função carrega_markers
            carrega_markers();

        } else {

            //Chama a função carrega_logradouro
            carrega_logradouro();

        }
    });
    $('[data-toggle="tooltip"]').tooltip();


});


function carrega_markers() {


    //Não deixa que outra tabela estanciada sobescreva a tabela atual.
    $("#tabela_logradouro").dataTable().fnDestroy();

    $.ajax({
        type: "GET",
        url: './control/maps/carrega_markers.php',
        beforeSend() {

            $('#carrega-markers').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (data) {

            $('#carrega-markers').html(data);

            //TABELA MARKERS SERVER-SIDE
            const table_markers = $('#tabela-markers').DataTable({
                "processing": true,
                "serverSide": true,
                "ajax": "./control/maps/data.php",
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                "lengthMenu": [[25, 50, 100], [25, 50, 100]],
                "order": [[1, "desc"]],
                "columnDefs": [{
                    "defaultContent":
                        '<a class="text-light mr-2 table_markers_delete" href="javascript:;"><i class="ti-trash" ' +
                        'data-toggle="tooltip" data-placement="top" title="Excluir"></i></a>',
                    "data": null, "targets": [-1]
                },{
                    'targets': [0],
                    'searchable': false,
                    'orderable': false,
                    'checkboxes': {
                        'selectRow': true
                    }
                }],
                'select': {
                    'style' : 'multi'
                }
            });

            // PEGA O ID E ENVIA PARA A FUNCAO EDITAR

           $('#tabela-markers tbody').on('click', '.table_markers_delete', function () {


               let arrayEdit = [];

               const row_selected = table_markers.column(0).checkboxes.selected();

               $.each(row_selected, function (index, rowId) {

                   arrayEdit.push(rowId);
               });


               if(arrayEdit.length > 0){

                   delete_markers(arrayEdit);

               }else {

                   const row = $(this).closest('tr');

                   const data = table_markers.row(row).data()[0];

                   arrayEdit.push(data);

                   delete_markers(arrayEdit);

               }

           });

        }
    });
}


function carrega_logradouro() {

    //Não deixa que outra tabela estanciada sobescreva a tabela atual.
    $("#tabela-markers").dataTable().fnDestroy();

    $.ajax({
        type: "GET",
        url: './control/maps/carrega_logradouro.php',
        beforeSend() {

            $('#carrega-logradouro').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (data) {

            $('#carrega-logradouro').html(data);

            $('#tabela-logradouro').dataTable({
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "All"]],
                "order": [[0, "desc"]]
            });

            $('[data-toggle="tooltip"]').tooltip();
        }


    });
}

function formulario_novoLogradouro() {

    let modal = $('#modalb');


    modal.modal('show');

    modal.find('.modal-title').html('Inserir Logradouro');

    $.ajax({

        type: 'GET',
        url: './control/maps/carrega_logradouro.php?page=add',
        beforeSend() {

            $('.modal-result-lb').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (data) {

            $('.modal-result-lb').html(data);
            $('.modal-result-lb').find('form').on('submit', saveadd);

        }
    });

}

function saveadd(e) {

    e.preventDefault();
    let data = $(this).serialize();
    $.ajax({
        type: 'POST',
        url: './control/maps/carrega_logradouro.php?page=saveadd',
        data: data,
        success: function (result) {
            if (result) {
                toastr.success('Logradouro inserido com sucesso');

                $('#modalb').modal('hide');
                $('#modalb').removeData();

            } else {

                toastr.error('Erro ao inserir o logradouro');
            }
            carrega_logradouro();
        }
    });
}

function edit_address(id) {

    let modal = $('#modalb');
    modal.modal('show');
    modal.find('.modal-title').html('Editar Logradouro');

    $.ajax({

        type: 'POST',
        url: './control/maps/carrega_logradouro.php?page=edit',
        data: {id: id},
        beforeSend() {

            $('.modal-result-lb').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (result) {

            $('.modal-result-lb').html(result);
            $('.modal-result-lb').find('form').on('submit', saveedit);

        }
    });
}

function saveedit(e) {

    e.preventDefault();
    let data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './control/maps/carrega_logradouro.php?page=saveedit',
        data: data,
        success: function (result) {

            if (result == true) {

                toastr.success('Logradouro editado com sucesso');
            } else {

                toastr.error('Logradouro não editado');
            }
            $('#modalb').modal('hide');
            carrega_logradouro();
        }
    });
}

function delete_address(id) {

    let modal = $('#modalb');
    modal.modal('show');
    modal.find('.modal-title').html('Excluir Logradouro');

    $.ajax({

        type: 'POST',
        url: './control/maps/carrega_logradouro.php?page=delete',
        data: {id: id},
        beforeSend() {

            $('.modal-result-lb').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (result) {

            $('.modal-result-lb').html(result);
            $('.modal-result-lb').find('form').on('submit', savedelete);

        }
    });
}

function savedelete(e) {

    e.preventDefault();
    let data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './control/maps/carrega_logradouro.php?page=savedelete',
        data: data,
        success: function (result) {

            if (result == true) {

                toastr.success('Logradouro deletado com sucesso');
            } else {

                toastr.error('Erro, logradouro não deletado');
            }
            $('#modalb').modal('hide');
            carrega_logradouro();
        }
    });
}

//REFERENTES A MARKERS

function delete_markers(arrayMarkers) {

    const id = arrayMarkers.join(',');

    let modal = $('#modalb');
    modal.modal('show');
    modal.find('.modal-title').html('Excluir Cliente');

    $.ajax({

        type: 'POST',
        url: './control/maps/carrega_markers.php?page=delete',
        data: {id: id},
        beforeSend() {

            $('.modal-result-lb').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (result) {

            $('.modal-result-lb').html(result);
            $('.modal-result-lb').find('form').on('submit', savedelete_markers);

        }
    });
}

function savedelete_markers(e) {

    e.preventDefault();
    let data = $(this).serializeArray();

    data = data.map((val) => {
        if (val['name'] === "id"){
            return val['value'];
        }
    });

     data = data.filter((val) => Boolean(val));
     const newData = data.join(',');

    $.ajax({

        type: 'POST',
        url: './control/maps/carrega_markers.php?page=savedelete',
        data: {id : newData},
        success: function (result) {

            if (result == true) {

                toastr.success('Cliente deletado com sucesso');
            } else {

                toastr.error('Erro, cliente não deletado');
            }
            $('#modalb').modal('hide');
            carrega_markers();
        }
    });
}

//BOTÃO CARREGA MAPA

function carrega_mapa() {

    let modal = $('#modalb');
    modal.modal('show');
    modal.find('.modal-title').html('Carregando Mapa');

    $.ajax({
        type: "GET",
        url: "./control/maps/load_map.php",
        beforeSend: function () {
            $('.modal-result-lb').html('<div class="ibox-body">' +
                '<div class="card" style="height: 324px">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');
        },
        success: function (html) {
            $('.modal-result-lb').html(html);
            carrega_markers();
        }
    });


}
