function carregarMenus() {

    $.ajax({

        type: 'GET',
        url: 'control/manager_menu.php',
        success: function (response) {

            $('#carrega-menu').html(response);

            $.fn.dataTable.moment('DD-MM-YYYY');

            $('#tabela-menu').DataTable({
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                pageLength: 10,
                fixedHeader: true,
                responsive: true,
                "sDom": 'rtip',
                columnDefs: [{
                    targets: 'no-sort',
                    orderable: false
                }]
            });
            $('[data-toggle="tooltip"]').tooltip();

        }
    })
};

function editar_m(id) {

    $('#modal_Large').modal('show');


    $.ajax({

        type: 'POST',
        url: 'control/manager_menu.php?page=edit',
        data: {id: id},
        success: function (response) {

            $('#modal_Large').find('.modal-title').html('<span class="text-muted font-bold">Editar Menu</span>');
            $('.modal-large-result').html(response);
            $('.modal-large-result .selectpicker').selectpicker('show');
            $('.modal-large-result').find('form').on('submit', salvar_menu_edit);
        }

    });


};

function novoMenu() {

    $('#modalb').modal('show');

    $.ajax({

        type: 'GET',
        url: 'control/manager_menu.php?page=add',
        success: function (response) {

            $('#modalb').find('.modal-title').html('<label class="font-strong text-muted">Novo Menu</label>');
            $('.modal-result-lb').html(response);
            $('.modal-result-lb .selectpicker').selectpicker('show');
            $('.modal-result-lb').find('form').on('submit', salvar_menu);
        }

    });


};

function excluir_m(id, nome) {

    alertify.theme('bootstrap');
    alertify.confirm(`<h6>Deseja Excluir o Menu <span class="text-danger font-extra-bold">${nome}</span> ?</h6>`, function (ev) {
        ev.preventDefault();


        $.ajax({
            type: 'POST',
            url: 'control/manager_menu.php?page=delete',
            data: {id: id},
            success: function (response) {

                if (response == 0) {
                    toastr.success("Menu excluído");
                    carregarMenus();
                }
                if (response == 1)

                    toastr.error('caso o menu tenha Submenu, exclua-o primeiro.', 'Houve um problema na exclusão', {
                        timeOut: 0,
                        closeButton: true
                    });
            }

        });
    });
};

function salvar_menu(e) {

    e.preventDefault();
    let expression = /^(http:\/\/www\.|https:\/\/www\.|http:\/\/|https:\/\/)?[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/gi;
    let regex = new RegExp(expression);

    if ($('#nome-new-menu').val() === '') {

        toastr.error('Nome é Obrigatório');

        $('#nome-new-menu').focus();

        return false;
    }
    if ($('#icone-new-menu').val() === '') {

        toastr.error('Icone é Obrigatório');

        $('#icone-new-menu').focus();


        return false;

    }
    if ($('#config-new-menu').val() === '') {

        toastr.error('Config Menu é Obrigatório');

        $('#config-new-menu').focus();

        return false;

    } else if (!($('#url-new-menu').val().match(regex))) {

        toastr.error('Digite uma URL válida');
        $('#url-new-menu').focus();


    } else {

        const data = $(this).serialize();

        $.ajax({
            type: 'POST',
            url: 'control/manager_menu.php?page=save_menu',
            data: data,
            success: function (response) {

                if (response == 0) {

                    toastr.success('Cadastrado com Sucesso');
                }
                if (response == 1) {

                    toastr.error('Menu não cadastrado');

                }

                $('#modalb').modal('hide');
                carregarMenus();
            }
        });
    }
}


function salvar_menu_edit(ed) {

    ed.preventDefault();
    let expression = /^(http:\/\/www\.|https:\/\/www\.|http:\/\/|https:\/\/)?[a-z0-9]+([\-\.]{1}[a-z0-9]+)*\.[a-z]{2,5}(:[0-9]{1,5})?(\/.*)?$/gi;
    let regex = new RegExp(expression);


    if ($('#nome-menu').val() === '') {

        toastr.error('Nome é Obrigatório');

        $('#nome-menu').focus();
        return false;

    } else if ($('#icone-menu').val() === '') {

        toastr.error('Icone é Obrigatório');

        $('#icone-menu').focus();
        return false;

    } else if (!($('#url-menu').val().match(regex))) {

        toastr.error('Digite uma URL válida');
        $('#url-menu').focus();

    } else {

        const data = $(this).serialize();

        $.ajax({
            type: 'POST',
            url: 'control/manager_menu.php?page=save',
            data: data,
            success: function (response) {

                if (response == 0) {
                    toastr.success('Atualizado com Sucesso');

                    if (response == 1) {
                        toastr.warning('Houve um erro ao Atualizar');
                    }
                    $('#modal_Large').modal('hide');
                    carregarMenus();
                }
            }
        })
    }

}

function autocomplete_page_menu() {


    let input = document.getElementById("url-new-menu").value;
    document.getElementById("page-new-menu").value = input;
}

function autocomplete_page_editmenu() {


    let input = document.getElementById("url-menu").value;
    document.getElementById("page-menu").value = input;
}
function autocomplete_page_submenu(){


    let input = document.getElementById("url-sub").value;
    document.getElementById("page-sub").value = input;
}


