$(function () {

    escolherProjeto();
});

function escolherProjeto() {

    $('#modalb').modal('show');
    $('#modalb .modal-title').html('<h5>Selecione o Projeto</h5>');
    $.ajax({
        type: 'GET',
        url: './control/manager_projetos.php?page=loadprojetoform&ece=1',
        beforeSend() {

            $('#modal_lb .modal-result-lb').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('#modalb .modal-result-lb').html(response);
            $('.modal-result-lb .selectpicker').selectpicker('show');
            $('#modalb .modal-result-lb').find('form').on('submit', loadpage);
        }
    });

}

function loadpage(e) {

    e.preventDefault();

    let data;

    if ($('#selectproject').val() === '') {

        toastr.error('Escolha um Projeto');

        return false;

    } else {

        data = $('#selectproject').val();

    }

    $.ajax({

        type: 'POST',
        url: './templates/widget_projetosFibra.php',
        data: {projeto: data},
        beforeSend() {

            $('#modalb').modal('hide');
            $('#projetoFibra').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('#projetoFibra').html(response);
            loadFaturamento(data); // CARREGA FATURAMENTO DO MES CORRENTE
            loadtabpanel(data); // CARREGA FATURAMENTO DO MES ESCOLHIDO NAS TABS PANEL
            loadtabelaclientes(data);
            initMap(data); //INICIALIZA O MAPA
            $('.easypie').each(function(){
                $(this).easyPieChart({
                    trackColor: $(this).attr('data-trackColor') || '#f2f2f2',
                    scaleColor: false,
                });
            });

        }
    });

}

function initMap(data) {

    $.ajax({

        type: 'POST',
        url: './control/manager_projetos.php?page=getmarkers',
        dataType: 'JSON',
        data: {codprojeto: data},
        success: function (response) {

            var lat_projeto = $('#lat').val(), lng_projeto = $('#lng').val();
            var map = new google.maps.Map(document.getElementById('mapa'), {
                zoom: 14,
                center: new google.maps.LatLng(lat_projeto, lng_projeto)
            });

            var infoWin = new google.maps.InfoWindow();
            var markers = [];

            $.each(response, function (key, val) {

                var name = val.name;
                var latLng = new google.maps.LatLng(parseFloat(val.lat), parseFloat(val.lng));
                var infowincontent = document.createElement('div');
                var strong = document.createElement('strong');
                strong.textContent = name;
                infowincontent.appendChild(strong);
                infowincontent.appendChild(document.createElement('br'));

                var marker = new google.maps.Marker({
                    position: latLng,
                    animation: google.maps.Animation.DROP,
                    icon: 'images/maps/user_map.png'
                });
                marker.addListener('click', function () {
                    if(infoWin)infoWin.close();
                    infoWin.setContent(infowincontent);
                    infoWin.open(map, marker);
                });
                markers.push(marker);

            });

            // Add a marker clusterer to manage the markers.
            var markerCluster = new MarkerClusterer(map, markers,
                {imagePath: 'https://developers.google.com/maps/documentation/javascript/examples/markerclusterer/m'});


            var teste = markerCluster;

           console.log(teste);
        }
    });
}

//CARREGA TABELA DE CLIENTES
function loadtabelaclientes(codprojeto) {

    $.ajax({
        type: 'POST',
        url: './control/manager_projetos.php?page=loadtabelaclientes',
        data: {codprojeto: codprojeto},
        beforeSend() {

            $('#tabela_clientes').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('#tabela_clientes').html(response);
            var table = $('#datatable-clientesprojeto').DataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                "order": [[2, "asc"]],
                responsive: {
                    details: {
                        display: $.fn.dataTable.Responsive.display.modal({}),
                        renderer: $.fn.dataTable.Responsive.renderer.tableAll({
                            tableClass: 'table'
                        })
                    }
                },
            });
            $('[data-toggle="tooltip"]').tooltip();

            // toggle columns
            /* precisa terminar
            $(document).on("click keydown", "[data-selectable] > .selectable-item", function (o) {
                var a = this, n = $(a).parent().data("selectable") || "selected";
                "click" === o.type && (o.preventDefault(), o.stopPropagation()), 13 !== o.which && 32 !==
                o.which || $(a).trigger("click"), t(o, a)
            });

            $('.toggle-vis').on('click', function (e) {
                e.preventDefault();
                // Get the column API object
                var column = table.column($(this).attr('data-column'));
                // Toggle the visibility
                column.visible(!column.visible())
            });

             */

        }
    });

}

//FUNCAO CARREGAR FATURAMENTO MES CORRENTE E CHARTS DOS CARTOES
function loadFaturamento(codprojeto) {


    //DEFINE AS DATAS
    moment.locale('pt-br');

    var target = '#tab-1-3', start = moment().startOf('month'), // primeiro dia deste mes
        now = moment(), // hoje,
        end = moment().subtract(1, "days"), // ontem
        start_last1 = moment().subtract(1, "month").startOf("month"), // primeiro dia do mes passado
        end_last1 = moment().subtract(1, "month").endOf("month"), // ultimo dia do mes passado
        start_last2 = moment().subtract(2, "month").startOf("month"), // primeiro  dia do mes retrasado
        end_last2 = moment().subtract(2, "month").endOf("month"); // ultimo dia do mes retrasado


    //CARREGA TABELA EXTRATO COM O MES CORRENTE
    loadprojeto_fat(start.format('DD-MM-YYYY'), now.format('DD-MM-YYYY'), target, codprojeto);

    //CARREGA OS CHARTS DOS CARTOES DE PREVISAO
    loadchart(start_last2.format('DD-MM-YYYY'), end_last2.format('DD-MM-YYYY'), 'chart_a', codprojeto);
    loadchart(start_last1.format('DD-MM-YYYY'), end_last1.format('DD-MM-YYYY'), 'chart_b', codprojeto);
    loadchart(start.format('DD-MM-YYYY'), end.format('DD-MM-YYYY'), 'chart_c', codprojeto);

    //CARREGA CHART EVOLUCAO CARTEIRA DE CLIENTES
    chart_clientesCarteira(codprojeto);
    loadchartAnual(codprojeto);


}


// FUNCAO PARA CARREGAR A TABELA DE EXTRATO
function loadprojeto_fat(dt_i, dt_f, target, codprojeto) {
    target = target.substring(1);
    //CARREGA TABELA DE FATURAMENTO
    $.ajax({
        type: 'POST',
        url: './control/manager_projetos.php?page=loadfaturamentoProjeto',
        data: {data_i: dt_i, data_f: dt_f, id: target, codprojeto: codprojeto},
        beforeSend() {

            $('.' + target + '').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('.' + target + '').html(response);
            $('#datatable-' + target + '').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
            $('[data-toggle="tooltip"]').tooltip();

        }
    });

}

//FUNCAO DAS TAB PANEL
function loadtabpanel(codprojeto) {

    //DEFINE AS DATAS
    var start = moment().startOf('month'), // primeiro dia deste mes
        end = moment().subtract(1, "days"), // ontem
        now = moment(), // hoje
        start_last1 = moment().subtract(1, "month").startOf("month"), // primeiro dia do mes passado
        end_last1 = moment().subtract(1, "month").endOf("month"), // ultimo dia do mes passado
        start_last2 = moment().subtract(2, "month").startOf("month"), // primeiro  dia do mes retrasado
        end_last2 = moment().subtract(2, "month").endOf("month"); // ultimo dia do mes retrasado


    //CARREGA TABELA EXTRATO DE ACORDO COM O MES ESCOLHIDO NAS TABS
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {

        var target = $(e.target).attr("href");

        if (target == '#tab-1-3') {

            loadprojeto_fat(start.format('DD-MM-YYYY'), now.format('DD-MM-YYYY'), target, codprojeto);

        } else if (target == '#tab-1-2') {

            loadprojeto_fat(start_last1.format('DD-MM-YYYY'), end_last1.format('DD-MM-YYYY'), target, codprojeto);
        } else {

            loadprojeto_fat(start_last2.format('DD-MM-YYYY'), end_last2.format('DD-MM-YYYY'), target, codprojeto);
        }
    });

    //remove o active da classe tab-panel devido a um BUG do bootstrap
    $('#myTab-fatprojeto a').on('click', function () {

        $('.tab-pane').removeClass('active')

    });

}

// FUNCAO PARA CARREGAR A MODAL DA TABELA DE EXTRATO
function modal_fat(day, tipo, projeto) {


    $("#modal_Large").modal('show');
    $("#modal_Large .modal-title").html('<h5>Clientes - <small>' + tipo + '</small></h5>');
    $.ajax({
        type: 'POST',
        url: './control/manager_projetos.php?page=loadfaturamento_modal',
        data: {data_i: day, data_f: day, id: tipo, codprojeto: projeto},
        beforeSend() {

            $('#modal_Large .modal-large-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $("#modal_Large .modal-large-result").html(response);
            $('#datatable-modal-' + tipo + '').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
        }
    });

}

//FUNCAO PARA CARREGAR OS CHARTS
function loadchart(data_i, data_f, id, projeto) {

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: './control/manager_projetos.php?page=loadchartProjetos',
        data: {data_i: data_i, data_f: data_f, id: id, codprojeto: projeto},
        beforeSend() {
            $('#' + id + '').html('<div class="ibox-body">' +
                '<div class="card">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            const data = [], valor = [];

            $.each(response, function (key, val) {

                data.push(val.data);
                valor.push(val.valor)
            });

            // Chart a

            var chartdata = {
                labels: data,
                datasets: [
                    {
                        label: "Dia",
                        backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                        borderColor: "#fff",
                        hoverBackgroundColor: '#fff',
                        data: valor
                    }
                ]
            };
            var chartOptions = {
                tooltips: {
                    callbacks: {
                        title: function (tooltipItem) {

                            return 'Dia: ' + data[tooltipItem[0].index];

                        },
                        label: function (tooltipItem) {

                            return 'R$ ' + formatMoney(tooltipItem.yLabel);

                        }
                    }

                },
                responsive: true,
                maintainAspectRatio: false,
                showScale: false,
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                        ticks: {
                            fontColor: '#fff'
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                            drawTicks: false,
                            tickMarkLength: 0
                        },
                        ticks: {
                            display: false,
                            padding: 0,
                            fontColor: '#eee'
                        },
                    }]
                },
                legend: {display: false}
            };
            var ctx = document.getElementById(id).getContext("2d");
            new Chart(ctx, {type: 'bar', data: chartdata, options: chartOptions});
        }
    });
}

//FUNÇÃO PARA FORMATAR VALORES COM AS CASA DECIMAIS CORRETAS
function formatMoney(n, c, d, t) {
    c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
    return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
}//FUNÇÃO PARA FORMATAR VALORES COM AS CASA DECIMAIS CORRETAS

//FUNCAO PARA FORMATAR VALORES SEM CASA DECIMAL
function formatMoney2(n, c, d, t) {
    c = isNaN(c = Math.abs(c)) ? 0 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
    return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
}

//CHART EVOLUCAO CARTEIRA DE CLIENTES
function chart_clientesCarteira(projeto) {

    $.post("./control/manager_projetos.php?page=evolucaocarteira", {codprojeto: projeto}, function (data) {

        Morris.Area({
            element: 'chart_projeto',
            data: data,
            xkey: 'mes',
            ykeys: ['total'],
            parseTime: false,
            labels: ['total'],
            hoverCallback: function (d, e, content, dd) {
                return '<span class="font-bold">' + dd.mes + '</span>' + '<br/>' +
                    'Total: ' + formatMoney2(dd.total)
            },
            pointSize: 3,
            hideHover: 'auto',
            resize: true,
            pointFillColors: ['#fff'],
            pointStrokeColors: ['#006e78'],
            lineColors: ['#0eaaa0'],
            lineWidth: 2,
        });
    }, 'json');

}

function loadchartAnual(projeto) {


    $.post("./control/manager_projetos.php?page=loadfaturamentoAnual", {codprojeto: projeto}, function (data) {

        const meses = [];
        const meses2 = [];
        const valor = [];

        $.each(data, function (key, val) {

            meses.push(val.mes.substring(0, 1));
            meses2.push(val.mes);
            valor.push(val.valor);
        });

        var chartdata_c = {
            labels: meses,
            datasets: [
                {
                    label: "Total",
                    backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                    borderColor: "#fff",
                    hoverBackgroundColor: '#fff',
                    data: valor
                }
            ]
        };
        var chartOptions_c = {
            tooltips: {
                callbacks: {
                    title: function (tooltipItem) {

                        return 'Mês: ' + meses2[tooltipItem[0].index];

                    },
                    label: function (tooltipItem) {

                        return 'R$ ' + formatMoney(tooltipItem.yLabel);

                    }
                }

            },
            responsive: true,
            maintainAspectRatio: false,
            showScale: false,
            scales: {
                xAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                    },
                    ticks: {
                        fontColor: '#fff'
                    }
                }],
                yAxes: [{
                    gridLines: {
                        display: false,
                        drawBorder: false,
                        drawTicks: false,
                        tickMarkLength: 0
                    },
                    ticks: {
                        display: false,
                        padding: 0,
                        fontColor: '#eee'
                    },
                }]
            },
            legend: {display: false}
        };
        var ctx = document.getElementById("chart_faturamentoanual").getContext("2d");
        new Chart(ctx, {type: 'bar', data: chartdata_c, options: chartOptions_c});

    }, 'json');
}
