$(function () {


    //DEFINE AS DATAS
    moment.locale('pt-br');

    let target = '#tab-1-3';
    const start = moment().startOf('month'), // primeiro dia deste mes
        end = moment().subtract(1, "days"), // ontem
        now = moment(), // hoje
        start_last1 = moment().subtract(1, "month").startOf("month"), // primeiro dia do mes passado
        end_last1 = moment().subtract(1, "month").endOf("month"), // ultimo dia do mes passado
        start_last2 = moment().subtract(2, "month").startOf("month"), // primeiro  dia do mes retrasado
        end_last2 = moment().subtract(2, "month").endOf("month"); // ultimo dia do mes retrasado


    //CARREGA TABELA EXTRATO COM O MES CORRENTE
    loadresidencial_fat(start.format('DD-MM-YYYY'), now.format('DD-MM-YYYY'), target);


    //CARREGA TABELA EXTRATO DE ACORDO COM O MES ESCOLHIDO NAS TABS
    $('a[data-toggle="tab"]').on('shown.bs.tab', function (e) {


        var target = $(e.target).attr("href"); // activated tab

        if (target === '#tab-1-3') {


            loadresidencial_fat(start.format('DD-MM-YYYY'), now.format('DD-MM-YYYY'), target);

        } else if (target === '#tab-1-2') {

            loadresidencial_fat(start_last1.format('DD-MM-YYYY'), end_last1.format('DD-MM-YYYY'), target);
        } else {

            loadresidencial_fat(start_last2.format('DD-MM-YYYY'), end_last2.format('DD-MM-YYYY'), target);
        }
    });

    loadWidgetResidencial();
    loadCartoesFaturamento({
        dt_ini: start.format('DD-MM-YYYY'), dt_end: end.format('DD-MM-YYYY'), id: 'chart_c',
        dt_ini_1: start_last1.format('DD-MM-YYYY'), dt_end_1: end_last1.format('DD-MM-YYYY'), id_1: 'chart_b',
        dt_ini_2: start_last2.format('DD-MM-YYYY'), dt_end_2: end_last2.format('DD-MM-YYYY'), id_2: 'chart_a'
    });

    function cb(start, end) {
        $('#reportrange span').html(start.format('DD/MM/YYYY') + ' - ' + end.format('DD/MM/YYYY'));
        load_resumoVendas(start.format('YYYY-MM-DD'), end.format('YYYY-MM-DD'));
    }

    $('#reportrange').daterangepicker({
        startDate: start,
        endDate: end,
        minDate: "01/08/2018",
        maxDate: "31/12/2020",
        showDropdowns: !0,
        timePicker12Hour: !0,
        ranges: {
            'Hoje': [moment(), moment()],
            'Ontem': [moment().subtract(1, 'days'), moment().subtract(1, 'days')],
            'Últimos 7 Dias': [moment().subtract(6, 'days'), moment()],
            'Últimos 30 Dias': [moment().subtract(29, 'days'), moment()],
            'Este Mês': [moment().startOf('month'), moment().endOf('month')],
            'Mês Passado': [moment().subtract(1, 'month').startOf('month'), moment().subtract(1, 'month').endOf('month')]
        },
        buttonClasses: ["btn btn-default"],
        applyClass: "btn-small btn-redenilf",
        cancelClass: "btn-small",
        format: "DD/MM/YYYY",
        separator: " to ",
        locale: {
            applyLabel: "Aplicar",
            cancelLabel: "Limpar",
            fromLabel: "From",
            toLabel: "To",
            customRangeLabel: "Personalizado",
            daysOfWeek: ["Dom", "Seg", "Ter", "Qua", "Qui", "Sex", "Sab"],
            monthNames: ["Janeiro", "Fevereiro", "Março", "Abril", "Maio", "Junho", "Julho", "Agosto", "Setembro", "Outubro", "Novembro", "Dezembro"],
            firstDay: 1
        }
    }, cb);
    cb(start, end);
});


const loadWidgetResidencial = () => {

    $.ajax({
        type: 'GET',
        url: './control/residencial/manager_widget_residencial.php',
        beforeSend() {
            $('#loadWigetResidencial').html('<div class="row">' +
                '<div class="col-lg-12">' +
                '<div class="ibox">' +
                '<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>');
        },
        success: (response) => {

            $('#loadWigetResidencial').html(response)
        },
        complete: function () {
           chart_clientesCarteira();
        }
    });

};

const loadCartoesFaturamento = (data) => {

    $.ajax({
        type: 'GET',
        url: './control/residencial/manager_faturamento_residencial.php',
        beforeSend() {
            $('#loadCardsFaturamento').html('<div class="row">' +
                '<div class="col-lg-12">' +
                '<div class="ibox">' +
                '<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>' +
                '</div>' +
                '</div>' +
                '</div>');
        },
        success: (response) => {

            $('#loadCardsFaturamento').html(response)
        },
        complete: function () {
             loadchart(data.dt_ini, data.dt_end, data.id);
             loadchart(data.dt_ini_1, data.dt_end_1, data.id_1);
             loadchart(data.dt_ini_2, data.dt_end_2, data.id_2);
        }

    });


};

// FUNCAO PARA CARREGAR A TABELA DE EXTRATO
function loadresidencial_fat(dt_i, dt_f, target) {
    target = target.substring(1);
    //CARREGA TABELA DE FATURAMENTO
    $.ajax({
        type: 'POST',
        url: './control/residencial/manager_faturamento_residencial.php?page=loadfaturamento',
        data: {data_i: dt_i, data_f: dt_f, id: target},
        beforeSend() {

            $('.' + target + '').html('<div class="ibox-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $('.' + target + '').html(response);
            $('#datatable-' + target + '').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
            $('[data-toggle="tooltip"]').tooltip();
        }
    });

}

//remove o active da classe tab-panel devido a um BUG do bootstrap
$('#myTab-fatresidencial a').on('click', function () {

    $('.tab-pane').removeClass('active')

});

// FUNCAO PARA CARREGAR A MODAL DA TABELA DE EXTRATO
function modal_fat(day, tipo) {


    $("#modal_Large").modal('show');
    $("#modal_Large .modal-title").html('<h5>Clientes - <small>' + tipo + '</small></h5>');
    $.ajax({
        type: 'POST',
        url: './control/residencial/manager_faturamento_residencial.php?page=loadfaturamento_modal',
        data: {data_i: day, data_f: day, id: tipo},
        beforeSend() {

            $('#modal_Large .modal-large-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $("#modal_Large .modal-large-result").html(response);
            $('#datatable-modal-' + tipo + '').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
        }
    });

}

// FUNCAO PARA CARREGAR OS CHARTS
function loadchart(data_i, data_f, id) {

    $.ajax({
        type: 'POST',
        dataType: 'JSON',
        url: './control/residencial/manager_faturamento_residencial.php?page=loadchart',
        data: {data_i: data_i, data_f: data_f, id: id},
        beforeSend() {
            $('#' + id + '').html('<div class="ibox-body">' +
                '<div class="card">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader" style="margin: 30px auto">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            const data = [], valor = [];

            $.each(response, function (key, val) {

                data.push(val.data);
                valor.push(val.valor)
            });

            // Chart a

            var chartdata = {
                labels: data,
                datasets: [
                    {
                        label: "Dia",
                        backgroundColor: 'rgba(255,255,255,.85)', //'#18C5A9'
                        borderColor: "#fff",
                        hoverBackgroundColor: '#fff',
                        data: valor
                    }
                ]
            };
            var chartOptions = {
                tooltips: {
                    callbacks: {
                        title: function (tooltipItem) {

                            return 'Dia: ' + data[tooltipItem[0].index];

                        },
                        label: function (tooltipItem) {

                            return 'R$ ' + formatMoney(tooltipItem.yLabel);

                        }
                    }

                },
                responsive: true,
                maintainAspectRatio: false,
                showScale: false,
                scales: {
                    xAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                        },
                        ticks: {
                            fontColor: '#fff'
                        }
                    }],
                    yAxes: [{
                        gridLines: {
                            display: false,
                            drawBorder: false,
                            drawTicks: false,
                            tickMarkLength: 0
                        },
                        ticks: {
                            display: false,
                            padding: 0,
                            fontColor: '#eee'
                        },
                    }]
                },
                legend: {display: false}
            };
            var ctx = document.getElementById(id).getContext("2d");
            new Chart(ctx, {type: 'bar', data: chartdata, options: chartOptions});
        }
    });
}

//FUNÇÃO PARA FORMATAR VALORES COM AS CASA DECIMAIS CORRETAS
function formatMoney(n, c, d, t) {
    c = isNaN(c = Math.abs(c)) ? 2 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
    return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
}//FUNÇÃO PARA FORMATAR VALORES COM AS CASA DECIMAIS CORRETAS

//FUNCAO PARA FORMATAR VALORES SEM CASA DECIMAL
function formatMoney2(n, c, d, t) {
    c = isNaN(c = Math.abs(c)) ? 0 : c, d = d == undefined ? "," : d, t = t == undefined ? "." : t, s = n < 0 ? "-" : "", i = parseInt(n = Math.abs(+n || 0).toFixed(c)) + "", j = (j = i.length) > 3 ? j % 3 : 0;
    return s + (j ? i.substr(0, j) + t : "") + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + t) + (c ? d + Math.abs(n - i).toFixed(c).slice(2) : "");
}

function clientesNovos(tipo, data_i, data_f) {

    $("#modal_extraLarge").modal('show');
    $("#modal_extraLarge .modal-title").html('<h5>Clientes Residencial</h5>');

    $.ajax({
        type: 'POST',
        url: './control/residencial/manager_widget_residencial.php?page=loadclientesnovos',
        data: {tipo: tipo, data_i: data_i, data_f: data_f},
        beforeSend() {

            $('#modal_extraLarge .modal-extralarge-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $("#modal_extraLarge .modal-extralarge-result").html(response);
            $('#datatable-modalclientesnovos').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
        }
    });
}

function vendasDia(grupo, segmento) {

    $("#modal_Large").modal('show');
    $("#modal_Large .modal-title").html('<h5>Vendidos Residencial</h5>');

    $.ajax({
        type: 'POST',
        url: './control/residencial/manager_widget_residencial.php?page=loadclientesvendasdia',
        data: {grupo: grupo, segmento: segmento},
        beforeSend() {

            $('#modal_Large .modal-large-result').html('<div class="modal-body">' +
                '<div class="card mb-4">\n' +
                '    <div class="card-body text-center">\n' +
                '        <div class="d-flex align-items-center justify-content-center">\n' +
                '            <div class="loader">\n' +
                '                <h6 class="text-muted font-strong mb-5">Carregando...</h6>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '                <div class="loader-inner"></div>\n' +
                '            </div>\n' +
                '        </div>\n' +
                '    </div>\n' +
                '  </div>\n' +
                '</div>');

        },
        success: function (response) {

            $("#modal_Large .modal-large-result").html(response);
            $('#datatable-modalvendidodia').dataTable({
                "destroy": true,
                "language": {
                    "url": "js/json/pt_BR.json"
                },
            });
        }
    });
}

function chart_clientesCarteira() {

    $.getJSON("./control/residencial/manager_widget_residencial.php?page=loadanual_carteira", function (data) {

        Morris.Area({
            element: 'chart_clientesCarteira',
            data: data,
            xkey: 'mes',
            ykeys: ['total'],
            parseTime: false,
            labels: ['total'],
            hoverCallback: function (d, e, content, dd) {
                return '<span class="font-bold">' + dd.mes + '</span>' + '<br/>' +
                    'Total: ' + formatMoney2(dd.total)
            },
            pointSize: 3,
            hideHover: 'auto',
            resize: true,
            pointFillColors: ['#fff'],
            pointStrokeColors: ['#006e78'],
            lineColors: ['#0eaaa0'],
            lineWidth: 2,
        });
    });

}

function load_resumoVendas(a, b) {


    $.ajax({

        type: 'POST',
        url: './control/residencial/manager_widget_residencial.php?page=formresumo',
        data: {inicio: a, fim: b},
        beforeSend() {

            $('#resumo-vendas').html('<div class="sidenav-backdrop backdrop"></div>\n' +
                '<div class="preloader-backdrop">\n' +
                '    <div class="page-preloader">Carregando</div>\n' +
                '</div>')

        },
        success: function (response) {

            $('#resumo-vendas').html(response);
            $('#datatable').DataTable({
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                pageLength: 50,
                fixedHeader: true,
                responsive: true,
                "sDom": 'rtip',
                buttons: [
                    {
                        extend: 'collection',
                        text: 'Export',
                        buttons: [
                            'copy',
                            'excel',
                            'print',
                            'csv'

                        ]
                    },
                ],
                columnDefs: [{
                    orderable: false
                }]
            });
            $('[data-toggle="tooltip"]').tooltip();

            var table = $('#datatable').DataTable();
            $('#key-search').on('keyup', function () {
                table.search(this.value).draw();
            });
            $('#type-filter').on('change', function () {
                table.search($(this).val()).draw();
            });

        }

    });
}

function exporttable(value) {

    var table = $('#datatable').DataTable();

    table.buttons(value).trigger();

}


