var nome_global;

function carregarSubmenus() {

    $.ajax({

        type: 'GET',
        url: 'control/manager_sub.php',
        success: function (response) {

            $('#carrega-submenus').html(response);

            $.fn.dataTable.moment('DD-MM-YYYY');

            $('#tabela-submenu').DataTable({
                "language": {
                    "url": "js/json/pt_BR.json"
                },
                pageLength: 10,
                fixedHeader: true,
                responsive: true,
                "sDom": 'rtip',
                columnDefs: [{
                    targets: 'no-sort',
                    orderable: false
                }]
            });
            $('[data-toggle="tooltip"]').tooltip();

        }
    });
}

function formulario_novoSubmenu() {

    $('#modalb').modal('show');
    $('#modalb').find('.modal-title').html('<span class="text-muted font-bold">Novo Submenu</span>');

    $.ajax({

        type: 'POST',
        url: 'control/manager_sub.php?page=formulario_novosub',
        success: function (response) {

            $('.modal-result-lb').html(response);
            $('.modal-result-lb .selectpicker').selectpicker('show');
            $('.modal-result-lb').find('form').on('submit', addSub);
        }

    })


}

function addSub(e) {

    e.preventDefault();

    if ($('#nome-sub').val() === '') {

        toastr.error('Digite um nome para o novo submenu');

        return false;

    } else if ($('#menu-sub').val() === '') {

        toastr.error('É preciso um Menu para o Submenu');

        return false;

    } else if ($('#url-sub').val() === '') {

        toastr.error('É preciso uma URL para o Submenu');

        return false;

    } else if ($('#page-sub').val() === '') {

        toastr.error('É preciso especificar a Página do Submenu');

        return false;

    } else {

        const data = $(this).serialize();

        $.ajax({
            type: 'POST',
            url: 'control/manager_sub.php?page=addsub',
            data: data,
            success: function (data) {

                if (data == 0) {

                    toastr.success("Adcionado com Sucesso");


                } else if (data == 2) {

                    toastr.error("Este submenu já existe");

                } else {

                    toastr.error("Não foi possivel inserir");
                }
                $('#modalb').modal('hide');
                $('#modalb').removeData();
                carregarSubmenus();

            }

        });
    }

}

function formulario_editarSubmenu(id) {

    $('#modal_Large').modal('show');
    $('#modal_Large .modal-title').html(`<small class="text-muted">Editar Submenu <span class="font-strong"></span></small>`);

    $.ajax({

        type: 'POST',
        url: 'control/manager_sub.php?page=formulario_sub',
        data: {id_sub: id},
        success: function (response) {

            $('#modal_Large').find('.modal-title').html('<small class="text-muted">Editar Submenu</small>');
            $('#modal_Large .modal-large-result').html(response);
            $('#modal_Large .modal-large-result .selectpicker').selectpicker('show');
            $('#modal_Large .modal-large-result').find('form').on('submit', editarsub);
        }

    })

}

function editarsub(e) {

    e.preventDefault();

    if ($('#nome-sub').val() === '') {

        toastr.error('Digite um nome para o novo submenu');

        return false;

    } else if ($('#nome-submenu').val() === '') {

        toastr.error('Nome é Obrigatório');

        $('#nome-submenu').focus();

        return false;

    } else if ($('#url-submenu').val() === '') {

        toastr.error('É preciso uma URL para o Submenu');

        $('#url-submenu').focus();

        return false;

    } else if ($('#page-submenu').val() === '') {

        toastr.error('É preciso especificar a Página do Submenu');

        $('#page-submenu').focus();

        return false;

    } else {

        const data = $(this).serialize();

        $.ajax({
            type: 'POST',
            url: 'control/manager_sub.php?page=editsub',
            data: data,
            success: function (response) {

                if (response == 0) {
                    toastr.success('Atualizado com Sucesso');
                    $('#modal_Large').modal('hide');
                    $('#modal_Large').removeData();

                }
                if (response == 1) {
                    toastr.warning('Não Atualizado');
                }
                carregarSubmenus();

            }
        })

    }

}

function remover_sub(id, nome) {

    alertify.theme('bootstrap');
    alertify.confirm(`<h6>Deseja Excluir o SubMenu <span class="text-danger font-extra-bold">${nome}</span> ?</h6>`,
        function (ev) {
            ev.preventDefault();


            $.ajax({
                type: 'POST',
                url: 'control/manager_sub.php?page=delete_sub',
                data: {id: id},
                success: function (response) {

                    if (response == 1) {
                        toastr.success("SubMenu Excluído");
                        carregarSubmenus();

                    } else {

                        toastr.error('Erro', 'Houve um problema na exclusão', {
                            timeOut: 0,
                            closeButton: true
                        });
                    }
                }

            });
        });
}



