<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 23/11/2018
 * Time: 09:12
 */
require_once "./classes/Dashboard_Cac.php";
require_once "./funcoes/funcoes.php";
$valores = new Dashboard_Cac();
$valores->carregaVendas();
?>
<div class="page-content fade-in-up">
    <div class="row mb-4">
        <?php
        $valores->LoadOperador();
        foreach ($valores->getValores() as $row):

            ?>
            <div class="col-md-6 col-lg-3">
                <div class="card overflow-visible mt-5">
                    <div class="card-body text-center mt-4">
                        <img class="img-circle img-bordered card-abs-top-center"
                             src="./images/users/profile/<?php echo utf8_encode($row); ?>.jpg" alt="image" width="60" height="60"/>
                        <h6 class="mb-1">
                            <a><?php echo utf8_encode($row) ?></a>
                        </h6>
                        <small class="text-muted">CAC - Vendas</small>
                        <div class="d-flex align-items-center justify-content-between mb-2 mt-4">
                            <div class="text-center text-uppercase">
                                <h3 class="text-redenilfcolor m-0"><?php
                                    $valores->LoadMesPassado($row);
                                    echo $valores->getValores();
                                    ?></h3>
                                <div class="text-muted"><?php
                                    echo exibe_mes(date('m', strtotime('-1 month')));
                                    ?></div>
                            </div>
                            <div class="text-center text-uppercase">
                                <h3 class="text-redenilfcolor m-0"><?php
                                    $valores->LoadMesAtual($row);
                                    echo $valores->getValores();
                                    ?></h3>
                                <div class="text-muted"><?php
                                    echo exibe_mes(date('m'));
                                    ?></div>
                            </div>
                            <div class="text-center text-uppercase">
                                <h3 class="text-redenilfcolor m-0"> <?php
                                    $valores->LoadComissao();
                                    echo $valores->getTotal();
                                    ?></h3>
                                <div class="text-muted">Comissão</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        <?php
        endforeach;
        ?>
    </div>
    <div class="row">
        <div class="col-md-12">
            <div class="ibox">
                <div class="ibox-head flex-row-reverse">
                    <div class="ibox-title"></div>
                    <ul class="nav nav-tabs tabs-line tabs-line-2x" id="myTab-cac" role="tablist">
                        <li>
                            <a class="nav-link active font-strong" href="#tab-cac1" data-toggle="tab"><i
                                        class="ti-layout-menu-v mr-2"></i>Fluxo Novo</a>
                        </li>
                    </ul>
                </div>
                <div class="ibox-body">
                    <div class="tab-content">
                        <div class="tab-pane fade show active" id="tab-cac1">
                            <div class="row">
                                <div class="col-md-3 text-left">
                                    <button class="btn btn-info btn-fix btn-air" onclick="loadNewFluxo()">
                                        <span class="btn-icon"><i class="ti-reload"></i>Atualizar</span>
                                    </button>
                                </div>
                                <div class="col-md-6 text-right">
                                    <button class="btn btn-danger-50 btn-icon-only btn-sm btn-air"
                                            data-toggle="tooltip"
                                            title="Inconsistencias"
                                            onclick="searchFluxoNew('FALTA')">
                                        <i class="ti-close"></i></button>
                                    <button class="btn btn-warning-50 btn-icon-only btn-sm btn-air"
                                            data-toggle="tooltip"
                                            title="Aguardando"
                                            onclick="searchFluxoNew('AGUARDANDO')">
                                        <i class="ti-ticket"></i></button>
                                    <button class="btn btn-sucesso-50 btn-icon-only btn-sm btn-air"
                                            data-toggle="tooltip"
                                            title="Concluídos"><i class="ti-check-box"
                                                                  onclick="searchFluxoNew('CONCLUIDO')"></i>
                                    </button>
                                </div>
                                <div class="col-md-3">
                                    <div class="ibox-tools">
                                        <div class="input-group-icon input-group-icon-left mr-3">
                                        <span class="input-icon input-icon-right font-16"><i
                                                    class="ti-search"></i></span>
                                            <input class="form-control form-control-rounded form-control-solid"
                                                   id="key-search2"
                                                   type="text"
                                                   placeholder="Procurar ...">
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="mt-3" id="load_cacvendas2"></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
