<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 04/12/2018
 * Time: 11:47
 */

require_once "./classes/Cancelamento.php";
require_once "./classes/Dashboard_Adm.php";
require_once "./funcoes/funcoes.php";

$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));
$dt_i2 = date('d-m-Y', mktime(0, 0, 0, date('m') - 1,
    1, date('Y')));
$dt_f2 = date('d-m-Y', mktime(0, 0, 0, date('m'),
    date('d') - date('j'), date('Y')));
$dt_i3 = date('d-m-Y', mktime(0, 0, 0, date('m') - 2,
    1, date('Y')));
$dt_f3 = date('d-m-Y', mktime(23, 59, 59, date('m') - 1,
    date('d') - date('j'), date('Y')));

// INSTANCIA A CLASSE DE CANCELAMENTO
$cancelamento = new Cancelamento();


//CARREGA CANCELAMENTOS DO MES PASSADO
$cancelamento->carragar_Cancelamento($dt_i2, $dt_f2);
$mes_passado = count($cancelamento->getResult());

//CARREGA CANCELAMENTOS DO MES RETRASADO
$cancelamento->carragar_Cancelamento($dt_i3, $dt_f3);
$mes_retrasado = count($cancelamento->getResult());


// CARREGA CANCELAMENTOS DO MES
$cancelamento->carragar_Cancelamento($dt_i, $dt_f);
$cancelamento->canceladosMes_Atraso();


// carrega cancelados POR EMPRESA
$cancelamento->acumulado_cancelamento_diario_empresa(9, 'Cross');
// pega um array de cancelados por tipo e transforma em uma string
$cancelados_c = implode(',', $cancelamento->getCanceladosEmpresa());
$cancelamento->acumulado_cancelamento_diario_empresa(9, 'Redenilf');
$cancelados_r = implode(',', $cancelamento->getCanceladosEmpresa());
$cancelamento->acumulado_cancelamento_diario_empresa(9, 'Technet');
$cancelados_t = implode(',', $cancelamento->getCanceladosEmpresa());

// INSTANCIA A CLASSE DASHBOARD
$indicadores = new Dashboard_Adm();

//DADOS PARA O GRAFICO INSTALACAO X CANCELAMENTO

// CARREGA AS O.S
$indicadores->carregarOS($dt_i, $dt_f);

// CARREGA O.S. INSTALADAS POR EMPRESA
$indicadores->acumulado_instalacao_diario_empresa(9, 'Cross');
// pega um array de cancelados por tipo e transforma em uma string
$instalados_c = implode(',', $indicadores->getAcumuladoEmpresa());
$indicadores->acumulado_instalacao_diario_empresa(9, 'Redenilf');
$instalados_r = implode(',', $indicadores->getAcumuladoEmpresa());
$indicadores->acumulado_instalacao_diario_empresa(9, 'Technet');
$instalados_t = implode(',', $indicadores->getAcumuladoEmpresa());
$semana = implode('","', $indicadores->getSemana());

//FIM DADOS PARA O GRAFICO INSTALACAO X CANCELAMENTO


?>
<div class="page-content fade-in-up">
    <!-- CANCELAMENTOS MES PASSADO /ACUMULADO -->

    <div class="row mb-4">
        <!-- CANCELAMENTOS ESTE MES -->
        <div class="col-lg-8 col-md-6">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">Cancelamentos <span class="text-redenilfcolor"><?php
                            echo exibe_mes(date('m')); ?></span></div>
                </div>
                <div class="ibox-body pb-5">
                    <div class="flexbox">
                        <span class="flexbox mr-3">
                            <span class=" h2 mb-1"><?php
                                echo count($cancelamento->getResult()); ?></span>
                        </span>
                        <span class="flexbox">
                            <div class="d-flex justify-content-end">
                                <span class="h3 mr-3"><i class="ti-rss-alt text-primary mr-2" data-toggle="tooltip"
                                                         title="Rádio"></i>
                                            <span><?php $cancelamento->somatecnologia('Rádio');
                                                echo $cancelamento->getTotal(); ?>
                                            </span>
                                 </span>
                                <span class="h3"><i class="ti-link text-success mr-2" data-toggle="tooltip"
                                                    title="Fibra"></i>
                                            <span><?php $cancelamento->somatecnologia('Fibra');
                                                echo $cancelamento->getTotal(); ?>
                                            </span>
                                </span>
                            </div>
                        </span>
                    </div>
                    <div class="text-muted text-uppercase"><?php
                        echo exibe_mes(date('m'));
                        ?>
                        <i class="ti-user widget-stat-icon text-danger"></i>
                        <?php if (round(count($cancelamento->getResult()) /
                                $mes_passado * 100 - 100) < 0): ?>
                            <span class="text-success font-13" data-toggle="tooltip"
                                  title="Menos cancelamento do que o mes Passado">
                                <i class="ml-2 fa fa-level-down"></i> <?php
                                echo round(count($cancelamento->getResult()) /
                                    $mes_passado * 100 - 100); ?> %</span>
                        <?php else: ?>
                            <span class="text-danger font-13" data-toggle="tooltip"
                                  title="Mais cancelamento do que o mes Passado">
                                <i class="ml-2 fa fa-level-up"></i> +<?php
                                echo round(count($cancelamento->getResult()) /
                                    $mes_passado * 100 - 100); ?> %</span>
                        <?php endif; ?>
                    </div>
                    <div class="row">
                        <?php
                        foreach ($cancelamento->getMotivos() as $motivo) :
                            ?>
                            <div class="col-lg-4">
                                <div class="my-4">
                                    <div class="h4 m-0"><?php
                                        $cancelamento->somaMotivos($motivo);
                                        echo $cancelamento->getTotal();
                                        ?></div>
                                    <div class="flexbox">
                                        <small><?php echo utf8_encode($motivo); ?></small>
                                        <span class="text-warning font-12" style="font-size: 12px;"><i
                                                    class="fa fa-level-up mr-1"></i><?php
                                            $progress = round($cancelamento->getTotal() /
                                                count($cancelamento->getResult()) * 100);
                                            echo $progress; ?>%
                                    </span>
                                    </div>
                                    <div class="progress mt-1">
                                        <div class="progress-bar bg-danger" role="progressbar"
                                             style="width:<?php echo $progress; ?>%; height:5px;"
                                             aria-valuenow="<?php echo $progress; ?>" aria-valuemin="0"
                                             aria-valuemax="100"></div>
                                    </div>
                                </div>
                            </div>
                        <?php
                        endforeach;
                        ?>
                    </div>
                </div>
                <hr>
                <div class="ibox-body" style="padding: 0 25px 25px;">
                    <div class="font-16 font-strong mb-3">Detalhes</div>
                    <div class="row">
                        <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                            <div class="text-muted mb-4">Cancelados este mês</div>
                            <span class="h3 mr-3" style="cursor: pointer" onclick="busca_cancelados('Mes')">
                                    <i class="fa fa-users text-danger h1 mb-0 mr-2"
                                       data-toggle="tooltip"
                                       title="Cancelados em <?php echo exibe_mes(date('m')); ?>">
                                    </i>
                                <span><?php
                                    echo count($cancelamento->getMes());
                                    ?></span>
                            </span>
                        </div>
                        <div class="col-6 text-center">
                            <div class="text-muted mb-4">Cancelados em atraso</div>
                            <span class="h3 mr-3" data-type="ematraso" style="cursor: pointer"
                                  onclick="busca_cancelados('Atraso')">
                                    <i class="fa fa-users text-danger h1 mb-0 mr-2"
                                       data-toggle="tooltip"
                                       title="Cancelado em atraso">
                                    </i>
                                    <span><?php
                                        echo count($cancelamento->getAtraso());
                                        ?></span>
                            </span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- END CANCELAMENTOS ESTE MES -->

        <!-- CANCELAMENTOS MES PASSADO / ACUMULADO -->
        <div class="col-lg-4 col-md-6">
            <div class="ibox">
                <div class="ibox-body">
                    <h2 class="mb-1"><?php echo $mes_passado; ?></h2>
                    <div class="text-muted text-uppercase"><?php
                        echo exibe_mes(date('m', strtotime('-1 month')));
                        ?></div>
                    <i class="ti-calendar widget-stat-icon text-danger"></i>
                    <div class="mt-2">
                        <?php if (round($mes_passado / $mes_retrasado * 100 - 100) < 0):; ?>
                            <span class="text-success font-13 mr-1"><i class="fa fa-level-down"></i>
                                <?php
                                echo round($mes_passado / $mes_retrasado * 100 - 100);
                                ?>%</span>
                        <?php else: ?>
                            <span class="text-danger font-13 mr-1"><i class="fa fa-level-up"></i> +
                                <?php
                                echo round($mes_passado / $mes_retrasado * 100 - 100);
                                ?>%</span>
                        <?php endif; ?>
                        <small>do que <?php echo exibe_mes(date('m', strtotime('-2 month'))); ?></small>
                    </div>
                </div>
                <div class="ibox-body bg-danger">
                    <h5 class="text-center text-white mb-3">Estatística</h5>
                    <div>
                        <canvas id="chart_c" style="height:130px;"></canvas>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- END CANCELAMENTOS MES PASSADO /ACUMULADO -->

    <div class="row">

        <!-- CARD HISTORICO OS CANCELAMENTO -->
        <div class="col-xl-7">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">
                        <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                             <i class="fa fa-line-chart"></i>
                        </span>Estatística Cancelamento -
                        <?php echo exibe_mes(date('m')); ?>
                        <span class="label label-warning ml-5">BETA</span>
                    </div>
                </div>
                <div id="historico_os_cancelamento"></div>
            </div>
        </div>
        <!--END CARD HISTORICO OS CANCELAMENTO -->

        <!-- INSTALAÇÃO X CANCELAMENTO -->
        <div class="col-lg-5">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>
                        Instalação x Cancelamento
                    </div>
                </div>
                <div class="ibox-body">
                    <div id="barStacked"></div>
                </div>
            </div>
        </div>
        <!-- END INSTALAÇÃO X CANCELAMENTO -->
    </div>
    <!-- TABELA DE CANCELAMENTO -->
    <div class="row">
        <div class="col-lg-12">
            <div class="ibox">
                <div class="ibox-head">
                    <div class="ibox-title">
                        <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-3"><i
                                    class="fa fa-table"></i></span>Tabela de Cancelamento
                    </div>
                    <div class="ibox-tools">
                        <div id="reportrange-cancelamento"
                             style="cursor: pointer;
                                 padding: 5px 10px; width: 100%">
                            <i class="fa fa-calendar mr-2"></i>
                            <span></span><b class="caret"></b>
                        </div>
                    </div>
                </div>
                <div class="ibox-body">
                    <div class="flexbox mb-4">
                        <div class="input-group-icon input-group-icon-left mr-3">
                            <span class="input-icon input-icon-right font-16"><i class="ti-search"></i></span>
                            <input class="form-control form-control-rounded form-control-solid"
                                   id="key-search" type="text"
                                   placeholder="Procurar ...">
                        </div>
                    </div>
                    <div id="load_cancelamento"></div>
                </div>
            </div>
        </div>
    </div>
    <!-- END TABELA DE CANCELAMENTO -->

</div>
