<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 14/12/2018
 * Time: 08:51
 */

require_once "./classes/Clientes.php";
require_once "./classes/Comercial.php";
require_once "./classes/Previsao.php";
require_once "./funcoes/funcoes.php";
require_once "./classes/Dashboard_Adm.php";


//primeiro dia do mes
$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
// ultimo dia do mes
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));
// primeiro dia do mes passado
$dt_i2 = date('d-m-Y', mktime(0, 0, 0, date('m') - 1,
    1, date('Y')));
// ultimo dia do mes passado
$dt_f2 = date('d-m-Y', mktime(0, 0, 0, date('m'),
    date('d') - date('j'), date('Y')));
// primeiro dia do mes retrasado
$dt_i3 = date('d-m-Y', mktime(0, 0, 0, date('m') - 2,
    1, date('Y')));
// ultimo dia do mes retrasado
$dt_f3 = date('d-m-Y', mktime(23, 59, 59, date('m') - 1,
    date('d') - date('j'), date('Y')));
$data_4 = date('Y-m-d', mktime(23, 59, 59, date('m') +1,
    date("t"), date('Y')));

$clientes = new Clientes();
$comercial = new Comercial();
$previsao = new Previsao();
$pendentes = new Dashboard_Adm();
$previsao->carregarPrevisaoCom();
$pendentes->carregarOS($dt_i, $data_4);
?>
<!-- INICIO WIDGET -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-info text-white"><i class="ti-user"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira(nomenclatura('Comercial'), 2);
                        echo number_format($clientes->getTotalclientes(), 0, ',', '.'); ?>
                    </h4>
                    <small>USUÁRIOS</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-info" data-toggle="tooltip" title="Total Comercial Instalados
                    neste mês" onclick="clientesNovos('Comercial', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('Comercial', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-primary text-white"><i class="la la-wifi"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('Rádio');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>RÁDIO</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-primary" data-toggle="tooltip" title="Rádio Instalados
                    neste mês" onclick="clientesNovos('Rádio Comercial', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('Rádio Comercial', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-success text-white"><i class="la la-link"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('Fibra');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>FIBRA</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-success" data-toggle="tooltip" title="Fibra Instaladas
                    neste mês" onclick="clientesNovos('Fibra Comercial', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('Fibra Comercial', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-warning text-white"><i class="ti-calendar"></i>
                    <h4 class="m-0"><?php $pendentes->pendente_tipo('Comercial', $dt_i, $dt_f);
                        echo $pendentes->getPendenteTipo();?>
                    </h4>
                    <small>AGUARDANDO</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-warning" data-toggle="tooltip" title="Vendas cadastradas e agendadas
                    realizadas na data de hoje" onclick="vendasDia(32,4)"
                        style="cursor: pointer">
                        <?php
                        //GRUPO CAC-Vendas MK comercial = 32 e grupo de atendimento comercial = 4
                        $clientes->loadVendas_dia(32, 4);
                        if(!empty($clientes->getVendidosDia())){
                            echo count($clientes->getVendidosDia());
                        }else{
                            echo 0;
                        }?>
                    </h4>
                    <div class="text-muted font-13">VENDAS HOJE</div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM WIDGET -->

<!-- EXTRATO DE RECEBIMENTO -->
<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>Extrato de Recebimentos
                </div>
                <ul class="nav nav-tabs tabs-line" id="myTab-fatcomercial">
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-1-1" data-toggle="tab"><?php echo exibe_mes(date('m',
                                strtotime($dt_f3))); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-1-2" data-toggle="tab"><?php echo exibe_mes(date('m',
                                strtotime($dt_f2))); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#tab-1-3"
                           data-toggle="tab"><?php echo exibe_mes(date('m')); ?></a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body">
                <div class="tab-content">
                    <div class="tab-pane fade text-center" id="tab-1-1">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-1"></div>
                    </div>
                    <div class="tab-pane fade text-center" id="tab-1-2">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-2"></div>
                    </div>
                    <div class="tab-pane fade show active text-center" id="tab-1-3">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM EXTRATO -->

<!-- INICIO CARTOES FATURAMENTO -->
<div class="row">
    <?php $comercial->faturamento($dt_i3, $dt_f3); $previsao->buscaPrevisao('COMERCIAL',
        exibe_mes(date('m', strtotime($dt_f3))), date('Y', strtotime('-2 months')));?>
    <div class="col-sm-6 col-md-6 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                            strtotime($dt_f3))); ?></span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php echo formata_valor(array_sum($comercial->getMes())); ?>
                        </div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php echo formata_valor(array_sum($comercial->getAtraso())) ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">
                    Previsão: <?php echo formata_valor($previsao->getResult()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php echo formata_valor(array_sum($comercial->getMes())
                                                + array_sum($comercial->getAtraso())) ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php echo round((($previsao->getResult() -
                                                        array_sum($comercial->getMes()))/
                                                    $previsao->getResult()) * 100);?>%</span>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_a" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php $comercial->faturamento($dt_i2, $dt_f2); $previsao->buscaPrevisao('COMERCIAL',
        exibe_mes(date('m', strtotime($dt_f2))), date('Y', strtotime('-1 months')));?>
    <div class="col-sm-6 col-md-6 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                            strtotime($dt_f2))); ?></span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php echo formata_valor(array_sum($comercial->getMes())); ?>
                        </div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php echo formata_valor(array_sum($comercial->getAtraso())); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">Previsão:
                    R$ <?php echo formata_valor($previsao->getResult()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php echo formata_valor(array_sum($comercial->getMes())
                                                + array_sum($comercial->getAtraso())) ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php echo round((($previsao->getResult() -
                                                        array_sum($comercial->getMes()))/
                                                    $previsao->getResult()) * 100);?>%</span>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_b" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php $comercial->faturamento($dt_i, $dt_f); $previsao->buscaPrevisao('COMERCIAL',
        exibe_mes(date('m')));?>
    <div class="col-sm-6 col-md-6 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m')); ?>
                    </span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php if(!empty($comercial->getMes())){
                                echo formata_valor(array_sum($comercial->getMes()));
                            }else{
                                echo 0;
                            } ?></div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php if(!empty($comercial->getAtraso())){
                                echo formata_valor(array_sum($comercial->getAtraso()));
                            }else{
                                echo 0;
                            } ?></div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">Previsão:
                    R$ <?php echo formata_valor($previsao->getResult()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if(!empty($comercial->getAcumulado())){
                                                  echo formata_valor(array_sum($comercial->getMes())
                                                    + array_sum($comercial->getAtraso()));
                                              }else{
                                                  echo 0;
                                            } ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="A Faturar">
                                            <i class="ti-stats-up text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php if(!empty($comercial->getAcumulado())){
                                            echo round((($previsao->getResult() - array_sum($comercial->getMes()))/
                                                    $previsao->getResult()) * 100);
                                        }else{
                                            echo 0;
                                            }?>%</span>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_c" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM CARTOES FATURAMENTO -->

<!-- INICIO CHART EVOLUCAO CARTEIRA -->
<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>Evolução Ano - Carteira de Clientes
                </div>
            </div>
            <div class="ibox-body">
                <div id="chart_clientesCarteira" style="height:280px;"></div>
            </div>
        </div>
    </div>
</div>
<!-- FIM CHART EVOLUCAO CARTEIRA -->

<!-- INICIO TABELA DE VENDAS -->
<div class="col-lg-12">
    <div class="ibox">
        <div class="ibox-head">
            <div class="ibox-title">
                    <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-3"><i
                                class="fa fa-table"></i></span>Tabela de Vendas Comercial</div>
            <div class="ibox-tools">
                <div id="reportrange" style="cursor: pointer; padding: 5px 10px; width: 100%">
                    <i class="fa fa-calendar mr-2"></i>
                    <span></span><b class="caret"></b>
                </div>
            </div>
        </div>
        <div class="ibox-body">
            <div class="flexbox mb-4">
                <div class="flexbox">
                    <label class="mb-0 mr-2">Status:</label>
                    <select class="selectpicker show-tick form-control" id="type-filter" title="Selecione"
                            data-style="btn-solid" data-width="150px">
                        <option value="">All</option>
                        <option value="liquidado Aguardando">Liquidado Aguardando</option>
                        <option value="liquidado sucesso insta">Liquidado Finalizado</option>
                        <option value="suspenso sucesso">Suspenso Finalizado</option>
                        <option value="autorizado sucesso">Autorizado Finalizado</option>
                    </select>
                </div>
                <div>
                    <button class="btn btn-outline-secondary btn-fix" onclick="exporttable('0-2')">
                        <span class="btn-icon"><i class="ti-printer"></i>Imprimir</span>
                    </button>
                    <button class="btn btn-outline-secondary btn-fix" onclick="exporttable('0-1')">
                        <span class="btn-icon"><i class="fa fa-file-excel-o"></i>Exportar</span>
                    </button>
                    <button class="btn btn-outline-secondary btn-fix" onclick="exporttable('0-0')">
                        <span class="btn-icon"><i class="fa fa-copy"></i>Copiar</span>
                    </button>
                </div>
                <div class="input-group-icon input-group-icon-left mr-3">
                    <span class="input-icon input-icon-right font-16"><i class="ti-search"></i></span>
                    <input class="form-control form-control-rounded form-control-solid" id="key-search" type="text"
                           placeholder="Procurar ...">
                </div>
            </div>
            <div id="resumo-vendas"></div>
        </div>
    </div>
</div>
<!-- FIM TABELA DE VENDAS -->