<?php
include_once "./classes/Dashboard_OS.php";
include_once "./funcoes/funcoes.php";
// RECEBE O PRIMEIRO E O ULTIMO DIA DO MES CORRENTE
$dt_i = date('Y-m-d', mktime(0, 0, 0, date('m'), 1,
    date('Y')));
$dt_f = date('Y-m-d', mktime(23, 59, 59, date('m'),
    date("t"), date('Y')));

//CARREGA TODAS AS OS DO PERIODO INFORMADO
$os = new Dashboard_OS($dt_i, $dt_f);
?>
<!-- INICIO INDICADORES -->
<!-- CARTAO HOJE -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-6">
        <div class="animated fadeInDown card bg-success mb-4">
            <div class="card-body">
                <h2 class="text-white"><?php //CARREGA AS OS CONCLUIDAS HOJE
                    $os->os_concluidas(date('Y-m-d'), date('Y-m-d'));
                    if (!(empty($os->getConcluidas()))) {
                        echo count($os->getConcluidas());
                    } else {
                        echo 0;
                    } ?><i class="fa fa-wrench float-right"></i>
                </h2>
                <div class="text-uppercase font-strong text-white mt-1">Concluídas Hoje</div>
                <div class="text-white mt-3">
                    <?php foreach ($os->getSeguimentos() as $item): ?>
                        <span class="badge font-10 text-uppercase widget-dark-badge"><?php
                            echo substr($item, 0, 3); ?>
                        </span>
                        <span class="mr-1 font-13"><i class="fa fa-caret-up text-redenilfcolor mr-1"></i><?php
                            //CARREGA OS RÁDIOS INSTALADOS HOJE;
                            $os->os_concluidas_seguimento($item, date('Y-m-d'), date('Y-m-d'));
                            if (!(empty($os->getOsConcluidaSeguimento()))) {
                                echo count($os->getOsConcluidaSeguimento());
                            } else {
                                echo 0;
                            } ?>
                    </span>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="progress mb-2 widget-dark-progress">
                <?php
                $os->os_pendentes(date('Y-m-d'), date('Y-m-d'));
                if (!empty($os->getOsPendentes())) {
                    $bar = ((count($os->getConcluidas()) /
                            (count($os->getConcluidas()) + count($os->getOsPendentes()))) * 100);
                } else {
                    $bar = 0;
                }
                ?>
                <div class="animated fadeInLeft progress-bar-hoje text-center font-13 text-white font-strong"
                     role="progressbar" style="width: <?php echo round($bar) ?>%; height: 15px;"
                     aria-valuenow="<?php echo round($bar) ?>" aria-valuemin="0" aria-valuemax="100"
                     data-toggle="tooltip" title="O.S concluídas do dia">
                    <span><?php echo round($bar) ?>%</span></div>
            </div>
        </div>
    </div>

    <!-- CARTAO ONTEM -->
    <div class="col-lg-3 col-md-6">
        <div class="animated fadeInDown card bg-primary mb-4">
            <div class="card-body">
                <h2 class="text-white"><?php //CARREGA AS OS CONCLUIDAS ONTEM
                    $os->os_concluidas(date('Y-m-d', strtotime('-1 days')),
                        date('Y-m-d', strtotime('-1 days')));
                    if (!(empty($os->getConcluidas()))) {
                        echo count($os->getConcluidas());
                    } else {
                        echo 0;
                    } ?><i class="fa fa-wrench float-right"></i></h2>
                <div class="text-uppercase font-strong text-white mt-1">Concluídas Ontem</div>
                <div class="text-white mt-3">
                    <?php foreach ($os->getSeguimentos() as $item): ?>
                        <span class="font-10 badge text-uppercase widget-dark-badge"><?php
                            echo substr($item, 0, 3); ?></span>
                        <span class="font-13 mr-1"><i
                                    class="fa fa-caret-up text-success mr-1"></i> <?php //CARREGA OS INSTALADOS ONTEM;
                            $os->os_concluidas_seguimento($item, date('Y-m-d', strtotime('-1 days')),
                                date('Y-m-d', strtotime('-1 days')));
                            if (!(empty($os->getOsConcluidaSeguimento()))) {
                                echo count($os->getOsConcluidaSeguimento());
                            } else {
                                echo 0;
                            } ?></span>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="animated fadeInLeft progress mb-2 widget-dark-progress">
                <div class="progress-bar-ontem text-center font-13 text-white font-strong"
                     role="progressbar" style="width: 100%; height: 15px;"
                     aria-valuenow="100" aria-valuemin="0" aria-valuemax="100">
                    <span>100%</span></div>
            </div>
        </div>
    </div>

    <!--SEMANA -->
    <div class="col-lg-3 col-md-6">
        <div class="animated fadeInDown card bg-info mb-4">
            <div class="card-body">
                <h2 class="text-white"><?php //CARREGA O ACUMULADO DA SEMANA (SEG A SEXTA)
                    $os->os_concluidas(date('Y-m-d', strtotime("this week")),
                        date('Y-m-d', strtotime("next friday")));
                    if (!(empty($os->getConcluidas()))) {
                        echo count($os->getConcluidas());
                    } else {
                        echo 0;
                    } ?><i class="fa fa-calendar-plus-o float-right"></i></h2>
                <div class="text-uppercase font-strong text-white mt-1">Concluídas esta Semana</div>
                <div class="text-white mt-3">
                    <?php foreach ($os->getSeguimentos() as $item): ?>
                        <span class="font-10 badge text-uppercase widget-dark-badge"><?php
                            echo substr($item, 0, 3); ?></span>
                        <span class="mr-1 font-13"><i class="fa fa-caret-up text-redenilfcolor mr-1"></i> <?php
                            $os->os_concluidas_seguimento($item, date('Y-m-d', strtotime("this week")),
                                date('Y-m-d', strtotime("next friday")));
                            if (!(empty($os->getOsConcluidaSeguimento()))) {
                                echo count($os->getOsConcluidaSeguimento());
                            } else {
                                echo 0;
                            } ?>
                        </span>
                    <?php endforeach; ?>
                </div>
            </div>
            <div class="progress mb-2 widget-dark-progress">
                <?php
                $os->os_pendentes(date('Y-m-d', strtotime("this week")),
                    date('Y-m-d', strtotime("next friday")));
                if (!empty($os->getConcluidas())) {
                    $bar = ((count($os->getConcluidas()) / (count($os->getConcluidas()) +
                                count($os->getOsPendentes()))) * 100);
                } else {
                    $bar = 0;
                }
                ?>
                <div class="animated fadeInLeft progress-bar-semana text-center font-13 text-white font-strong"
                     role="progressbar" style="width: <?php echo round($bar) ?>%; height: 15px;"
                     aria-valuenow="<?php echo round($bar) ?>" aria-valuemin="0" aria-valuemax="100">
                    <span><?php if ($bar == 0) {
                            echo '0%';
                        } else {
                            echo round($bar) . '%';
                        } ?></span></div>
            </div>
        </div>
    </div>

    <!-- MES -->
    <div class="col-lg-3 col-md-6">
        <div class="animated fadeInDown card bg-info mb-4">
            <div class="card-body">
                <h2 class="text-white"><?php
                    //CARREGA O ACUMULADO DO MÊS
                    $os->os_concluidas(date('Y-m-d', mktime(0, 0, 0, date('m'), 1,
                        date('Y'))), date('Y-m-d', mktime(23, 59, 59, date('m'),
                        date("t"), date('Y'))));
                    if (!(empty($os->getConcluidas()))) {
                        echo count($os->getConcluidas());
                    } else {
                        echo 0;
                    } ?><i class="fa fa-calendar float-right"></i></h2>
                <div class="text-uppercase font-strong text-white mt-1">Concluidas este Mês</div>
                <div class="text-white mt-3">
                    <?php foreach ($os->getSeguimentos() as $item): ?>
                    <span class="mb-2 font-10 badge text-uppercase widget-dark-badge"><?php
                            echo substr($item, 0, 3); ?></span>
                    <span class="mb-2 mr-1 font-13"><i class="fa fa-caret-up text-redenilfcolor mr-1"></i> <?php
                        $os->os_concluidas_seguimento($item, date('Y-m-d', mktime(0, 0, 0, date('m'), 1,
                            date('Y'))), date('Y-m-d', mktime(23, 59, 59, date('m'),
                            date("t"), date('Y'))));
                        if (!(empty($os->getOsConcluidaSeguimento()))) {
                            echo count($os->getOsConcluidaSeguimento());
                        } else {
                            echo 0;
                        } ?></span>
                   <?php endforeach;?>
                </div>
            </div>
            <div class="progress mb-2 widget-dark-progress">
                <?php
                $os->os_pendentes(date('Y-m-d', mktime(0, 0, 0, date('m'), 1,
                    date('Y'))), date('Y-m-d', mktime(23, 59, 59, date('m'),
                    date("t"), date('Y'))));
                if (!empty($os->getConcluidas())) {
                    $bar = ((count($os->getConcluidas()) / (count($os->getConcluidas()) +
                                count($os->getOsPendentes()))) * 100);
                } else {
                    $bar = 0;
                }
                ?>
                <div class="animated fadeInLeft progress-bar-mes text-center font-13 text-white font-strong"
                     role="progressbar" style="width: <?php echo round($bar) ?>%; height: 15px;"
                     aria-valuenow="<?php echo round($bar) ?>" aria-valuemin="0" aria-valuemax="100">
                    <span><?php if ($bar == 0) {
                            echo '0%';
                        } else {
                            echo round($bar) . '%';
                        } ?></span></div>
            </div>
        </div>
    </div>
</div>
<!-- FIM INDICADORES -->
