<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 14/12/2018
 * Time: 08:51
 */

require_once "./classes/Clientes.php";
require_once "./classes/ISP.php";
require_once "./classes/Previsao.php";
require_once "./funcoes/funcoes.php";
require_once "./classes/Dashboard_Adm.php";


//primeiro dia do mes
$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
// ultimo dia do mes
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));
// primeiro dia do mes passado
$dt_i2 = date('d-m-Y', mktime(0, 0, 0, date('m') - 1,
    1, date('Y')));
// ultimo dia do mes passado
$dt_f2 = date('d-m-Y', mktime(0, 0, 0, date('m'),
    date('d') - date('j'), date('Y')));
// primeiro dia do mes retrasado
$dt_i3 = date('d-m-Y', mktime(0, 0, 0, date('m') - 2,
    1, date('Y')));
// ultimo dia do mes retrasado
$dt_f3 = date('d-m-Y', mktime(23, 59, 59, date('m') - 1,
    date('d') - date('j'), date('Y')));
// ultimo dia do mes que vem
$data_4 = date('Y-m-d', mktime(23, 59, 59, date('m') + 1,
    date("t"), date('Y')));

$clientes = new Clientes();
$isp = new ISP();
$previsao = new Previsao();
$previsao->carregarPrevisaoIsp();
$pendentes = new Dashboard_Adm();
$pendentes->carregarOS($dt_i, $data_4);
?>
<!-- INICIO WIDGET -->
<div class="row mb-4">
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-info text-white"><i class="ti-user"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira(nomenclatura('ISP'), 4);
                        echo number_format($clientes->getTotalclientes(), 0, ',', '.'); ?>
                    </h4>
                    <small>USUÁRIOS</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <?php $clientes->loadAdesao(); ?>
                    <h4 class="font-strong text-info" data-toggle="tooltip" title="Total Residencial Instalados
                    neste mês" onclick="clientesNovos('ISP', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('ISP', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-success text-white"><i class="la la-link"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('LINK IP');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>LINK IP</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-success" data-toggle="tooltip" title="LINK IP instalados
                    neste mês" onclick="clientesNovos('ISP LINK IP', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('ISP LINK IP', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-success text-white"><i class="la la-link"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('LINK BGP');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>LINK BGP</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-success" data-toggle="tooltip" title="Link BGP instalados
                    neste mês" onclick="clientesNovos('ISP LINK BGP', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('ISP LINK BGP', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-success text-white"><i class="la la-link"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('TRANSPORTE PTT');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>PTT</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-success" data-toggle="tooltip" title="Transporte PTT instalados
                    neste mês" onclick="clientesNovos('ISP TRANSPORTE PTT', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('ISP TRANSPORTE PTT', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-success text-white"><i class="la la-link"></i>
                    <h4 class="m-0"><?php $clientes->loadCarteira_Tipo('LAN TO LAN');
                        echo number_format(count($clientes->getCarteiraTipo()), 0, ',', '.'); ?>
                    </h4>
                    <small>LAN TO LAN</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-success" data-toggle="tooltip" title="LAN TO LAN instalados
                    neste mês" onclick="clientesNovos('ISP LAN TO LAN', '<?php echo $dt_i?>','<?php echo $dt_f?>')"
                        style="cursor: pointer">
                        <?php
                        $pendentes->acumulados_mes('ISP LAN TO LAN', $dt_i, $dt_f);
                        echo $pendentes->getAcumuladoTecnologia();?></h4>
                    <div class="text-muted font-13">CONTRATOS NOVOS</div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-lg-3 col-md-4 col-sm-6">
        <div class="card mb-4">
            <div class="card-body flexbox-b" style="padding: 0">
                <div class="static-widget bg-warning text-white"><i class="ti-calendar"></i>
                    <h4 class="m-0"><?php $pendentes->pendente_tipo('ISP', $dt_i, $dt_f);
                        echo $pendentes->getPendenteTipo(); ?>
                    </h4>
                    <small>AGUARDANDO</small>
                </div>
                <div class="static-widget" style="padding: 20px">
                    <h4 class="font-strong text-warning" data-toggle="tooltip" title="Vendas cadastradas e agendadas
                    realizadas na data de hoje" onclick="vendasDia(40,8)"
                        style="cursor: pointer">
                        <?php
                        //GRUPO Corporativo MK = 40 e grupo atendimento empresarial = 5
                        $clientes->loadVendas_dia(40, 8);
                        if (!empty($clientes->getVendidosDia())) {
                            echo count($clientes->getVendidosDia());
                        } else {
                            echo 0;
                        } ?>
                    </h4>
                    <div class="text-muted font-13">VENDAS HOJE</div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM WIDGET -->

<!-- EXTRATO DE RECEBIMENTO -->
<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>Extrato de Recebimentos
                </div>
                <ul class="nav nav-tabs tabs-line" id="myTab-fatisp">
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-1-1" data-toggle="tab"><?php echo exibe_mes(date('m',
                                strtotime($dt_f3))); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-1-2" data-toggle="tab"><?php echo exibe_mes(date('m',
                                strtotime($dt_f2))); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#tab-1-3"
                           data-toggle="tab"><?php echo exibe_mes(date('m')); ?></a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body">
                <div class="tab-content">
                    <div class="tab-pane fade text-center" id="tab-1-1">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-1"></div>
                    </div>
                    <div class="tab-pane fade text-center" id="tab-1-2">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-2"></div>
                    </div>
                    <div class="tab-pane fade show active text-center" id="tab-1-3">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM EXTRATO -->

<!-- INICIO CARTOES FATURAMENTO -->
<div class="row">
    <?php $isp->faturamento($dt_i3, $dt_f3);
    $previsao->buscaPrevisao('ISP',
        exibe_mes(date('m', strtotime($dt_f3))), date('Y', strtotime('-2 months'))); ?>
    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                            strtotime($dt_f3))); ?></span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php if (!empty($isp->getMes()))
                                echo formata_valor(array_sum($isp->getMes())); ?>
                        </div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php if (!empty($isp->getAtraso()))
                                echo formata_valor(array_sum($isp->getAtraso())) ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">
                    Previsão: <?php if (!empty($isp->getResult()))
                        echo formata_valor($previsao->getResult()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if (!empty($isp->getMes()))
                                                echo formata_valor(array_sum($isp->getMes())
                                                    + array_sum($isp->getAtraso())) ?></span>
                                        <?php if (!empty($isp->getResult()) && round((($previsao->getResult() -
                                                        array_sum($isp->getMes())) /
                                                    $previsao->getResult()) * 100) > 0): ?>
                                            <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                            <span class="h6 mb-0 text-white"><?php if (!empty($isp->getResult()))
                                                    echo round((($previsao->getResult() - array_sum($isp->getMes())) /
                                                            $previsao->getResult()) * 100); ?>%</span>
                                        <?php endif; ?>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_a" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php $isp->faturamento($dt_i2, $dt_f2);
    $previsao->buscaPrevisao('ISP',
        exibe_mes(date('m', strtotime($dt_f2))), date('Y', strtotime('-1 month'))); ?>
    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                            strtotime($dt_f2))); ?></span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php if (!empty($isp->getMes()))
                                echo formata_valor(array_sum($isp->getMes())); ?>
                        </div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php if (!empty($isp->getAtraso()))
                                echo formata_valor(array_sum($isp->getAtraso())); ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">Previsão:
                    R$ <?php if (!empty($isp->getResult()))
                        echo formata_valor($previsao->getResult()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if (!empty($isp->getMes()))
                                                echo formata_valor(array_sum($isp->getMes())
                                                    + array_sum($isp->getAtraso())) ?></span>
                                        <?php if (!empty($isp->getResult()) && round((($previsao->getResult() -
                                                        array_sum($isp->getMes())) /
                                                    $previsao->getResult()) * 100) > 0): ?>
                                            <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                            <span class="h6 mb-0 text-white"><?php if (!empty($isp->getResult()))
                                                    echo round((($previsao->getResult() - array_sum($isp->getMes())) /
                                                            $previsao->getResult()) * 100); ?>%</span>
                                        <?php endif; ?>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_b" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php $isp->faturamento($dt_i, $dt_f);
    $previsao->buscaPrevisao('ISP',
        exibe_mes(date('m'))); ?>
    <div class="col-sm-6 col-md-4 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m')); ?>
                    </span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php if (!empty($isp->getMes()))
                                echo formata_valor(array_sum($isp->getMes())); ?></div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php if (!empty($isp->getAtraso()))
                                echo formata_valor(array_sum($isp->getAtraso())); ?></div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">Previsão:
                    R$ <?php echo formata_valor($previsao->getResult()); ?>
                    <i class="ti-arrow-circle-right ml-4 font-14" style="cursor: pointer" data-toggle="tooltip"
                       title="Detalhes" onclick="listaclientesPrevisao()"></i>
                </h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if (!empty($isp->getMes()))
                                                echo formata_valor(array_sum($isp->getMes())
                                                    + array_sum($isp->getAtraso())) ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="A Faturar">
                                            <i class="ti-stats-up text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php if (!empty($isp->getResult()))
                                                echo round((($previsao->getResult() - array_sum($isp->getMes())) /
                                                        $previsao->getResult()) * 100); ?>%</span>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_c" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM CARTOES FATURAMENTO -->

<!-- INICIO CHART EVOLUCAO CARTEIRA -->
<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>Evolução Ano - Carteira de Clientes
                </div>
            </div>
            <div class="ibox-body">
                <div id="chart_clientesCarteira" style="height:280px;"></div>
            </div>
        </div>
    </div>
</div>
<!-- FIM CHART EVOLUCAO CARTEIRA -->
