<?php
/**
 * Created by PhpStorm.
 * User: dgddi
 * Date: 14/12/2018
 * Time: 08:51
 */

require_once "../funcoes/funcoes.php";
require_once "../classes/Projetos.php";
require_once "../classes/Previsao.php";

//primeiro dia do mes
$dt_i = date('d-m-Y', mktime(0, 0, 0, date('m'), 1, date('Y')));
// ultimo dia do mes
$dt_f = date('d-m-Y', mktime(23, 59, 59, date('m'), date("t"), date('Y')));
// primeiro dia do mes passado
$dt_i2 = date('d-m-Y', mktime(0, 0, 0, date('m') - 1,
    1, date('Y')));
// ultimo dia do mes passado
$dt_f2 = date('d-m-Y', mktime(0, 0, 0, date('m'),
    date('d') - date('j'), date('Y')));
// primeiro dia do mes retrasado
$dt_i3 = date('d-m-Y', mktime(0, 0, 0, date('m') - 2,
    1, date('Y')));
// ultimo dia do mes retrasado
$dt_f3 = date('d-m-Y', mktime(23, 59, 59, date('m') - 1,
    date('d') - date('j'), date('Y')));

$codprojeto = isset($_POST['projeto']) ? $_POST['projeto'] : '';
$projeto = new Projetos($codprojeto);
$previsao = new Previsao();
$previsao->carregarPrevisaoProjeto($projeto->loadallprojetos_mk($codprojeto), $codprojeto);
$projeto->buscaProjeto($codprojeto);
$projeto->loadfaturamentoTotal($codprojeto);
?>
<div class="row">
    <?php $projeto->tipoOs('Instalação');
    foreach ($projeto->getProjetos() as $item):
        if ($item['meta_clientes'] > 0) {
            $meta = round((count($projeto->getTipoOs()) / $item['meta_clientes']) * 100);
        } else {
            $meta = 0;
        }
        if(!empty($item['total_ctos'])){

            $cto = round(($projeto->getTotalcarteira() / $item['total_ctos']) * 100);
        }
        ?>
        <div class="col-lg-12 col-md-12 col-sm-12 animated zoomIn">
            <div class="ibox">
                <div class="ibox-head">
                    <input type="hidden" value="<?php echo $item['lat']; ?>" id="lat">
                    <input type="hidden" value="<?php echo $item['lng']; ?>" id="lng">
                    <div>
                        <div class="ibox-title">
                            <i class="fa fa-folder-open-o mr-2" style="cursor: pointer" data-toggle="tooltip"
                               title="Mudar de Projeto"
                               onclick="escolherProjeto()"></i>
                            <?php echo $item['projeto']; ?>
                        </div>
                        <small class="text-light ml-5">
                            Início <?php echo date('d/m/Y', strtotime($item['data_inicio'])) ?>
                            - <?php echo $item['cidade']; ?></small>
                    </div>
                </div>
                <div class="ibox-body" style="padding: 14px 25px 14px">
                    <div class="row">
                        <div class="col-lg-3">
                            <div class="my-4">
                                <div class="h2 m-0"><?php echo 'R$ ' . formata_valor($item['valor_orcado']); ?><i
                                            class="ti-stats-up ml-3 text-success"></i></div>
                                <div class="text-muted m-t-5">VALOR DO PROJETO</div>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="my-4">
                                <div class="h4 m-0"><?php
                                    echo $item['meta_clientes']
                                    ?></div>
                                <div class="flexbox">
                                    <small>Meta Clientes</small>
                                    <?php if ($meta > 100): ?>
                                        <span class="text-success font-12" style="font-size: 12px;"><i
                                                    class="fa fa-level-up"></i> 100%</span>
                                    <?php else: ?>
                                        <span class="text-warning font-12" style="font-size: 12px;"><i
                                                    class="fa fa-level-up"></i> +<?php echo $meta ?>%</span>
                                    <?php
                                    endif;
                                    ?>
                                </div>
                                <div class="progress mt-1">
                                    <?php if ($meta > 100): ?>
                                        <div class="progress-bar bg-success" role="progressbar"
                                             style="width:<?php echo $meta ?>%; height:5px;"
                                             aria-valuenow="<?php echo $meta ?>" aria-valuemin="0"
                                             aria-valuemax="100"></div>
                                    <?php else: ?>
                                        <div class="progress-bar bg-warning" role="progressbar"
                                             style="width:<?php echo $meta ?>%; height:5px;"
                                             aria-valuenow="<?php echo $meta ?>" aria-valuemin="0"
                                             aria-valuemax="100"></div>
                                    <?php
                                    endif;
                                    ?>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3">
                            <div class="my-4">
                                <div class="flexbox-b justify-content-center">
                                    <div class="easypie mr-2" data-percent="<?php echo $item['total_ctos'] ? $cto : 0?>" data-bar-color="#18c5a9"
                                         data-size="50" data-line-width="5">
                                        <span class="easypie-data font-26 text-success"><i class="ti-world"></i></span>
                                    </div>
                                    <div>
                                        <h4 class="font-strong"><?php echo $item['total_ctos'] ?: 0?></h4>
                                        <div class="text-muted">CAPACIDADE</div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-3 text-center">
                            <div class="my-4">
                                <?php if ($meta > 100): ?>
                                    <h2 class="text-success"><?php echo 'R$ ' . formata_valor($item['valor_mensalidade']); ?></h2>
                                <?php else: ?>
                                    <h2 class="text-warning"><?php echo 'R$ ' . formata_valor($item['valor_mensalidade']); ?></h2>
                                <?php
                                endif;
                                ?>
                                <div class="text-muted">
                                    <div class="text-muted my-2">MENSALIDADE</div>
                                    <?php if ($item['dt_mensalidade']) : ?>
                                        <span class="text-success mr-1"><i class="ti-calendar mr-1"></i></span>Início:
                                        <?php echo date('d/m/Y', strtotime($item['dt_mensalidade'])); ?>
                                    <?php endif; ?>

                                    <?php if ($item['last_mensalidade']) : ?>
                                        <span class="text-success ml-2 mr-1"><i class="ti-calendar mr-1"></i></span>Fim:
                                        <?php echo date('d/m/Y', strtotime($item['last_mensalidade'])); ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    <?php endforeach; ?>
</div>
<!-- INICIO WIDGET -->
<div class="row mb-2">
    <div class="col-lg-4 col-md-6 col-sm-6 animated zoomIn">
        <div class="ibox">
            <div class="ibox-body bg-info" style="padding: 25px 25px 32px">
                <h3 class="text-white"><?php echo $projeto->getTotalcarteira(); ?><i
                            class="fa fa-users float-right"></i></h3>
                <div class="text-uppercase font-strong text-white mt-1">Clientes</div>
            </div>
            <div class="ibox-body bg-redenilf text-white text-center">
                <span class="badge font-10 text-uppercase widget-dark-badge">Ativado</span>
                <span class="ml-1 font-13"><i class="fa fa-caret-up text-success mr-1"></i><?php
                    $projeto->statusBloqueio('N');
                    echo count($projeto->getStatusbloq()); ?></span>
                <span class="ml-4 badge font-10 text-uppercase widget-dark-badge">Bloqueado</span>
                <span class="ml-1 font-13"><i class="fa fa-caret-down text-danger mr-1"></i><?php
                    $projeto->statusBloqueio('S');
                    echo count($projeto->getStatusbloq()); ?></span>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6 col-sm-6 animated zoomIn">
        <div class="ibox">
            <div class="ibox-body bg-info" style="padding: 25px 25px 10px">
                <h3 class="text-white"><i class="fa fa-users float-right"></i></h3>
                <div class="row">
                    <span class="h4 ml-3 mr-5">
                        <i class="fa fa-arrow-up text-redenilfcolor h1 mb-0 mr-2"></i>
                        <span class="text-white"><?php $projeto->tipoOs('Instalação');
                            echo count($projeto->getTipoOs()); ?></span>
                        <div class="text-uppercase font-strong text-white mt-3 h6">
                            Instalado
                        </div>
                    </span>
                    <span class="h4">
                        <i class="fa fa-exchange text-redenilfcolor h1 mb-0 mr-2"></i>
                            <span class="text-white"><?php $projeto->tipoOs('Migração');
                                echo count($projeto->getTipoOs()); ?></span>
                        <div class="text-uppercase font-strong text-white mt-3 h6">
                            Migrado
                        </div>
                    </span>
                    <?php
                    if (!empty($projeto->getTipoOsNull())) :
                        ?>
                        <span class="h4 ml-3 mr-3">
                        <i class="fa fa-exchange text-redenilfcolor h1 mb-0 mr-2"></i>
                            <span class="text-white"><?php
                                echo count($projeto->getTipoOsNull()); ?></span>
                        <div class="text-uppercase font-strong text-white mt-3 h6">
                            Outros
                        </div>
                    </span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="ibox-body bg-redenilf text-white text-center">
                <span class="badge font-10 text-uppercase widget-dark-badge">INS</span>
                <span class="ml-1 font-13"><i class="fa fa-caret-up text-success mr-1"></i>R$ <?php
                    echo formata_valor($projeto->loadfaturamentoTotalTipo_os($codprojeto, 'Instalação'));
                    ?>
                </span>
                <span class="ml-4 badge font-10 text-uppercase widget-dark-badge">MIG</span>
                <span class="ml-1 font-13"><i class="fa fa-caret-down text-danger mr-1"></i>R$ <?php
                    echo formata_valor($projeto->loadfaturamentoTotalTipo_os($codprojeto, 'Migração'));
                    ?>
                </span>
            </div>
        </div>
    </div>
    <div class="col-lg-4 col-md-6 animated col-sm-6 zoomIn text-uppercase">
        <div class="ibox">
            <div class="ibox-body bg-info" style="padding: 25px 25px 10px">
                <h4 class="text-center text-white" data-toggle="tooltip"
                    title="Total Faturado desde o 1º primeiro recebimento">
                    R$ <?php echo formata_valor($projeto->getFaturamentototal()); ?>
                    <i class="fa fa-money float-right"></i></h4>
                <div>
                    <canvas id="chart_faturamentoanual" style="height: 118px;" data-toggle="tooltip"
                            title="Recebidos últimos 12 meses"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM WIDGET -->
<!-- EXTRATO DE RECEBIMENTO -->
<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>Extrato de Recebimentos
                </div>
                <ul class="nav nav-tabs tabs-line" id="myTab-fatprojeto">
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-1-1" data-toggle="tab"><?php echo exibe_mes(date('m',
                                strtotime($dt_f3))); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#tab-1-2" data-toggle="tab"><?php echo exibe_mes(date('m',
                                strtotime($dt_f2))); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="#tab-1-3"
                           data-toggle="tab"><?php echo exibe_mes(date('m')); ?></a>
                    </li>
                </ul>
            </div>
            <div class="ibox-body">
                <div class="tab-content">
                    <div class="tab-pane fade text-center" id="tab-1-1">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-1"></div>
                    </div>
                    <div class="tab-pane fade text-center" id="tab-1-2">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-2"></div>
                    </div>
                    <div class="tab-pane fade show active text-center" id="tab-1-3">
                        <div class="flexbox mb-4">
                            <div class="flexbox"></div>
                        </div>
                        <div class="tab-1-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM EXTRATO -->
<!-- INICIO MAPA PROJETO -->
<div class="row">
    <div class="col-md-12 col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                    <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-3"><i
                                class="fa fa-map-marker"></i></span>Localização
                    <span class="badge badge-success ml-1">BETA</span>
                </div>
            </div>
            <div class="ibox-body">
                <div id="mapa"></div>
            </div>
        </div>
    </div>
</div>
<!-- FIM MAPA PROJETO -->
<!-- INICIO CARTOES FATURAMENTO -->
<div class="row">
    <?php $projeto->carregarFaturamento($dt_i3, $dt_f3, $codprojeto);
    $previsao->buscaPrevisaoProjeto($codprojeto, exibe_mes(date('m', strtotime($dt_f3)))); ?>
    <div class="col-sm-6 col-md-6 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                            strtotime($dt_f3))); ?></span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php if (!empty($projeto->getMes())) {
                                echo formata_valor(array_sum($projeto->getMes()));
                            } else {
                                echo "0,00";
                            } ?>
                        </div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php if (!empty($projeto->getAtraso())) {
                                echo formata_valor(array_sum($projeto->getAtraso()));
                            } else {
                                echo "0,00";
                            } ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">
                    Previsão: <?php echo formata_valor($previsao->getResultProjetos()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if (!empty($projeto->getAcumulado())) {
                                                echo formata_valor(array_sum($projeto->getMes())
                                                    + array_sum($projeto->getAtraso()));
                                            } else {
                                                echo '0';
                                            } ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php if (!empty($previsao->getResultProjetos())) {
                                                echo round((($previsao->getResultProjetos() -
                                                            array_sum($projeto->getMes())) /
                                                        $previsao->getResultProjetos()) * 100);
                                            } else {

                                                echo 0;
                                            } ?>%</span>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_a" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php $projeto->carregarFaturamento($dt_i2, $dt_f2, $codprojeto);
    $previsao->buscaPrevisaoProjeto($codprojeto, exibe_mes(date('m', strtotime($dt_f2)))) ?>
    <div class="col-sm-6 col-md-6 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m',
                            strtotime($dt_f2))); ?></span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php if (!empty($projeto->getMes())) {
                                echo formata_valor(array_sum($projeto->getMes()));
                            } else {
                                echo "0,00";
                            } ?>
                        </div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php if (!empty($projeto->getAtraso())) {
                                echo formata_valor(array_sum($projeto->getAtraso()));
                            } else {
                                echo "0,00";
                            } ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">Previsão:
                    R$ <?php echo formata_valor($previsao->getResultProjetos()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if (!empty($projeto->getAcumulado())) {
                                                echo formata_valor(array_sum($projeto->getMes())
                                                    + array_sum($projeto->getAtraso()));
                                            } else {
                                                echo '0';
                                            } ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="Inadimplência">
                                            <i class="ti-stats-down text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php if (!empty($previsao->getResultProjetos())) {
                                                echo round((($previsao->getResultProjetos() -
                                                            array_sum($projeto->getMes())) /
                                                        $previsao->getResultProjetos()) * 100);
                                            } else {

                                                echo 0;
                                            } ?>%</span>
                                        </span>
                </div>
                <div>
                    <canvas id="chart_b" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
    <?php $projeto->carregarFaturamento($dt_i, $dt_f, $codprojeto);
    $previsao->buscaPrevisaoProjeto($codprojeto, exibe_mes(date('m'))); ?>
    <div class="col-sm-6 col-md-6 col-lg-4">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">Faturamento <span class="text-success"><?php echo exibe_mes(date('m')); ?>
                    </span></div>
                <div class="ibox-tools">
                    <span class="font-18 text-muted"><i class="ti-notepad"></i></span>
                </div>
            </div>
            <div class="ibox-body">
                <div class="row m-b-20">
                    <div class="col-6 text-center" style="border-right: 1px solid rgba(0,0,0,.1);">
                        <div class="text-muted">NO MÊS</div>
                        <div class="h6 text-success mt-1">
                            R$ <?php if (!empty($projeto->getMes())) {
                                echo formata_valor(array_sum($projeto->getMes()));
                            } else {
                                echo "0,00";
                            } ?>
                        </div>
                    </div>
                    <div class="col-6 text-center">
                        <div class="text-muted">ATRASO</div>
                        <div class="h6 text-danger mt-1">
                            R$ <?php if (!empty($projeto->getAtraso())) {
                                echo formata_valor(array_sum($projeto->getAtraso()));
                            } else {
                                echo "0,00";
                            } ?>
                        </div>
                    </div>
                </div>
            </div>
            <div class="ibox-body bg-redenilf" style="padding: 25px 25px 15px">
                <h6 class="text-center text-uppercase text-white">Previsão:
                    R$ <?php echo formata_valor($previsao->getResultProjetos()); ?></h6>
            </div>
            <div class="ibox-body bg-success">
                <div class="flexbox mb-3">
                                    <span class="flexbox">
                                        <span class="btn-icon-only btn-circle bg-success-50 text-success mr-2">
                                            <i class="la la-money"></i></span>
                                        <span class="h4 mb-0 text-white font-strong ml-1" data-toggle="tooltip"
                                              title="Recebido">R$ <?php if (!empty($projeto->getAcumulado())) {
                                                echo formata_valor(array_sum($projeto->getMes())
                                                    + array_sum($projeto->getAtraso()));
                                            } else {
                                                echo '0';
                                            } ?></span>
                                        <span class="h4 mb-0 ml-3 mr-2" data-toggle="tooltip" title="A Faturar">
                                            <i class="ti-stats-up text-white"></i>
                                        </span>
                                        <span class="h6 mb-0 text-white"><?php if (!empty($projeto->getAcumulado())) {
                                                echo round((($previsao->getResultProjetos() -
                                                            array_sum($projeto->getMes())) /
                                                        $previsao->getResultProjetos()) * 100);
                                            } else {

                                                echo 0;
                                            } ?>%
                                        </span>
                                    </span>
                </div>
                <div>
                    <canvas id="chart_c" style="height:147px;"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- FIM CARTOES FATURAMENTO -->

<!-- INICIO CHART EVOLUCAO CARTEIRA -->
<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>Evolução da Carteira de Clientes
                </div>
            </div>
            <div class="ibox-body">
                <div id="chart_projeto" style="height:280px;"></div>
            </div>
        </div>
    </div>
</div>
<!-- FIM CHART EVOLUCAO CARTEIRA -->

<!-- INICIO TABELA DE CLIENTES -->
<div class="row">
    <div class="col-lg-12">
        <div class="ibox">
            <div class="ibox-head">
                <div class="ibox-title">
                <span class="btn-icon-only btn-circle bg-primary-50 text-redenilfcolor mr-2">
                    <i class="fa fa-line-chart">
                    </i></span>Tabela de Clientes
                </div>
            </div>
            <div class="ibox-body">
                <div id="tabela_clientes"></div>
            </div>
        </div>
    </div>
</div>

