<?php

class BackupDatabase
{
    private $backupFolder;
    private $maxNumberFiles;

    private $host;
    private $database;
    private $username;
    private $password;


    /**
     * Define as informações de conexão com o banco de dados
     *
     * @param string $host
     * @param string $database
     * @param string $username
     * @param string $password
     */
    public function __construct($database, $username, $password)
    {

        $this->database = $database;
        $this->username = $username;
        $this->password = $password;
    }

    /**
     * Gera um backup
     *
     * @return void
     * @throws Exception
     */
    public function gerar_backup()
    {
        // Se as informações de conexão com o banco de dados não foram definidas
        if (empty($this->database) or empty($this->username) or empty($this->password)) {
            throw new \Exception('As informações de conexão com o banco de dados não foram definidas');
        }

        // Gerando nome único para o arquivo
        date_default_timezone_set('America/Sao_Paulo');
        $fileName = 'bkp_'.date('dmYhis'). '.sql';
        $fileNamefull = 'bkp_full_reports_'.date('dmYhis').'.tar.gz';
        $zipfile = $fileName.'.tar.gz';
        // Definindo informações para geração do backup
        system("mysqldump -u $this->username -p$this->password $this->database > sql/$fileName", $return);
        if($return == 0){

        echo "Backup do Banco foi Gerado";
        echo"<br/>";
        echo "Compactando Backup";
        echo "<br/>";
        system("tar -czvf $zipfile sql/$fileName");
        echo "Movendo Backup";
        system("mv $zipfile /home/redenilf/public_html/reports/backup");
        echo "<br/>";
        echo "Gerando Backup Completo";
        system("tar -czvf /home/redenilf/public_html/reports/backup/$fileNamefull /home/redenilf/public_html/reports/dash/ > backup.log");
        echo "<br/>";
        $this->clearFiles();
        echo "Backup Concluído";
        }else{

        echo "Houve um Problema com a Geração do Backup";
        }

    }

    private function clearFiles(){


        //mantem os ultimos 10 dias de Backup do site e do banco de dados no Linux
        exec("find /home/redenilf/public_html/reports/backup -name '*.gz' -ctime +10 -exec rm -rf {} \;");
        //mantem os ultimos 5 dias de backup do banco na pasta backup/sql
        $files = new \DirectoryIterator("../backup/sql");

        $array = array();

        foreach ($files as $row){

              if($row->isFile()){

                  $array[$row->getMTime()] = $row->getPathname();

              }
        }
        arsort($array);

       $numberFiles = 0;
       foreach ($array as $row){

           $numberFiles++;

           if($numberFiles > 5){

               unlink($row);
               echo "Apagado Backup '{$row}'";
           }

       }
    }
}

?>