<?php
session_start();
include_once("seguranca.php");
if($_SESSION['nivel'] == 'Administrador' || $_SESSION['nivel'] == 'Diretoria' || $_SESSION['nivel'] == 'Supervisor' ){

}else{
    header("Location:modal_small.php");
}
?>
<!DOCTYPE html >
<head>
    <meta name="viewport" content="initial-scale=1.0, user-scalable=no" />
    <meta http-equiv="content-type" content="text/html; charset=UTF-8"/>
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <link rel="icon" href="images/favicon-32x32.png">
    <title>Redenilf Fibra | Mapa</title>
    <style>
        /* Always set the map height explicitly to define the size of the div
         * element that contains the map. */
        #map {
            height: 100%;
        }
        /* Optional: Makes the sample page fill the window. */
        html, body {
            height: 100%;
            margin: 0;
            padding: 0;
        }
        .controls {
            margin-top: 10px;
            border: 1px solid transparent;
            border-radius: 2px 0 0 2px;
            box-sizing: border-box;
            -moz-box-sizing: border-box;
            height: 32px;
            outline: none;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.3);
        }

        #pac-input {
            background-color: #fff;
            font-family: Roboto;
            font-size: 15px;
            font-weight: 300;
            margin-left: 12px;
            padding: 0 11px 0 13px;
            text-overflow: ellipsis;
            width: 300px;
        }

        #pac-input:focus {
            border-color: #4d90fe;
        }

        .pac-container {
            font-family: Roboto;
        }

        #type-selector {
            color: #fff;
            background-color: #4d90fe;
            padding: 5px 11px 0px 11px;
        }

        #type-selector label {
            font-family: Roboto;
            font-size: 13px;
            font-weight: 300;
        }
        #target {
            width: 345px;
        }

    </style>
</head>
<body>
<input id="pac-input" class="controls" type="text" placeholder="Procurar">
<div id="type-selector" class="controls">
    <input type="radio" name="type" onchange="habilitacluster()" checked="checked">
    <label for="habilitaclusters">Clusters</label>

    <input type="radio" name="type"  onchange="habilitaheatmap()">
    <label for="habilitaheatmap">Heatmap</label>

  <!--  <input type="radio" name="type" onchange="habilitarmarkers()">
    <label for="habilitamarkers">Marcadores</label>-->

    <input type="radio" name="type" onchange="clearMarkers()">
    <label for="clearMarkers">Limpar</label>
</div>
<div id="map"></div>

<script>
    var customLabel = {
        fibra: {
            label: 'F'
        },
        bar: {
            label: 'B'
        }
    };
    var map, point, heatmap, cluster;
    var markerArr = [];
    var heatdata = [];
    var markers = [];

    function initMap() {
        map = new google.maps.Map(document.getElementById('map'), {
            center: new google.maps.LatLng(-22.95194, -46.54194)
        });

        // Create the search box and link it to the UI element.
        var input = /** @type {!HTMLInputElement} */(
            document.getElementById('pac-input'));
        var searchBox = new google.maps.places.SearchBox(input);
        map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);


        var types = document.getElementById('type-selector');
        map.controls[google.maps.ControlPosition.TOP_LEFT].push(input);
        map.controls[google.maps.ControlPosition.TOP_LEFT].push(types);


        var pointArray = new google.maps.MVCArray(heatdata);
        heatmap = new google.maps.visualization.HeatmapLayer({
            data: pointArray
        });

        // Bias the SearchBox results towards current map's viewport.
        map.addListener('bounds_changed', function() {
            searchBox.setBounds(map.getBounds());
        });



        searchBox.addListener('places_changed', function() {
            var places = searchBox.getPlaces();

            if (places.length == 0) {
                return;
            }

            // Clear out the old markers.
            markers.forEach(function(marker) {
                marker.setMap(null);
            });
            markers = [];

            // For each place, get the icon, name and location.
            var bounds = new google.maps.LatLngBounds();
            places.forEach(function(place) {
                if (!place.geometry) {
                    console.log("Returned place contains no geometry");
                    return;
                }

                // Create a marker for each place.
                markers.push(new google.maps.Marker({
                    map: map,
                    title: place.name,
                    position: place.geometry.location
                }));

                if (place.geometry.viewport) {
                    // Only geocodes have viewport.
                    bounds.union(place.geometry.viewport);
                } else {
                    bounds.extend(place.geometry.location);
                }
            });
            map.fitBounds(bounds);
        });

        cluster = new MarkerClusterer(map, {imagePath: 'images/maps/m'});

        habilitacluster();

    }


  /*  function habilitarmarkers() {
        clearMarkers();

        var infoWindow = new google.maps.InfoWindow;

        // Change this depending on the name of your PHP or XML file
        downloadUrl('control/controle_mapa.php', function (data) {
            var xml = data.responseXML;
            var markers = xml.documentElement.getElementsByTagName('marker');
            Array.prototype.forEach.call(markers, function (markerElem) {
                var name = markerElem.getAttribute('name');
                var address = markerElem.getAttribute('address');
                var bairro = markerElem.getAttribute('bairro');
                var type = markerElem.getAttribute('type');
                 point = new google.maps.LatLng(
                    parseFloat(markerElem.getAttribute('lat')),
                    parseFloat(markerElem.getAttribute('lng')));

                var infowincontent = document.createElement('div');
                var strong = document.createElement('strong');
                strong.textContent = name
                infowincontent.appendChild(strong);
                infowincontent.appendChild(document.createElement('br'));

                var text = document.createElement('text');
                var text2 = document.createElement('text');
                text.textContent = address
                text2.textContent = bairro
                infowincontent.appendChild(text);
                infowincontent.appendChild(document.createElement('br'));
                infowincontent.appendChild(text2);
                var icon = customLabel[type] || {};
                var marker = new google.maps.Marker({
                    map: map,
                    position: point,
                    animation: google.maps.Animation.DROP,
                    label: icon.label
                });

                marker.addListener('click', function () {
                    infoWindow.setContent(infowincontent);
                    infoWindow.open(map, marker);
                });
                markerArr.push(marker); //adiciona cada marcador dentto do array

            });
        });
    }*/

    function habilitaheatmap() {

        clearMarkers();

           heatmap.setMap(map);
    }

    function habilitacluster() {

         clearMarkers();
         var infoWin = new google.maps.InfoWindow();
        downloadUrl('controle_mapa/controle_mapa.php', function (data) {
            var xml = data.responseXML;
            var markers = xml.documentElement.getElementsByTagName('marker');
            Array.prototype.forEach.call(markers, function (markerElem) {
                var name = markerElem.getAttribute('name');
                var address = markerElem.getAttribute('address');
                var bairro = markerElem.getAttribute('bairro');

                var infowincontent = document.createElement('div');
                var strong = document.createElement('strong');
                strong.textContent = name;
                infowincontent.appendChild(strong);
                infowincontent.appendChild(document.createElement('br'));

                var text = document.createElement('text');
                var text2 = document.createElement('text');
                text.textContent = address;
                text2.textContent = bairro;
                infowincontent.appendChild(text);
                infowincontent.appendChild(document.createElement('br'));
                infowincontent.appendChild(text2);


                 point = new google.maps.LatLng(
                    parseFloat(markerElem.getAttribute('lat')),
                    parseFloat(markerElem.getAttribute('lng')));
                var type = markerElem.getAttribute('type');
                var icon = customLabel[type] || {};

                var marker = new google.maps.Marker({
                    map: map,
                    position: point,
                    animation: google.maps.Animation.DROP,
                    icon: 'images/user_map.png'
                    //label: icon.label
                });

                lat = parseFloat(markerElem.getAttribute('lat'));
                lng = parseFloat(markerElem.getAttribute('lng'));

                heatdata.push(new google.maps.LatLng(lat,lng));

                marker.addListener('click', function () {
                    infoWin.setContent(infowincontent);
                    infoWin.open(map, marker);
                });
                markerArr.push(marker); //adiciona cada marcador dentto do array

            });

            cluster = new MarkerClusterer(map, markerArr,{imagePath: 'images/maps/m'});
            map.setZoom(6);

        });



    }

    function clearMarkers() {

           $.each(markerArr, function (key, marker) {

               marker.setMap(null);
           });

        $.each(markers, function (key, marker) {

            marker.setMap(null);
        });

            markerArr = [];
            markers = [];
            heatmap.setMap(null);
            cluster.clearMarkers();

            }


    function downloadUrl(url, callback) {
        var request = window.ActiveXObject ?
            new ActiveXObject('Microsoft.XMLHTTP') :
            new XMLHttpRequest;

        request.onreadystatechange = function() {
            if (request.readyState == 4) {
                request.onreadystatechange = doNothing;
                callback(request, request.status);
            }
        };

        request.open('GET', url, true);
        request.send(null);
    }

    function doNothing() {}
</script>
<script src="assets/jquery/dist/jquery.min.js"></script>

<script async defer
        src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCqSZgP3rbKOa8c9u3S-933EP0fdTHAyrg&libraries=visualization,places&callback=initMap">
</script>
<script type="text/javascript" src="assets/js/maps/clusters_googlemaps.js"></script>



</body>
</html>