<?php


class Comissao extends BD {

    private $array;
    private $comissao;
    private $operadores;


    public function carregar_comissao($dt_i,$dt_f)
    {

        $sql = "select case when substr(c.unidade_financeira::text, 1,5) = '03.06' then 'FIBRA' when substr(c.unidade_financeira::text,1,5) = '03.01' then 'RADIO' ELSE ' - ' end as tipo, 
p.nome_razaosocial, o.data_fechamento as data, c.vlr_renovacao as mensalidade, upper(pl.descricao) as plano, ci.cidade as cidade, o.operador, pc.nome_razaosocial as consultor, o.tipo_os from mk_os o
left join mk_conexoes x on x.codconexao = o.conexao_associada left join mk_contratos c on c.codcontrato = x.contrato left join mk_pessoas p on p.codpessoa = c.cliente 
left join mk_cidades ci on ci.codcidade = p.codcidade left join mk_planos_acesso pl on pl.codplano = c.plano_acesso left join mk_pessoas pc on pc.codpessoa = c.vendedor 
and pc.classificacao_tipo_cliente_com = '06' 
where o.tipo_os in (1,27) and p.tipopessoa = 1 and p.classificacao = 1 and o.encerrado = 'S'
and o.classificacao_encerramento = 1 and o.data_fechamento between :data_i and :data_f order by data";

        $sql = $this->pdo->prepare($sql);
        $sql->bindValue("data_i", $dt_i);
        $sql->bindValue("data_f", $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {


            $this->array = $sql->fetchAll();
        }
    }

    public function comissao_Operador($dt_i,$dt_f)
    {

        $sql = "select count(*) as total, case when substr(c.unidade_financeira::text, 1,5) = '03.06' then 'FIBRA' when substr(c.unidade_financeira::text,1,5) = '03.01' then 'RADIO' ELSE ' - ' end as tipo, 
o.operador from mk_os o left join mk_conexoes x on x.codconexao = o.conexao_associada left join mk_contratos c on c.codcontrato = x.contrato left join mk_pessoas p on p.codpessoa = c.cliente
where o.tipo_os = 1 and p.tipopessoa = 1 and p.classificacao = 1 and o.encerrado = 'S' and o.classificacao_encerramento = 1 and o.data_fechamento between :data_i and :data_f 
group by o.operador, tipo 
UNION
select count(*) as total, case when substr(c.unidade_financeira::text, 1,5) = '03.06' then 'FIBRA' when substr(c.unidade_financeira::text,1,5) = '03.01' then 'RADIO' ELSE ' - ' end as tipo, 
pc.nome_razaosocial as consultor from mk_os o left join mk_conexoes x on x.codconexao = o.conexao_associada left join mk_contratos c on c.codcontrato = x.contrato 
left join mk_pessoas p on p.codpessoa = c.cliente
inner join mk_pessoas pc on pc.codpessoa = c.vendedor and pc.classificacao_tipo_cliente_com = '06' 
where o.tipo_os = 1 and p.tipopessoa = 1 and p.classificacao = 1 and o.encerrado = 'S' and o.classificacao_encerramento = 1 and o.data_fechamento between :data_i and :data_f 
group by pc.nome_razaosocial, tipo order by operador";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue("data_i", $dt_i);
        $sql->bindValue("data_f", $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->comissao = $sql->fetchAll();

        }
    }

    public function getcomissao_Operador($operador,$tipo){


        $total = 0;
        foreach ($this->comissao as $row){


            if(($row['operador'] == $operador) && ($row['tipo'] == $tipo)){

                $total = $row['total'];

            }
        }

        return $total;

    }

    public function getOperadores(){


        foreach ($this->array as $row){


            $operadores[] = $row['operador'];
            $consultor[] = $row['consultor'];
        }
        $operadores = array_merge($operadores,$consultor);
        $operadores = array_filter($operadores);
        $operadores = array_unique($operadores);
        sort($operadores);
        $this->operadores = $operadores;
        return $this->operadores;
       }

    public function getFibra()
    {

          foreach ($this->array as $row) {

              if ($row['tipo'] == 'FIBRA' && $row['tipo_os'] == 1) {

                  $fibra[] = $row['tipo'];
              }
          }
          return count($fibra);
    }

    public function getRadio()
    {

        foreach ($this->array as $row) {

            if ($row['tipo'] == 'RADIO' && $row['tipo_os'] == 1) {

                $radio[] = $row['tipo'];
            }
        }
        return count($radio);
    }

    public function get_migracao()
    {

        foreach ($this->array as $row) {

            if($row['tipo_os'] == 27)

                $migracao[] = $row['tipo_os'];
        }
        return count($migracao);
    }

     public function getComissao(){

            return $this->array;

        }






}


?>