function carrega_tabela() {

    $("#tabela_logradouro").dataTable().fnDestroy();

    $.ajax({
        type: "GET",
        url: './controle_mapa/carrega_markers.php',
        beforeSend: function () {
            $('#tabela').html('<div class="text-center"><br/><br/><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i><h2 class="animated slideInLeft">Carregando...</h2></div>');
        },
        success: function (data) {

            $('#tabela').html(data);
            $('#tabela-markers').dataTable({
                fixedHeader: !0,
                "columnDefs": [{"width": "8%", "targets": 7}],
                "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "All"]],
                "order": [[0, "desc"]]
            });
            $('[data-toggle="tooltip"]').tooltip();
        }


    });
}

function editar(id) {

    $('#modal-geral').modal('show');

    $.ajax({
        type: "POST",
        url: "./controle_mapa/carrega_markers.php?p=edit",
        data: 'id=' + id,
        beforeSend: function () {
            $('#modal-geral').find('.modal-body').html('Carregando ....');
            $('#modal-geral').modal('show');
        },
        success: function (html) {
            $('#modal-geral').find('.resultado').html(html);
            $('#modal-geral').find('.resultado').find('.modal-body').find('form').on('submit', salvar);

        }
    });
}

function salvar(e) {

    e.preventDefault();

    var data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './controle_mapa/carrega_markers.php?p=salve',
        data: data,
        success: function () {

            $('#modal-geral').modal('hide');
            toastr.success('Atualizado com Sucesso');
        }
    });
    carrega_tabela();
}

function excluir(e) {

    e.preventDefault();

    var data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './controle_mapa/carrega_markers.php?p=excluir',
        data: data,
        success: function () {

            $('#modal-delete').modal('hide');
            toastr.success('Excluido');


        }
    });
    carrega_tabela();
}

function deletar(id) {

    $('#modal-delete').modal('show');
    $.ajax({
        type: "POST",
        url: "./controle_mapa/carrega_markers.php?p=delete",
        data: 'id=' + id,
        success: function (html) {
            $('#modal-delete').find('.deletar').html(html);
            $('#modal-delete').find('.deletar').find('.modal-body').find('form').on('submit', excluir);

        }
    });
}

function modal_carregar_mapa() {

    $('#modal-carregar').modal('show');

    $.ajax({
        type: "GET",
        url: "./controle_mapa/carrega_maps.php",
        beforeSend: function () {
            $('#modal-carregar').find('.carregar').html('<div class="text-center"><br/><br/><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i>' +
                '<h2 class="animated slideInLeft">Carregando...</h2></div>');
            $('#modal-carregar').modal('show');
        },
        success: function (html) {
            $('#modal-carregar').find('.carregar').html(html);
            carrega_tabela();
        }
    });

}
