<?php

class Residencial{

    private $pdo;
    private $array;
    private $radio;
    private $fibra;
    private $cabo;



    public function __construct(){

        {
            $dsn = "pgsql:dbname=mkData;host=177.107.72.12";
            $db_usuario = "cliente_r";
            $db_password = "Cl13nt_R";

            try {

                $this->pdo = new PDO($dsn, $db_usuario, $db_password);

            } catch (PDOException $e) {

                echo "Falha na Conexao com o Banco de Dados: " . $e->getMessage();
            }
        }

    }


    public function query($dt_i, $dt_f){

        $sql = "SELECT date_part('day'::text, tab.data_pagto) AS data, sum(tab.no_mes) AS mes, sum(tab.atraso) AS atraso FROM ( SELECT x.data_pagto, CASE WHEN x.pagto = 'NO MS'::text THEN sum(x.valor_pago) ELSE NULL::double precision
END AS no_mes, CASE WHEN x.pagto = 'ATRASO MS ANT.'::text THEN sum(x.valor_pago) ELSE NULL::double precision END AS atraso FROM ( SELECT p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto, CASE
WHEN to_char(COALESCE(f.data_vencimento_original, f.data_vencimento)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MS ANT.'::text
ELSE 'NO MS'::text END AS pagto, p.codfatura FROM mk_plano_contas f JOIN mk_contas_faturadas ft ON f.codconta = ft.cd_conta JOIN mk_faturas p ON ft.cd_fatura = p.codfatura
WHERE f.tipo_conta = 'R'::bpchar AND f.nomenclatura_integracao in ('CNT','MAN') AND NOT f.meio_pgto = 6 AND f.liquidado = 'S'::bpchar AND f.valor_lancamento > 0::double precision AND
((substr(f.unidade_financeira::text, 1, 5) = ANY (ARRAY['03.01'::text, '03.04'::text, '03.06'::text])) OR ((substr(f.unidade_financeira,1,2) = '01' AND substr(f.unidade_financeira,1,5) not in ('01.10','01.11','01.12'))))
AND f.data_liquidacao between :data_i and :data_f GROUP BY p.vlr_liquidacao, f.data_liquidacao, ( CASE WHEN to_char(COALESCE(f.data_vencimento_original, f.data_vencimento)::timestamp with time zone, 'yyyymm'::text) < to_char(f.data_liquidacao::timestamp with time zone, 'yyyymm'::text) THEN 'ATRASO MS ANT.'::text
ELSE 'NO MS'::text END), p.codfatura) x  GROUP BY x.data_pagto, x.pagto ORDER BY x.data_pagto) tab GROUP BY (date_part('day'::text, tab.data_pagto)) ORDER BY (date_part('day'::text, tab.data_pagto))";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue("data_i", $dt_i);
        $sql->bindValue("data_f", $dt_f);
        $sql->execute();

        if($sql->rowCount() > 0){

            $this->array = $sql->fetchAll();
        }
    }

    public function dia(){

        $dia = array();

        foreach($this->array as $row){

            $dia[] = $row['data'];

        }
        return $dia;

    }

    public function no_Mes(){

        $no_mes = array();

        foreach($this->array as $row){

            $no_mes[] = $row['mes'];

        }
        return $no_mes;

    }

    public function somaMes(){

        $soma_mes = array();
        foreach ($this->array as $row ) {


            $soma_mes[] = $row['mes'];
        }
        $soma = array_sum($soma_mes);
        return $soma;
    }


    public function atraso(){

        $atraso = array();

        foreach($this->array as $row_atraso){

            $atraso[] = $row_atraso['atraso'];

        }
        return $atraso;
    }

    public function somaAtraso(){

        $soma_atraso = array();

        foreach ($this->array as $row ) {

            $soma_atraso[] = $row['atraso'];
        }
        $soma = array_sum($soma_atraso);
        return $soma;
    }

    public function acumulado(){
        $acu = 0;
        $acumulado = array();

        foreach($this->array as $row){

            $acumulado[] = ($acu + ($row['atraso'] + $row['mes']));
            $acu = ($acu + ($row['atraso'] + $row['mes']));
        }
        return $acumulado;
    }


    public function somaTotal(){

        $soma = array();

        if(!empty($this->array)) {
            foreach ($this->array as $row) {

                $soma[] = ($row['mes'] + $row['atraso']);

            }
            return array_sum($soma);
        }else{

            return $soma = 0;
        }
    }

    public function total(){

        $soma = array();

        foreach($this->array as $row){

            $soma[] = ($row['mes'] + $row['atraso']);

        }
        return $soma;
    }

    public function tipoRecebimento($dt_i, $dt_f){

        $fibra = array();
        $radio = array();
        $cabo = array();

        $sql = "SELECT s.nome_razaosocial as cliente, u.descricao as unidade, f.codfatura as Fatura, f.vlr_liquidacao as valor, case when substr(p.unidade_financeira,1,5) = '03.06' then 'FIBRA' when substr(p.unidade_financeira,1,5) = '03.04' then 'CABO' else 'RDIO/OUTROS' END AS tipo, p.data_liquidacao AS Dt_Pgto, CASE WHEN TO_CHAR(COALESCE(p.data_vencimento_original, p.data_vencimento),'yyyymm') < TO_CHAR(p.data_liquidacao,'yyyymm') THEN 'ATRASO MS ANT.' ELSE 'NO MS' END AS pagamento,
me.descricao_meio_pgto AS tipo_pgto, f.num_arq_retorno as retorno from mk_plano_contas p inner join mk_pessoas s on s.codpessoa = p.codcliente_codfornecedor inner join mk_meio_pgto me on me.codmeiopgto = p.meio_pgto
left join mk_unidade_financeia u on p.unidade_financeira = u.nomenclatura left join mk_contratos c on c.codcontrato = p.codvinculado inner join mk_contas_faturadas ft on p.codconta = ft.cd_conta inner join mk_faturas f on ft.cd_fatura = f.codfatura
where p.data_liquidacao BETWEEN :data_i AND :data_f and p.tipo_conta = 'R' and p.nomenclatura_integracao in ('CNT','MAN') AND NOT p.meio_pgto = 6 AND substr(p.unidade_financeira,1,5) in ('03.01','03.06','03.04') AND p.liquidado = 'S' and p.valor_lancamento > 0
order by cliente";

        $sql = $this->pdo->prepare($sql);
        $sql->bindValue("data_i", $dt_i);
        $sql->bindValue("data_f", $dt_f);
        $sql->execute();

        if($sql->rowCount() > 0){

            foreach ($sql->fetchAll() as $row){

                if($row['tipo'] == 'FIBRA'){

                    $fibra[] = $row['valor'];

                }else if($row['tipo'] == 'CABO'){

                    $cabo[] =  $row['valor'];
                }else{

                    $radio[] = $row['valor'];
                }

            }
            $this->fibra = array_sum($fibra);
            $this->cabo = array_sum($cabo);
            $this->radio = array_sum($radio);
        }
    }

    public function getTotalFibra(){


        return $this->fibra;

    }

    public function getTotalRadio(){


        return $this->radio;

    }

    public function getTotalCabo(){


        return $this->cabo;

    }

}



?>

