function busca() {

    //somente digitos
    var cep = $('.cep').val();

    if (cep != '') {

        $.ajax({
            type: "POST",
            url: './control/endereco/controle_disponibilidade.php',
            data: 'cep=' + cep,
            beforeSend: function () {
                $('#tabela').html('<div class="text-center"><br/><br/><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i><h2 class="animated slideInLeft">Carregando...</h2></div>');

            },
            success: function (data) {
                $('#tabela').html(data);
                $('#tabela_endereco').dataTable({
                    fixedHeader: !0,
                    responsive: true,
                    "lengthMenu": [[25, 50, 100, -1], [25, 50, 100, "All"]],
                    "order": [[0, "desc"]],
                    "columnDefs":[{"width": "15%", "targets": 8}]
                });
                $('[data-toggle="tooltip"]').tooltip();
            }
        });

    } else {
        toastr.error('Informe o CEP');
        $('.cep').focus();
        return false;
    }


    $('.cep').val('');
    $('.cep').focus();


}

function inserir(id) {

    $('#modal-editar').modal('show');
    $.ajax({

        type: 'POST',
        url: './control/endereco/controle_disponibilidade.php?p=inserir',
        data: 'id=' + id,
        beforeSend: function () {
            $('#modal-editar').find('.modal-body').find('#editar_cobertura').html('Carregando ....');
            $('#modal-editar').modal('show');
        },
        success: function (html) {
            $('#modal-editar').find('#editar_cobertura').html(html);
            $('#modal-editar').find('.modal-body').find('form').on('submit', salvar_inserir);

        }
    });
}

function salvar_inserir(e) {

    e.preventDefault();

    var data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './control/endereco/controle_disponibilidade.php?p=salvar_inserir',
        data: data,
        success: function (data) {

            if (data == 0) {
                toastr.success('Inserido com Sucesso');
                $('#modal-editar').modal('hide');
                window.location.reload();

            } else {
                toastr.warning('CEP não localizado na base');

            }
        }
    });
}



function editar(id,id2) {

    $('#modal-editar').modal('show');
    $.ajax({

        type: 'POST',
        url: './control/endereco/controle_disponibilidade.php?p=editar',
        data: {'id':id ,'id2':id2},
        beforeSend: function () {
            $('#modal-editar').find('.modal-body').find('#editar_cobertura').html('Carregando ....');
            $('#modal-editar').modal('show');
        },
        success: function (html) {
            $('#modal-editar').find('#editar_cobertura').html(html);
            $('#modal-editar').find('.modal-body').find('form').on('submit', salvar);

        }
    });
}

function deletar(id) {

    $('#modal-deletar').modal('show');
    $.ajax({
        type: "POST",
        url: "./control/endereco/controle_disponibilidade.php?p=delete",
        data: 'id=' + id,
        success: function (html) {
            $('#modal-deletar').find('#deletar_cobertura').html(html);
            $('#modal-deletar').find('.modal-body').find('form').on('submit', salvar_delete);

        }
    });
}

function salvar_delete(e) {

    e.preventDefault();

    var data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './control/endereco/controle_disponibilidade.php?p=excluir',
        data: data,
        success: function (data) {

            if (data == 0) {
                toastr.success('Deletado com Sucesso');
                $('#modal-deletar').modal('hide');
                window.location.reload();

            } else {
                toastr.warning('Não foi possível deletar');

            }
        }
    });
}

function salvar(e) {

    e.preventDefault();

    var data = $(this).serialize();

    $.ajax({

        type: 'POST',
        url: './control/endereco/controle_disponibilidade.php?p=salvar',
        data: data,
        success: function (data) {

            if (data == 0) {
                toastr.success('Atualizado com Sucesso');
                $('#modal-editar').modal('hide');
                window.location.reload();

            } else {
                toastr.warning('CEP não localizado na base');

            }
        }
    });
}

