<?php

class Vendas
{

    private $pdo;
    private $vendas;
    private $mes;
    private $ano;
    private $semana;
    private $vendasResumo;
    private $total;


    public function __construct()
    {
        $dsn = "pgsql:dbname=mkData;host=177.107.72.12";
        $db_usuario = "cliente_r";
        $db_password = "Cl13nt_R";

        try {

            $this->pdo = new PDO($dsn, $db_usuario, $db_password);

        } catch (PDOException $e) {

            echo "Falha na Conexao com o Banco de Dados: " . $e->getMessage();
        }
    }

    public function vendas_Sucesso($dt_i, $dt_f)
    {

        $array = array();

        $dt_i = date('d-m-Y', $dt_i);
        $dt_f = date('d-m-Y', $dt_f);

        $sql = "select count (*) As quantidade from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc
left join mk_os_tipo t on mk_os.tipo_os = t.codostipo left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato
left join mk_pessoas p on p.codpessoa = mk_os.cliente where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc = 1 and mk_os.data_fechamento BETWEEN :data_i and :data_f";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue(':data_i', $dt_i);
        $sql->bindValue(':data_f', $dt_f);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                $array[] = $row['quantidade'];

            }

            $this->vendas = array_sum($array);

        }
    }


    public function vendasAnual()
    {

        $mes = array();
        $ano = array();
        $total = array();

        $sql = "Select '' || Case When Date_Part('month', mk_os.data_fechamento) = 01 Then 'Janeiro' When Date_Part('month', mk_os.data_fechamento) = 02 Then 'Fevereiro'
   When Date_Part('month', mk_os.data_fechamento) = 03 Then 'Março'   When Date_Part('month', mk_os.data_fechamento) = 04 Then 'Abril'
   When Date_Part('month', mk_os.data_fechamento) = 05 Then 'Maio'   When Date_Part('month', mk_os.data_fechamento) = 06 Then 'Junho'
   When Date_Part('month', mk_os.data_fechamento) = 07 Then 'Julho'   When Date_Part('month', mk_os.data_fechamento) = 08 Then 'Agosto'
   When Date_Part('month', mk_os.data_fechamento) = 09 Then 'Setembro'   When Date_Part('month', mk_os.data_fechamento) = 10 Then 'Outubro'
   When Date_Part('month', mk_os.data_fechamento) = 11 Then 'Novembro'   When Date_Part('month', mk_os.data_fechamento) = 12 Then 'Dezembro'
End || '' As mes, '' || '' || Date_Part('year', mk_os.data_fechamento) || '' as ano, '' || count(*)  || '' As quantidade from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc
left join mk_os_tipo t on mk_os.tipo_os = t.codostipo left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato
left join mk_pessoas p on p.codpessoa = mk_os.cliente where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc in (1) and mk_os.data_fechamento between (date_trunc('month', current_date) - interval '1 year') and (date_trunc('day', current_date))
Group By Date_Part('month', mk_os.data_fechamento), Date_Part('year', mk_os.data_fechamento) Order By Date_Part('year', mk_os.data_fechamento) , cast(Date_Part('month', mk_os.data_fechamento) as integer)";
        $sql = $this->pdo->prepare($sql);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                $mes[] = $row['mes'];
                $ano[] = $row['ano'];
                $total[] = $row['quantidade'];
            }

            $this->mes = $mes;
            $this->ano = $ano;
            $this->total = $total;
        }
    }

    public function vendasSemanal()
    {

        $semana = array();
        $total = array();

        $sql = "select '' || Case When to_char(mk_os.data_fechamento, 'D') = 1 Then 'Domingo' When to_char(mk_os.data_fechamento, 'D') = 2 Then 'Segunda' When to_char(mk_os.data_fechamento, 'D') = 3 Then 'Terça'
When to_char(mk_os.data_fechamento, 'D') = 4 Then 'Quarta' When to_char(mk_os.data_fechamento, 'D') = 5 Then 'Quinta' When to_char(mk_os.data_fechamento, 'D') = 6 Then 'Sexta'
When to_char(mk_os.data_fechamento, 'D') = 7 Then 'Sábado' END || '' as semana, '' || count(*)  || '' As quantidade from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc
left join mk_os_tipo t on mk_os.tipo_os = t.codostipo left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato
left join mk_pessoas p on p.codpessoa = mk_os.cliente where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc in (1) and mk_os.data_fechamento between CURRENT_DATE - interval '7 days' and CURRENT_DATE
group by semana, mk_os.data_fechamento order by mk_os.data_fechamento";
        $sql = $this->pdo->prepare($sql);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                $semana[] = $row['semana'];
                $total[] = $row['quantidade'];

            }
            $this->semana = $semana;
            $this->total = $total;

        }
    }

    public function vendasAnualCanceladas()
    {

        $total = array();

        $sql = "Select '' || Case When Date_Part('month', mk_os.data_fechamento) = 01 Then 'Janeiro' When Date_Part('month', mk_os.data_fechamento) = 02 Then 'Fevereiro'
   When Date_Part('month', mk_os.data_fechamento) = 03 Then 'Março'   When Date_Part('month', mk_os.data_fechamento) = 04 Then 'Abril'
   When Date_Part('month', mk_os.data_fechamento) = 05 Then 'Maio'   When Date_Part('month', mk_os.data_fechamento) = 06 Then 'Junho'
   When Date_Part('month', mk_os.data_fechamento) = 07 Then 'Julho'   When Date_Part('month', mk_os.data_fechamento) = 08 Then 'Agosto'
   When Date_Part('month', mk_os.data_fechamento) = 09 Then 'Setembro'   When Date_Part('month', mk_os.data_fechamento) = 10 Then 'Outubro'
   When Date_Part('month', mk_os.data_fechamento) = 11 Then 'Novembro'   When Date_Part('month', mk_os.data_fechamento) = 12 Then 'Dezembro'
End || '' As mes, '' || '' || Date_Part('year', mk_os.data_fechamento) || '' as ano, '' || count(*)  || '' As quantidade from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc
left join mk_os_tipo t on mk_os.tipo_os = t.codostipo left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato
left join mk_pessoas p on p.codpessoa = mk_os.cliente where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc in (8,52,59,66,67) and mk_os.data_fechamento between (date_trunc('day', current_date) - interval '1 year') and (date_trunc('day', current_date))
Group By Date_Part('month', mk_os.data_fechamento), Date_Part('year', mk_os.data_fechamento) Order By Date_Part('year', mk_os.data_fechamento) , cast(Date_Part('month', mk_os.data_fechamento) as integer)";
        $sql = $this->pdo->prepare($sql);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                $total[] = $row['quantidade'];
            }

            $this->total = $total;
        }
    }

    public function vendassemanalCanceladas()
    {

        $semana_can = array();
        $total = array();

        $sql = "select '' || Case When to_char(mk_os.data_fechamento, 'D') = 1 Then 'Domingo' When to_char(mk_os.data_fechamento, 'D') = 2 Then 'Segunda' When to_char(mk_os.data_fechamento, 'D') = 3 Then 'Terça'
  When to_char(mk_os.data_fechamento, 'D') = 4 Then 'Quarta' When to_char(mk_os.data_fechamento, 'D') = 5 Then 'Quinta' When to_char(mk_os.data_fechamento, 'D') = 6 Then 'Sexta'
  When to_char(mk_os.data_fechamento, 'D') = 7 Then 'Sábado' END || '' as semana, '' || count(*)  || '' As quantidade from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc
left join mk_os_tipo t on mk_os.tipo_os = t.codostipo left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato
left join mk_pessoas p on p.codpessoa = mk_os.cliente where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc in (8,52,59,66,67) and mk_os.data_fechamento between CURRENT_DATE - interval '7 days' and CURRENT_DATE
group by semana, mk_os.data_fechamento order by mk_os.data_fechamento";

        $sql = $this->pdo->prepare($sql);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            foreach ($sql->fetchAll() as $row) {

                $semana_can[] = $row['semana'];
                $total[] = $row['quantidade'];
            }
            $this->semana = $semana_can;
            $this->total = $total;
        }

    }

    public function vendasRadioFibra()
    {

        $sql = "select count (*) As quantidade, case when substr(c.unidade_financeira::text, 1,8) = '03.02.06' then 'Fibra Comercial' else 'Rádio Comercial' end as tipo
from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc left join mk_os_tipo t on mk_os.tipo_os = t.codostipo 
left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato left join mk_pessoas p on p.codpessoa = mk_os.cliente
where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc = 1 and substr(c.unidade_financeira::text, 1,5) = '03.02' and
mk_os.data_fechamento between (date_trunc('month', current_date)) and ((date_trunc('month', current_date) + interval ' 1 month') - interval '1 day') group by tipo
UNION
select count (*) As quantidade, case when substr(c.unidade_financeira::text,1,8) = '03.03.13' then 'Fibra Empresarial' when substr(c.unidade_financeira::text,1,8) = '03.03.14' then 'Fibra Empresarial'
when substr(c.unidade_financeira::text,1,8) = '03.03.15' then 'Fibra Empresarial' else 'Rádio Empresarial' end as tipo from mk_os 
left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc left join mk_os_tipo t on mk_os.tipo_os = t.codostipo 
left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato left join mk_pessoas p on p.codpessoa = mk_os.cliente
where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc = 1 and substr(c.unidade_financeira::text, 1,5) = '03.03' and
mk_os.data_fechamento between (date_trunc('month', current_date)) and ((date_trunc('month', current_date) + interval ' 1 month') - interval '1 day') group by tipo
UNION
select count (*) As quantidade, case when substr(c.unidade_financeira::text, 1,5) = '03.04' then 'Cable' end as tipo from mk_os 
left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc left join mk_os_tipo t on mk_os.tipo_os = t.codostipo 
left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato left join mk_pessoas p on p.codpessoa = mk_os.cliente
where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc = 1 and substr(c.unidade_financeira::text, 1,5) = '03.04' and mk_os.data_fechamento
between (date_trunc('month', current_date)) and ((date_trunc('month', current_date) + interval ' 1 month') - interval '1 day') group by tipo
UNION
select count (*) As quantidade, case when substr(c.unidade_financeira::text, 1,5) = '03.01' then 'Rádio Residencial' when substr(c.unidade_financeira::text, 1,5) = '03.06' then 'Fibra Residencial' end as tipo
from mk_os left join mk_os_classificacao_encerramento e on mk_os.classificacao_encerramento = e.codclassifenc left join mk_os_tipo t on mk_os.tipo_os = t.codostipo 
left join mk_conexoes x on x.codconexao = conexao_associada left join mk_contratos c on c.codcontrato = x.contrato left join mk_pessoas p on p.codpessoa = mk_os.cliente
where mk_os.tipo_os = 1 and p.classificacao = 1 and e.codclassifenc = 1 and substr(c.unidade_financeira::text, 1,5) in ('03.01','03.06') and
mk_os.data_fechamento between (date_trunc('month', current_date)) and ((date_trunc('month', current_date) + interval ' 1 month') - interval '1 day') group by tipo order by tipo";
        $sql = $this->pdo->prepare($sql);
        $sql->execute();
        if ($sql->rowCount() > 0) {

            $this->vendasResumo = $sql->fetchAll();
        }
    }

    public function getVendasRadioFibra()
    {

        return $this->vendasResumo;
    }

    public function getVendas_Sucesso()
    {

        return $this->vendas;
    }

    public function getMes()
    {

        return $this->mes;
    }

    public function getSemana()
    {

        return $this->semana;
    }

    public function getAno()
    {

        return $this->ano;
    }

    public function getotal()
    {

        return $this->total;
    }


}

?>