<?php

class Empresarial{

    private $pdo;
    private $array;
    private $fibra;
    private $radio;



    public function __construct(){

        {
            $dsn = "pgsql:dbname=mkData;host=177.107.72.12";
            $db_usuario = "cliente_r";
            $db_password = "Cl13nt_R";

            try {

                $this->pdo = new PDO($dsn, $db_usuario, $db_password);

            } catch (PDOException $e) {

                echo "Falha na Conexao com o Banco de Dados: " . $e->getMessage();
            }
        }

    }


    public function query($dt_i, $dt_f){

        $sql = "select date_Part('day',tab.data_pagto) as data, sum(tab.no_mes) as mes, sum(tab.atraso) as atraso from (select x.data_pagto, case when x.pagto = 'NO MS' then sum(x.valor_pago) end as no_mes,
case when x.pagto = 'ATRASO MS ANT.' then sum(x.valor_pago) end as atraso from (select p.vlr_liquidacao AS valor_pago, f.data_liquidacao AS data_pagto,CASE WHEN TO_CHAR(COALESCE(f.data_vencimento_original, f.data_vencimento),'yyyymm') < TO_CHAR(f.data_liquidacao,'yyyymm')
THEN 'ATRASO MS ANT.' ELSE 'NO MS' END AS pagto FROM mk_plano_contas f inner join mk_contas_faturadas ft on f.codconta = ft.cd_conta inner join mk_faturas p on ft.cd_fatura = p.codfatura WHERE f.tipo_conta = 'R' and f.nomenclatura_integracao in ('CNT','MAN') AND f.liquidado = 'S' and not f.meio_pgto = 6 and f.valor_lancamento > 0
AND (substr(f.unidade_financeira,1,5) = '03.03' OR (substr(f.unidade_financeira,1,5) in ('01.10','01.11','01.12'))) AND f.data_liquidacao between :data_i and :data_f)x
group by x.data_pagto, x.pagto order by x.data_pagto)tab group by data Order by data";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue("data_i", $dt_i);
        $sql->bindValue("data_f", $dt_f);
        $sql->execute();

        if($sql->rowCount() > 0){

            $this->array = $sql->fetchAll();
        }
    }

    public function somaTotal(){

        $soma = array();

        if(!empty($this->array)) {
            foreach ($this->array as $row) {

                $soma[] = ($row['mes'] + $row['atraso']);

            }
            return array_sum($soma);
        }else{

            return $soma = 0;
        }
    }

    public function total(){

         $soma = array();

        if(!empty($this->array)){

        foreach($this->array as $row){

            $soma[] = array("valor" => $row['mes'] + $row['atraso'], "dia"=> $row['data']);

        }
            return $soma;
    }else{

        return $soma = null;
        }
    }

    public function tipoRecebimento($dt_i, $dt_f){

        $fibra = array();
        $radio = array();

        $sql = "SELECT s.nome_razaosocial as cliente, u.descricao as unidade, f.codfatura as Fatura, f.vlr_liquidacao as valor, case when substr(p.unidade_financeira,1,8) in ('03.03.13','03.03.14','03.03.15') then 'FIBRA' when substr(p.unidade_financeira,1,8) is null then 'SEM UNIDADE'
else 'RDIO/OUTROS' END AS tipo, p.data_liquidacao AS Dt_Pgto, CASE WHEN TO_CHAR(COALESCE(p.data_vencimento_original, p.data_vencimento),'yyyymm') < TO_CHAR(p.data_liquidacao,'yyyymm') THEN 'ATRASO MS ANT.' ELSE 'NO MS' END AS pagamento,
me.descricao_meio_pgto AS tipo_pgto, f.num_arq_retorno as retorno from mk_plano_contas p inner join mk_pessoas s on s.codpessoa = p.codcliente_codfornecedor inner join mk_meio_pgto me on me.codmeiopgto = p.meio_pgto
left join mk_unidade_financeia u on p.unidade_financeira = u.nomenclatura left join mk_contratos c on c.codcontrato = p.codvinculado inner join mk_contas_faturadas ft on p.codconta = ft.cd_conta inner join mk_faturas f on ft.cd_fatura = f.codfatura
where p.data_liquidacao BETWEEN :data_i AND :data_f and p.tipo_conta = 'R' and p.nomenclatura_integracao in ('CNT','MAN') AND (substr(p.unidade_financeira,1,5) = '03.03' OR (substr(p.unidade_financeira,1,5) in ('01.10','01.11','01.12'))) AND p.liquidado = 'S' and not f.meio_pgto = 6 and p.valor_lancamento > 0
order by cliente";

        $sql = $this->pdo->prepare($sql);
        $sql->bindValue("data_i", $dt_i);
        $sql->bindValue("data_f", $dt_f);
        $sql->execute();

        if($sql->rowCount() > 0){

            foreach ($sql->fetchAll() as $row){

                if($row['tipo'] == 'FIBRA'){

                    $fibra[] = $row['valor'];

                }else{

                    $radio[] =  $row['valor'];
                }

            }
             $this->fibra = array_sum($fibra);
            $this->radio = array_sum($radio);
        }
    }

    public function getTotalFibra(){


        return $this->fibra;

    }

    public function getTotalRadio(){


        return $this->radio;

    }
}



?>

