<?php

class Disponibilidade_fibra
{


    private $pdo;
    private $disponibilidade;
    private $array;
    private $status;


    public function __construct()
    {

        try {
            $this->pdo = new PDO("mysql:dbname=redenilf_fibra;host=177.107.64.7", "redenilf_reports", "187982774");

        } catch (PDOException $e) {

            echo "Conexao com o BD Falhou: " . $e->getMessage();
        }
    }

    public function carregaDisponibilidade_cep($cep)
    {


        $sql = "SELECT l.id_logradouro, l.cep, l.logradouro, disp.inicio, disp.fim, b.bairro, c.cidade, disp.id as id_disponibilidade, e.estado, case when st.status is null then 'Indisponível' else st.status end as status FROM endereco l 
left join bairro b on l.cod_bairro = b.id_bairro left join cidade c on b.cod_cidade = c.id_cidade left join uf e on c.cod_estado = e.id_estado left join disponibilidade disp on disp.cod_logradouro = l.id_logradouro
left join status st on disp.cod_status = st.id_status where l.cep = :cep";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue('cep', $cep);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->disponibilidade = $sql->fetchAll();

        } else {

            $this->disponibilidade = null;
        }

    }

    public function carregaDisponibilidade_id($id)
    {


        $sql = "SELECT l.id_logradouro, l.cep, l.logradouro, disp.inicio, disp.fim, b.bairro, c.cidade, disp.id as id_disponibilidade, e.estado, case when st.status is null then 'Indisponível' else st.status end as status FROM endereco l 
left join bairro b on l.cod_bairro = b.id_bairro left join cidade c on b.cod_cidade = c.id_cidade left join uf e on c.cod_estado = e.id_estado left join disponibilidade disp on disp.cod_logradouro = l.id_logradouro
left join status st on disp.cod_status = st.id_status where disp.id = :id";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->disponibilidade = $sql->fetchAll();

        } else {

            $this->disponibilidade = null;
        }

    }

    public function carregaDisponibilidade_logradouro($id)
    {


        $sql = "SELECT l.id_logradouro, l.cep, l.logradouro, disp.inicio, disp.fim, b.bairro, c.cidade, disp.id as id_disponibilidade, e.estado, case when st.status is null then 'Indisponível' else st.status end as status FROM endereco l 
left join bairro b on l.cod_bairro = b.id_bairro left join cidade c on b.cod_cidade = c.id_cidade left join uf e on c.cod_estado = e.id_estado left join disponibilidade disp on disp.cod_logradouro = l.id_logradouro
left join status st on disp.cod_status = st.id_status where l.id_logradouro = :id";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->disponibilidade = $sql->fetchAll();

        } else {

            $this->disponibilidade = null;
        }

    }



    public function buscalogradouro_CEP($cep)
    {

        $sql = 'select e.logradouro, b.bairro, c.cidade, u.estado from endereco e inner join bairro b on e.cod_bairro = b.id_bairro
                                                                                  inner join cidade c on b.cod_cidade = c.id_cidade
                                                                                  inner join uf u on c.cod_estado = u.id_estado where e.cep = :cep';
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue('cep', $cep);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->array = $sql->fetchAll();
            return $this->array;
        } else {

            $this->array = null;
            return $this->array;
        }
    }

    public function getStatus()
    {


        $sql = 'select * from status';
        $sql = $this->pdo->prepare($sql);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->status = $sql->fetchAll();
            return $this->status;
        } else {
            echo "Invalid query";
        }
    }


    public function getDisponibilidade()
    {

        return $this->disponibilidade;
    }

    public function editarDisponibilidade($id, $id_logradouro, $nume_ini, $numero_fim, $st)
    {

        $sql = "UPDATE disponibilidade set cod_logradouro = ?, inicio = ?, fim = ?, cod_status = ? WHERE id = ?";
        $sql = $this->pdo->prepare($sql);
        $sql->execute(array(
            $id_logradouro,
            $nume_ini,
            $numero_fim,
            $st,
            $id
        ));

        if ($sql->rowCount() > 0) {

            return 0;

        } else {

            return 1;
        }

    }

    public function inserirDisponibilidade($id, $num_i, $num_f, $st)
    {

        $sql = "INSERT INTO disponibilidade set cod_logradouro = ?, inicio = ?, fim = ?, cod_status = ? ";
        $sql = $this->pdo->prepare($sql);
        $sql->execute(array(
            $id,
            $num_i,
            $num_f,
            $st
        ));

        if ($sql->rowCount() > 0) {

            return 0;

        } else {

            return 1;
        }

    }


    public function deletar_disponibilidade($id)
    {

        $sql = "DELETE from disponibilidade where id = :id";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue("id", $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {


            return 0;
        } else {

            return 1;
        }

    }

}

?>