function novoEndereco() {

    $('#modal-endereco').modal('show');
    $('#modal-endereco').on('shown.bs.modal', function () {
        $('.estado_novo').attr('disabled', 'disabled');
        $('.cidade_novo').attr('disabled', 'disabled');
        $('.bairro_novo').attr('disabled', 'disabled');
        $('.endereco_novo').attr('disabled', 'disabled');
        $('.btn-salvar_endereco').attr('disabled', 'disabled');
    });

    $('#modal-endereco').find('.modal-body').find('form').on('submit', inserir_end);
    $('#modal-endereco').on('hidden.bs.modal', function () {
        // do something?

        window.location.reload();
    });
}

function buscacep() {

    var cep = $('.cep_endereco').val();

    if (cep != '') {

        cep = cep.replace(/\D/g, ''); //exiber somente numeros
        var validacep = /^[0-9]{8}$/; //valida cep
        if (validacep.test(cep)) {
            $.ajax({

                type: 'POST',
                url: 'control/endereco/controle_endereco.php?p=busca',
                data: 'cep=' + cep,
                success: function (data) {

                    if (data == 1) {
                        toastr.options.tapToDismiss = false;
                        toastr.options.timeOut = 0;
                        toastr.options.extendedTimeout = 0;
                        toastr.options.preventDuplicates = true;
                        toastr.info("Este CEP ja existe, deseja continuar mesmo assim?<br/><br/><button type='button' onclick='carregar_dados()' class='btn btn-info btn-sm'>Sim</button>");
                    } else {
                        carregar_dados();
                    }
                }

            });
        } else {
            toastr.warning("Digite um CEP Valido");
        }
    } else {
        toastr.warning('Digite um CEP');
    }

}

function inserir_end(e) {

    var cep = $('.cep_endereco').val();

    e.preventDefault();
    var dados = $(this).serialize();

    if ($('.estado_novo').val() == '') {

        toastr.warning('Insira o Estado');
        return false;

    }
    if ($('.cidade_novo').val() == '') {

        toastr.warning('Insira a Cidade');
        return false;

    }
    if ($('.bairro_novo').val() == '') {

        toastr.warning('Insira o Bairro');
        return false;

    }

    $.ajax({

        type: 'POST',
        url: 'control/endereco/controle_endereco.php?p=inserir',
        data: dados+'&cep='+cep,
        success: function (data) {

            if (data == 0) {

                toastr.success("Inserido com Sucesso");
                $('#modal-endereco').modal('hide');

            } else {
                toastr.error('Nao Inserido, contate o Administrador');
                $('#modal-endereco').modal('hide');
            }
        }
    });
}

function carregar_dados() {

    //$('.cep_endereco').val()
    $('.estado_novo').removeAttr('disabled');
    $('.cidade_novo').removeAttr('disabled');
    $('.bairro_novo').removeAttr('disabled');
    $('.endereco_novo').removeAttr('disabled');
    $('.btn-salvar_endereco').removeAttr('disabled');
    $('.estado_novo').html('<option value="">Selecione o Estado</option>');
    $('.cidade_novo').html('<option value="">Selecione a Cidade</option>');
    $('.bairro_novo').html('<option value="">Selecione o Bairro</option>');


    $.ajax({
        type: 'GET',
        dataType: 'JSON',
        url: 'control/endereco/controle_endereco.php',
        success: function (data) {
            var result = data;
            $.each(result, function (key, value) {
                $('.estado_novo').append("<option value=" + value.id_estado + ">" + value.estado + "</options>");
            });
        }
    });

    $('.estado_novo').change(function () {
        var estado = '';
        $('.cep_endereco').attr('disabled', 'disabled');
        $('.cidade_novo').html('<option value="">Selecione a Cidade</option>');
        $('.bairro_novo').html('<option value="">Selecione o Bairro</option>');
        $('.estado_novo option:selected').each(function () {
            estado = $(this).val();
        });
        if (estado != '') {
            $.ajax({
                type: 'POST',
                data: 'id_estado=' + estado,
                dataType: 'JSON',
                url: 'control/endereco/controle_endereco.php?p=id_estado',
                success: function (data) {
                    var result = data;
                    $.each(result, function (key, value) {
                        $('.cidade_novo').append("<option value=" + value.id_cidade + ">" + value.cidade + "</options>");
                    });
                }
            });
        } else {
            $('.estado_novo').html('<option value="">Selecione o Estado</option>');
        }
    }).change();

    $('.cidade_novo').change(function () {
        var cidade = '';
        $('.bairro_novo').html('<option value="">Selecione o Bairro</option>');
        $('.cidade_novo option:selected').each(function () {
            cidade = $(this).val();
            $.ajax({
                type: 'POST',
                data: 'id_cidade=' + cidade,
                dataType: 'JSON',
                url: 'control/endereco/controle_endereco.php?p=id_cidade',
                success: function (data) {
                    var result = data;
                    $.each(result, function (key, value) {
                        $('.bairro_novo').append("<option value=" + value.id_bairro + ">" + value.bairro + "</options>");
                    });
                }
            });
        })
    });
}

function novoBairro() {

    $('#modal-bairro').modal('show');
    $.ajax({
        type: 'GET',
        url: 'control/endereco/controle_endereco.php?p=novobairro',
        success: function (data) {

            $('#result_bairro').html(data);
            $('#modal-bairro').find('.modal-body').find('#result_bairro').find('form').on('submit', inserir_bairro);

        }
    });
}

function inserir_bairro(e) {

    e.preventDefault();

    if ($('.cidade_new').val() == ''){

        toastr.warning('Informe uma Cidade');
        return false;
    } else {
        var data = $(this).serialize();

        $.ajax({

            type: 'POST',
            url: 'control/endereco/controle_endereco.php?p=inserirbairro',
            data: data,
            success: function (data) {

                if (data == 0) {
                    toastr.success('Inserido com Sucesso');
                    $('#modal-bairro').modal('hide');
                    //window.location.reload();

                } else {
                    toastr.warning('Não foi possível inserir');

                }
            }
        });
    }
}