function listainconsistencia_jur() {

    $.ajax({
        type: "GET",
        url: 'control/posvenda/controle_inconsistencia_jur.php',
        beforeSend: function () {

            $('#preloading-table-juridico').html('<div class="text-center"><br/><br/><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i><h2 class="animated slideInLeft">Carregando...</h2></div>');


        },
        success: function (data) {
            $.fn.dataTable.moment("DD/MM/YYYY");
            $('#preloading-table-juridico').html(data);
            $('#tabela_inconsistencia_jur').dataTable({
                fixedHeader: !0,
                keys: !0, "lengthMenu": [[20, -1], [20, "ALL"]],
                "order": [[0, "desc"]]
            });
            $('[data-toggle="tooltip"]').tooltip();
        }
    });
}

function editar_inc_jur(id) {

    $('#modal-geral').modal('show');


    $.ajax({
        type: "POST",
        url: "control/posvenda/controle_inconsistencia_jur.php?p=edit",
        data: 'id=' + id,
        beforeSend: function () {
            $('#modal-geral').find('.modal-body').html('Carregando ....');
            $('#modal-geral').modal('show');
        },
        success: function (html) {

            $('#modal-geral').find('.resultado').html(html);
            var $adesao = $('#adesao'), $datacartao = $('#datacartao'), $valorcartao = $('#valorcartao'),
                $avista = $('#avista'), $tipo_boleto = $('#tipo-boleto'), $classificacao = $('#classificacao');
            $adesao.change(function () {

                if ($adesao.val() == 'CARTAO') {

                    $datacartao.css('display', 'block');
                    $valorcartao.css('display', 'block');
                    $avista.css('display', 'none');
                    $tipo_boleto.css('display', 'none');
                    $('#datacartao input').datepicker({
                        language: "pt-BR",
                        format: "dd/mm/yyyy",
                        todayHighlight: true
                    });
                    $('.valor').mask('#.##0,00', {reverse: true});
                    $('#status-boleto').val('');
                    $('#tipo_boleto').val('');

                } else if ($adesao.val() == 'BOLETO') {

                    $datacartao.css('display', 'none');
                    $valorcartao.css('display', 'none');
                    $tipo_boleto.css('display', 'block');
                    $('#dt-cartao').val('');
                    $('#cartao').val('');
                    if ($('#tipo_boleto').val() == 'A VISTA') {
                        $avista.css('display', 'block');
                    }
                    $tipo_boleto.change(function () {
                        if ($('#tipo_boleto').val() == '') {
                            $avista.css('display', 'none');
                            $('#status-boleto').val('');
                        } else if ($('#tipo_boleto').val() == 'A PRAZO') {
                            $avista.css('display', 'none');
                        } else {
                            $avista.css('display', 'block');
                        }
                    });

                } else {
                    $datacartao.css('display', 'none');
                    $valorcartao.css('display', 'none');
                    $avista.css('display', 'none');
                    $tipo_boleto.css('display', 'none');
                    $('#status-boleto').val('');
                    $('#tipo_boleto').val('');
                    $('#dt-cartao').val('');
                    $('#cartao').val('');


                }

            }).trigger('change');
            $('#modal-geral').find('.resultado').find('.modal-body').find('form').on('submit', salvar_jur);
            $('#modal-geral').modal('show');
            $('#teste').multiselect();

        }
    });
}

function salvar_jur(e) {

    e.preventDefault();

    var data = $(this).serialize();
    var check = [];
    $('.getvalor').each(function () {

        if ($(this).is(":checked")) {
            check.push($(this).val());
        }

    });
    check = check.toString();
    if ($('#adesao').val() == '' && $('#posvenda').val() == 'SIM') {

        toastr.error('Informe o tipo da Adeso');
        $('#adesao').focus();
        return false;
    }
    if ($('#adesao').val() == 'BOLETO' && $('#tipo_boleto').val() == '') {

        toastr.warning('Informe o tipo do Boleto');
        $('#tipo_boleto').focus();
        return false;
    }
    if ($('#tipo_boleto').val() == 'A VISTA' && $('#status-boleto').val() == '') {

        toastr.warning('Informe se o boleto foi pago');
        $('#tipo_boleto').focus();
        return false;
    }

    if ($('#classificacao').val() == '' && $('#posvenda').val() == 'SIM') {

        toastr.warning('Informe a Origem da Venda');
        $('#classificacao').focus();
        return false;
    }

    if ($('#status-boleto').val() == 'NAO' && $('#status').val() == 'CONCLUIDO') {

        toastr.warning('Cliente no Pagou a Parcela a Vista');
        return false;
    }

    if ($('#posvenda').val() == 'NAO' && $('#status').val() == 'CONCLUIDO') {

        toastr.warning('Ps-Venda no Concludo');
        return false;
    }

    $.ajax({

        type: 'POST',
        url: 'control/posvenda/controle_inconsistencia_jur.php?p=salve',
        data: data + '&tipo=' + check,
        success: function () {

            toastr.success('Atualizado com Sucesso');

            $('#modal-geral').modal('hide');

        }

    });

    $("#tabela_inconsistencia_jur").dataTable().fnDestroy();

    listainconsistencia_jur();
}