function listainconsistencia() {

    $.ajax({
        type: "GET",
        url: 'control/posvenda/controle_inconsistencia.php',
        beforeSend: function () {

            $('#preloading-table').html('<div class="text-center"><br/><br/><i class="fa fa-spinner fa-pulse fa-3x fa-fw"></i><h2 class="animated slideInLeft">Carregando...</h2></div>');


        },
        success: function (data) {
            $.fn.dataTable.moment("DD/MM/YYYY");
            $('#preloading-table').html(data);
            $('#tabela_inconsistencia').dataTable({
                fixedHeader: !0,
                keys: !0,
                "lengthMenu": [[20, 50, 100, -1], [20, 50, 100, "Todos"]],
                "order": [[0, "desc"]],
            });
            $('[data-toggle="tooltip"]').tooltip();
        }
    });

}

function editar_inc(id) {

    $('#modal-geral').modal('show');


    $.ajax({
        type: "POST",
        url: "control/posvenda/controle_inconsistencia.php?p=edit",
        data: 'id=' + id,
        beforeSend: function () {
            $('#modal-geral').find('.modal-body').html('Carregando ....');
            $('#modal-geral').modal('show');
        },
        success: function (html) {

            $('#modal-geral').find('.resultado').html(html);
            var $adesao = $('#adesao'), $datacartao = $('#datacartao'), $valorcartao = $('#valorcartao'),
                $avista = $('#avista'), $classificacao = $('#classificacao'), $consultor = $('#consultor');

            if ($classificacao.val() === '7') {

                $consultor.css('display', 'block');
            } else {

                $consultor.css('display', 'none');
                $('#select-consultor').val('');

            }
            $adesao.change(function () {

                if ($adesao.val() == 'CARTAO') {

                    $datacartao.css('display', 'block');
                    $valorcartao.css('display', 'block');
                    $avista.css('display', 'none');
                    $('#datacartao input').datepicker({
                        language: "pt-BR",
                        format: "dd/mm/yyyy",
                        todayHighlight: true
                    });
                    $('.valor').mask('#.##0,00', {reverse: true});
                    $('#status-boleto').val('');

                } else if ($adesao.val() == 'BOLETO') {

                    $datacartao.css('display', 'none');
                    $valorcartao.css('display', 'none');
                    $avista.css('display', 'block');
                    $('#dt-cartao').val('');
                    $('#cartao').val('');

                } else {
                    $datacartao.css('display', 'none');
                    $valorcartao.css('display', 'none');
                    $avista.css('display', 'none');
                    $('#status-boleto').val('');
                    $('#dt-cartao').val('');
                    $('#cartao').val('');


                }

            }).trigger('change');

            $classificacao.change(function () {

                if ($classificacao.val() === '7') {

                    $consultor.css('display', 'block');

                } else {

                    $consultor.css('display', 'none');
                    $('#select-consultor').val('');

                }

            }).trigger('change');
            $('#modal-geral').find('.resultado').find('.modal-body').find('form').on('submit', salvar);
            $('#modal-geral').modal('show');
            $('#teste').multiselect();

        }
    });
}

function salvar(e) {

    e.preventDefault();

    var data = $(this).serialize();
    var check = [];
    $('.getvalor').each(function () {

        if ($(this).is(":checked")) {
            check.push($(this).val());
        }

    });
    check = check.toString();
    if ($('#adesao').val() == '' && $('#posvenda').val() == 'SIM') {

        toastr.error('Informe o tipo da Adesão');
        $('#adesao').focus();
        return false;
    }
    if ($('#adesao').val() == 'BOLETO' && $('#status-boleto').val() == '') {

        toastr.error('Informe se o boleto foi pago');
        $('#status-boleto').focus();
        return false;
    }
    if ($('#classificacao').val() == '' && $('#posvenda').val() == 'SIM') {

        toastr.warning('Informe a Origem da Venda');
        $('#classificacao').focus();
        return false;
    }

    if ($('#status-boleto').val() == 'NAO' && $('#status').val() == 'CONCLUIDO') {

        toastr.warning('Cliente não Pagou a Parcela a Vista');
        return false;
    }
    if ($('#classificacao').val() == '7' && $('#select-consultor').val() == '') {

        toastr.warning('Insira o nome do Vendedor Externo');
        return false;
    }


    $.ajax({

        type: 'POST',
        url: 'control/posvenda/controle_inconsistencia.php?p=salve',
        data: data + '&tipo=' + check,
        success: function () {

            toastr.success('Atualizado com Sucesso');

            $('#modal-geral').modal('hide');

        }

    });

    $("#tabela_inconsistencia").dataTable().fnDestroy();

    listainconsistencia();
}