<?php

class Endereco_fibra
{
    private $array;
    private $pdo;
    private $consulta;
    private $estado;
    private $cidade;
    private $bairro;


    public function __construct()
    {

        try {
            $this->pdo = new PDO("mysql:dbname=redenilf_fibra;host=177.107.64.7", "redenilf_reports", "187982774");

        } catch (PDOException $e) {

            echo "Conexao com o BD Falhou: " . $e->getMessage();
        }
    }

    public function carrega_Estado()
    {

        $sql = 'select * from uf';
        $sql = $this->pdo->prepare($sql);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->estado = $sql->fetchAll();

        } else {
            echo "Invalid query";
        }

    }

    public function getEstado()
    {


        return $this->estado;
    }

    public function carrega_Cidade($id)
    {

        $sql = 'select * from cidade where cod_estado = :id';
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->cidade = $sql->fetchAll();

        } else {
            echo "Invalid query";
        }

    }

    public function getCidade()
    {


        return $this->cidade;
    }

    public function carrega_Bairro($id)
    {

        $sql = 'select * from bairro where cod_cidade = :id order by bairro';
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue('id', $id);
        $sql->execute();

        if ($sql->rowCount() > 0) {

            $this->bairro = $sql->fetchAll();

        } else {
            echo "Invalid query";
        }

    }

    public function busca_geral_personalizada($tabela){


        $sql = "select * from $tabela order by $tabela";
        $sql = $this->pdo->prepare($sql);
        $sql->execute();
        if ($sql->rowCount() > 0){

            $this->array = $sql->fetchAll();
        }else{

            echo "Invalid query";
        }

    }

    public function getBairro()
    {


        return $this->bairro;
    }

    public function carregaEndereco($cep)
    {

        $sql = "select * from endereco where cep = :cep";
        $sql = $this->pdo->prepare($sql);
        $sql->bindValue('cep', $cep);
        $sql->execute();
        if ($sql->rowCount() > 0) {

            $this->array = $sql->fetchAll();
            $this->consulta = 1;

        } else {
            $this->consulta = 0;
        }

    }

    public function inserir_endereco($cep, $cod_bairro, $nome_endereco)
    {

        $sql = 'INSERT INTO endereco set cep = ?, cod_bairro = ?, logradouro = ?';
        $sql = $this->pdo->prepare($sql);
        $sql->execute(array($cep, $cod_bairro, $nome_endereco));

        if ($sql->rowCount() > 0) {
            return 0;
        } else {
            return 1;
        }
    }

    public function inserirBairro($id_cidade, $bairro){

        $sql = 'INSERT INTO bairro set cod_cidade = ?, bairro = ?';
        $sql = $this->pdo->prepare($sql);
        $sql->execute(array($id_cidade, $bairro));

        if ($sql->rowCount() >  0){
            return 0;
        }else{
            return 1;
        }

    }

    public function getEndereco()
    {

        return $this->array;
    }

    public function getConsulta()
    {

        return $this->consulta;
    }


}

?>